<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="date exsl" xmlns:csv="csv:csv">
  <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="right-cell-style">

		<xsl:attribute name="border-right-color">#000000</xsl:attribute>
		<xsl:attribute name="border-right-width">1px</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<csv:columns>
		<column>position<desc>Platz</desc>
		</column>

		<column>r_businessunit_no<desc>Salon</desc>
		</column>
	
		<column>r_employee_nm<desc>Mitarbeiter</desc>
		</column>
		<column>r_planed_week_working_hours<desc>Std. Woche</desc>
		</column>
		<column>r_cnt_dt<desc>AT</desc>
		</column>

		<column>r_total_product_per_day<desc>davon VK pro Tag</desc>
		</column>

		<column>r_cnt_dt_prev_year<desc>AT (Vorjahr gleicher Zeitraum)</desc>
		</column>
		<column>r_total_product_per_day_prev_year<desc>davon VK pro Tag (Vorjahr gleicher Zeitraum)</desc>
		</column>
	</csv:columns>

	<xsl:template match="/">

		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">
					<xsl:variable name="filterRows">
						<filterRow>
							<content>
								<xsl:choose>
									<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
										Ansicht: ausführende MA  
									</xsl:when>
									<xsl:otherwise>
										Ansicht: beratende MA 
									</xsl:otherwise>
								</xsl:choose>
							</content>
						</filterRow>
					</xsl:variable>

				    <xsl:call-template name="header">
						<xsl:with-param name="title" select='"Hitliste VK"' />
						
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRows" select="$filterRows" />
					</xsl:call-template>

				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
								<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Hitliste VK  von &#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											&#160;bis&#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" border-collapse="collapse" width="100%" margin-top="0cm">

						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="17%"></fo:table-column>
						<fo:table-column column-width="15%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>

						<fo:table-column column-width="4%"></fo:table-column>
						<xsl:if test="not(report/report-params/EMPLOYEE_VIEW)">
							<fo:table-column column-width="7%"></fo:table-column>
						</xsl:if>
						<fo:table-column column-width="7%"></fo:table-column>

						<fo:table-column column-width="6%"></fo:table-column>
						<xsl:if test="not(report/report-params/EMPLOYEE_VIEW)">
							<fo:table-column column-width="6%"></fo:table-column>
						</xsl:if>
						<fo:table-column column-width="4%"></fo:table-column>

						<xsl:if test="not(report/report-params/EMPLOYEE_VIEW)">
							<fo:table-column column-width="6.5%"></fo:table-column>
							<fo:table-column column-width="6.5%"></fo:table-column>
						</xsl:if>

						<fo:table-column column-width="6.5%"></fo:table-column>
						<fo:table-column column-width="6.5%"></fo:table-column>


						<fo:table-header>
							<fo:table-row>

								<fo:table-cell text-align="center" number-columns-spanned="4" xsl:use-attribute-sets="th1bold-left right-cell-style" display-align="center">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>

								<xsl:choose>
									<xsl:when test="not(report/report-params/EMPLOYEE_VIEW)">
										<fo:table-cell text-align="center" number-columns-spanned="3" xsl:use-attribute-sets="th1bold  right-cell-style" display-align="center">
											<fo:block>
												Zeitraum
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center" number-columns-spanned="3" xsl:use-attribute-sets="th1bold right-cell-style" display-align="center">
											<fo:block>Vorjahr</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center" number-columns-spanned="4" xsl:use-attribute-sets="th1bold" display-align="center">
											<fo:block>Differenz</fo:block>
										</fo:table-cell>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="th1bold  right-cell-style" display-align="center">
											<fo:block>
												Zeitraum
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="th1bold right-cell-style" display-align="center">
											<fo:block>Vorjahr</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="th1bold" display-align="center">
											<fo:block>Differenz</fo:block>
										</fo:table-cell>
									</xsl:otherwise>
								</xsl:choose>

								

							</fo:table-row>

							<fo:table-row border-bottom="1px solid #000000">
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style" display-align="center">
									<fo:block>Platz </fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold" display-align="center">
									<fo:block>Salon</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold" display-align="center">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style" display-align="center">
									<fo:block>Soll Std</fo:block>
								</fo:table-cell>



								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold" display-align="center">
									<fo:block>AT</fo:block>
								</fo:table-cell>
								<xsl:if test="not(report/report-params/EMPLOYEE_VIEW)">
									<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold" display-align="center">
										<fo:block>Verkauf Gesamt</fo:block>
									</fo:table-cell>
								</xsl:if>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style" display-align="center">
									<fo:block>VK pro Tag</fo:block>
								</fo:table-cell>



								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold" display-align="center">
									<fo:block>AT</fo:block>
								</fo:table-cell>
								
								<xsl:if test="not(report/report-params/EMPLOYEE_VIEW)">
									<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold" display-align="center">
										<fo:block>Verkauf Gesamt</fo:block>
									</fo:table-cell>
								</xsl:if>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style" display-align="center">
									<fo:block>VK pro Tag</fo:block>
								</fo:table-cell>

								<xsl:if test="not(report/report-params/EMPLOYEE_VIEW)">
									<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold" display-align="center">
										<fo:block>Verkauf Gesamt</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"  xsl:use-attribute-sets="th1bold" display-align="center">
										<fo:block>%</fo:block>
									</fo:table-cell>
								</xsl:if>


								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold" display-align="center">
									<fo:block>VK pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold" display-align="center">
									<fo:block>%</fo:block>
								</fo:table-cell>

								
							</fo:table-row>
						</fo:table-header>

						<fo:table-body>
							<xsl:for-each select="/report/employeeRevenue/period/data/row">

								<xsl:variable name="grey_bg">
									<xsl:choose>
										<xsl:when test="position() mod 2 = 1">
											#FFFFFF
										</xsl:when>
										<xsl:otherwise>
											#CCCCCC
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<fo:table-row background-color="{$grey_bg}">



									<xsl:variable name="property" select="." />
									<xsl:variable name="posCd" select="r_pos_cd" />

									<xsl:variable name="companyNo" select="r_company_no" />
									<xsl:variable name="departmentNo" select="r_department_no" />
									<xsl:variable name="employeeNo" select="r_employee_no" />
									<xsl:variable name="position" select="position()"></xsl:variable>


									<xsl:variable name="prevYearRow" select="/report/employeeRevenue/comparePeriod/data/row[r_pos_cd = $posCd][r_employee_no = $employeeNo]"></xsl:variable>

									<xsl:variable name="buNm" select="/report/businessunits/row[pos_cd_hint = $posCd]/businessunit_nm"></xsl:variable>

								
									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" display-align="center">
										<fo:block>
											<xsl:value-of select="$position" />
										</fo:block>
									</fo:table-cell>


									<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0" display-align="center">
										<fo:block>
											<xsl:value-of select="$buNm" />
										</fo:block>
									</fo:table-cell>

									<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0" display-align="center">
										<fo:block>
											<xsl:value-of select="r_employee_nm" />
										</fo:block>
									</fo:table-cell>

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" display-align="center">
										<fo:block>
											<xsl:value-of select="format-number(r_planed_week_working_hours, '###.##0,##','amount')" />
										</fo:block>
									</fo:table-cell>

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
										<fo:block>
											<xsl:value-of select="format-number(r_cnt_dt, '###.##0,##','amount')" />
										</fo:block>
									</fo:table-cell>

									<xsl:if test="not(/report/report-params/EMPLOYEE_VIEW)">
										<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
											<fo:block>
												<xsl:value-of select="format-number(r_total_products, '###.##0,00', 'money')" />
											</fo:block>
										</fo:table-cell>
									</xsl:if>
									

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" display-align="center">
										<fo:block>
											<xsl:value-of select="format-number(r_total_product_per_day, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
										<fo:block>
											<xsl:value-of select="format-number($prevYearRow/r_cnt_dt,  '###.##0,##','amount')" />
										</fo:block>
									</fo:table-cell>


									<xsl:if test="not(/report/report-params/EMPLOYEE_VIEW)">
										<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
											<fo:block>
												<xsl:value-of select="format-number($prevYearRow/r_total_products, '###.##0,00', 'money')" />
											</fo:block>
										</fo:table-cell>
									</xsl:if>

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" display-align="center">
										<fo:block>
											<xsl:value-of select="format-number($prevYearRow/r_total_product_per_day, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>


									<xsl:if test="not(/report/report-params/EMPLOYEE_VIEW)">
										<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
											<fo:block>
												<xsl:value-of select="format-number((r_total_products - $prevYearRow/r_total_products), '###.##0,00', 'money')" />
											</fo:block>
										</fo:table-cell>

										<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
											<fo:block>
												<xsl:variable name="compare">
													<xsl:choose>
														<xsl:when test="$prevYearRow/r_total_products > 0">
															<xsl:value-of select="$prevYearRow/r_total_products" />
														</xsl:when>
														<xsl:otherwise>	
														0
														</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="base">
													<xsl:choose>
														<xsl:when test="r_total_products > 0">
															<xsl:value-of select="r_total_products" />
														</xsl:when>
														<xsl:otherwise>	
														0
														</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:choose>
							<xsl:when test="$compare != 0">
								<xsl:value-of select="format-number(($base div $compare - 1) * 100, '###.##0,00', 'amount')" />%
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>-</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
											</fo:block>
										</fo:table-cell>
									</xsl:if>
									

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
										<fo:block>
											<xsl:value-of select="format-number((r_total_product_per_day - $prevYearRow/r_total_product_per_day), '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									

									<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0" display-align="center">
										<fo:block>
											<xsl:variable name="compare">
												<xsl:choose>
													<xsl:when test="$prevYearRow/r_total_product_per_day > 0">
														<xsl:value-of select="$prevYearRow/r_total_product_per_day" />
													</xsl:when>
													<xsl:otherwise>	
													0
													</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
											<xsl:variable name="base">
												<xsl:choose>
													<xsl:when test="r_total_product_per_day > 0">
														<xsl:value-of select="r_total_product_per_day" />
													</xsl:when>
													<xsl:otherwise>	
													0
													</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
											<xsl:choose>
							<xsl:when test="$compare != 0">
								<xsl:value-of select="format-number(($base div $compare - 1) * 100, '###.##0,00', 'amount')" />%
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>-</xsl:text>
							</xsl:otherwise>
						</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									
									
								
								</fo:table-row>
							</xsl:for-each>

						</fo:table-body>

					</fo:table>



					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>


	</xsl:template>



</xsl:stylesheet>