<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="row_underline">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom">0.5pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="valueCell">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="tableCellTitle">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom">2pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="tableLastRow">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-top">1.5pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding">5pt</xsl:attribute>
		<xsl:attribute name="padding-right">1pt</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="tableCellValue">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">5pt</xsl:attribute>
		<xsl:attribute name="padding-right">1pt</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>

			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdate2">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdate3">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm" select="'01'">

		</xsl:variable>

		<xsl:variable name="dd" select="'01'">

		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdatedmm">
		<xsl:param name="datestr" />

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,4,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,1,2)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:choose>
					<xsl:when test="substring($dd,1,1) = 0">
						<xsl:value-of select="substring($dd,2,1)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$dd" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$mm" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="itemGroup">
		<xsl:param name="groupId" />

		<xsl:for-each select="/report/item_groups/row">

			<xsl:if test="id[text() = $groupId]">
				<xsl:if test="parent_item_group_cd[text() != '']">
					<xsl:call-template name="itemGroup">
						<xsl:with-param name="groupId" select="parent_item_group_cd" />
					</xsl:call-template>
					<xsl:text>/</xsl:text>
				</xsl:if>
				<xsl:value-of select="item_group_nm" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>




	<xsl:template name="itemMainGroup">
		<xsl:param name="groupId" />

		<xsl:for-each select="/report/item_groups/row">
 
			<xsl:if test="id[text() = $groupId]">
<xsl:choose>
				<xsl:when test="parent_item_group_cd[text() != '']">
					<xsl:call-template name="itemMainGroup">
						<xsl:with-param name="groupId" select="parent_item_group_cd" />
					</xsl:call-template>

				</xsl:when>
				<xsl:otherwise >
					<xsl:value-of select="item_group_nm" />
				</xsl:otherwise>
			</xsl:choose>
			</xsl:if>
			
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="formatdateElements">
		<xsl:param name="datestr" />
		<xsl:param name="element" />
		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:choose>
					<xsl:when test="$element='dd'">
						<xsl:value-of select="$dd" />
					</xsl:when>

					<xsl:when test="$element='mm'">
						<xsl:value-of select="$mm" />
					</xsl:when>

					<xsl:when test="$element='yyyy'">
						<xsl:value-of select="$yyyy" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$dd" />
						<xsl:value-of select="'.'" />
						<xsl:value-of select="$mm" />
						<xsl:value-of select="'.'" />
						<xsl:value-of select="$yyyy" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:output method="text" encoding="windows-1252"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />

	<csv:columns>
		<column>
			payment_orig_unformated
			<desc>Umsatz (ohne Soll/Haben-Kz)</desc>
		</column>


	</csv:columns>

	<xsl:template match="/">

		<!-- Output the DATEV header -->
		<xsl:text>"Studio"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Lfd-Nr"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Uhrzeit"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Wochentag"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Tag"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Monat"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Jahr"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"KundenNr"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Anrede"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Vorname"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Nachname"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Geburtstag"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde PLZ"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Email"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Werbematerial"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Untergruppe A"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Untergruppe B"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Altersgruppe"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Kundengruppe"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Kunde Anzahl Besuche"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Mitarbeiter Name"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Mitarbeiter Nr"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Leistung/Produkt Anzahl"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Leistung/Produkt Linie"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Leistung/Produkt Nummer"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Leistung/Produkt Beschreibung"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Leistung/Produkt DL/VK"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Umsatz"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Rabatte"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Nettoumsatz"</xsl:text>
		<xsl:value-of select="$delimiter" />	
		<xsl:text>"Provisionspreis"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Verkaufsprovision"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>
</xsl:text>

		<xsl:variable name="dd" select="'dd'"></xsl:variable>
		<xsl:variable name="mm" select="'mm'"></xsl:variable>
		<xsl:variable name="yyyy" select="'yyyy'"></xsl:variable>

		<xsl:for-each select="/report/order_positions/row">
			<xsl:variable name="customerNo" select="customer_no"></xsl:variable>
			<xsl:variable name="salesInvId" select="sales_inv_id"></xsl:variable>
			<xsl:variable name="posCd" select="pos_cd"></xsl:variable>
			<xsl:variable name="tenantNo" select="tenant_no"></xsl:variable>
			<xsl:variable name="itemCd" select="item_cd"></xsl:variable>
			<xsl:variable name="parentItemGroupCd" select="/report/items/row[item_cd=$itemCd]/item_group_cd"></xsl:variable>
			<xsl:variable name="vConditionCd" select="v_condition_cd"></xsl:variable>
			<xsl:variable name="ccConditionCd" select="cc_condition_cd"></xsl:variable>
			
			<xsl:variable name="posVConditionCd" select="pos_v_condition_cd"></xsl:variable>
			<xsl:variable name="posCcConditionCd" select="pos_cc_condition_cd"></xsl:variable>
			
			<xsl:text>"</xsl:text>
			<xsl:value-of select="bu_nm_2" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="sales_inv_id" />
			<xsl:value-of select="$delimiter" />
			<xsl:call-template name="formattime">
				<xsl:with-param name="timestr" select="sales_inv_ts" />
			</xsl:call-template>


			<xsl:value-of select="$delimiter" />
			<xsl:text>""</xsl:text>
			<xsl:value-of select="$delimiter" />

			<xsl:call-template name="formatdateElements">
				<xsl:with-param name="datestr" select="sales_inv_ts" />
				<xsl:with-param name="element" select="$dd" />
			</xsl:call-template>

			<xsl:value-of select="$delimiter" />

			<xsl:call-template name="formatdateElements">
				<xsl:with-param name="datestr" select="sales_inv_ts" />
				<xsl:with-param name="element" select="$mm" />
			</xsl:call-template>
			<xsl:value-of select="$delimiter" />
			<xsl:call-template name="formatdateElements">
				<xsl:with-param name="datestr" select="sales_inv_ts" />
				<xsl:with-param name="element" select="$yyyy" />
			</xsl:call-template>
			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="customer_no" />
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:choose>
				<xsl:when
					test="customer_salutation">
					<xsl:value-of select="customer_salutation" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="customer_group_no=1"><xsl:text>Frau</xsl:text></xsl:if>
					<xsl:if test="customer_group_no=2"><xsl:text>Herr</xsl:text></xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="customer_first_nm" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="customer_contact_nm" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:if test="birthday">
				<xsl:call-template name="formatdate">
					<xsl:with-param name="datestr" select="birthday" />
				</xsl:call-template>
			</xsl:if>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="customer_postal_cd" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="email" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>""</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:choose>
				<xsl:when
					test="$posCcConditionCd = 'Beauty-Abo' and pos_cc_used = 1 ">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$posCcConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="$posVConditionCd = 'Beauty-Abo' and pos_cc_used = 1 ">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$posVConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="starts-with($posCcConditionCd, 'BA') and pos_cc_used = 1 ">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$posCcConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="starts-with($posVConditionCd, 'BA') and pos_cc_used = 1 ">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$posVConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="$ccConditionCd = 'Beauty-Abo' ">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$ccConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="$vConditionCd = 'Beauty-Abo'">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$vConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="starts-with($ccConditionCd, 'BA')">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$ccConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="starts-with($vConditionCd, 'BA')">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$vConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="$ccConditionCd = 'Bik+Bei+Ac'">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$ccConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="$vConditionCd = 'Bik+Bei+Ac'">
					<xsl:text>"</xsl:text><xsl:value-of select="/report/conditions/row[condition_cd=$vConditionCd]/condition_nm" /><xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:when
					test="cc_condition_cd = 'scard2' or  v_condition_cd = 'scard2'">
					<xsl:text>"S-Card"</xsl:text>
				</xsl:when>
				<xsl:when
					test="cc_condition_sales_pricelist_id > 0 and (customer_contract_no = 2 or (customer_contract_no > 20000  and not(customer_contract_no > 29999)))">
					<xsl:text>"S-Card"</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>"Nicht-S-Card"</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"Termin"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>""</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="customer_group_nm" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />


<xsl:value-of
				select="amountvisits" />
		

	<!--	<xsl:value-of
				select="/report/customer_visits/row[pos_cd=$posCd][customer_no=$customerNo]/amountvisits" />  -->
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="operating_employee_nm" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="operating_employee_no" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<!-- <xsl:value-of select="amount" /> -->
			<xsl:value-of select="$delimiter" />
			
			<xsl:text>"</xsl:text>
	<xsl:choose>
				<xsl:when test="stockable=1">
					<xsl:value-of select="/report/item_groups/row[id=$parentItemGroupCd]/item_group_nm" />
				</xsl:when>
				<xsl:otherwise>
				<xsl:call-template name="itemMainGroup">
					<xsl:with-param name="groupId" select="$parentItemGroupCd" />
				</xsl:call-template> 
				</xsl:otherwise>
			</xsl:choose> 
			
				
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="item_cd" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="item_nm" />
			<xsl:text>"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:choose>
				<xsl:when test="stockable=1">
					<xsl:text>"Verkauf"</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>"Dienstleistungen"</xsl:text>
				</xsl:otherwise>
			</xsl:choose>


			<xsl:variable name="discount">
				<xsl:choose>
					<xsl:when
						test="/report/sales_inv_cash_discount/row[pos_cd=$posCd][sales_inv_id=$salesInvId]/cashdiscount != 0">
						<xsl:value-of
							select="/report/sales_inv_cash_discount/row[pos_cd=$posCd][sales_inv_id=$salesInvId]/cashdiscount div /report/sales_inv_position_cnt/row[pos_cd=$posCd][sales_inv_id=$salesInvId]/amountpositions" />
					</xsl:when>
					<xsl:otherwise>  
						<xsl:value-of select="0" />
					</xsl:otherwise>
				</xsl:choose> 
			</xsl:variable>

			<xsl:variable name="grossPrice">
				<xsl:value-of select="position_gross_price - $discount" />
			</xsl:variable>

			<xsl:variable name="netPrice">
				<xsl:value-of select="$grossPrice div (1 + (tax_rate_percent div 100))" />
			</xsl:variable>
			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="format-number($grossPrice , '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />

			<xsl:value-of
				select="format-number(rebate_rate_percent , '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="format-number( $netPrice , '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="format-number(position_commission_price , '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="format-number( commission_on_sales , '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />
			<xsl:text>
</xsl:text>
		</xsl:for-each>



	</xsl:template>
</xsl:stylesheet>