<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" 	xmlns:exsl="http://exslt.org/common" 
	extension-element-prefixes="barcode exsl date">
    <xsl:import href="Header.xsl"/>
<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>



	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">


				<xsl:variable name="prices">
					<xsl:for-each select="report/productConsumptionStock/row">
						<xsl:variable name="vItemCd" select="r_item_cd/text()" />#

						<xsl:variable name="price">
							<xsl:value-of select="/report/purchase_item_prices/row[item_cd=$vItemCd]/item_net_price" />
						</xsl:variable>
						<xsl:if test="$price > 0">
							<row>
								<xsl:value-of select="$price * r_amount" />
							</row>
						</xsl:if>



					</xsl:for-each>

				</xsl:variable>


					<xsl:variable name="filterRows">
						<filterRow>
							<content>
								Lagerbewegung:
								<xsl:choose>
									<xsl:when test="report/report-params/STOCK_TYPE = 2" >
										Einkauf
									</xsl:when>
									<xsl:when test="report/report-params/STOCK_TYPE = 4" >
										Kabinett
									</xsl:when>
									<xsl:when test="report/report-params/STOCK_TYPE = 5" >
										Umbuchen
									</xsl:when>
									<xsl:when test="report/report-params/STOCK_TYPE = 3" >
										Korrektur
									</xsl:when>
									<xsl:otherwise>
									 -
									</xsl:otherwise>
								</xsl:choose>
							</content>
						</filterRow>
						<filterRow>
							<content>
								Lieferant: &#160;<xsl:value-of select="report/supplierNm/row/supplier_nm" />
							</content>
						</filterRow>
						<filterRow>
							<content>
								Gesamtwert: &#160;<xsl:value-of select="format-number(sum(exsl:node-set($prices)/row), '###.##0,00', 'money')" />
							</content>
						</filterRow>
					</xsl:variable>







					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Lagerbewegungen"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRows" select="$filterRows" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left" font-size="8pt">
						<fo:table>	
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="60%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						
						<fo:table-body>
						  <fo:table-row>
						    <fo:table-cell text-align="left" xsl:use-attribute-sets="text-style">
						    	<fo:block>
						    		Erstellt:
									<xsl:call-template name="formatdate">
							             <xsl:with-param name="datestr" select="report/report-params/NOW"/>
							        </xsl:call-template>
							   	</fo:block>
						    </fo:table-cell>
						    <fo:table-cell text-align="center" xsl:use-attribute-sets="text-style">
						    	<fo:block>
						    		Lagerbewegungen  
						    		<xsl:call-template name="formatdate">
							             <xsl:with-param name="datestr" select="report/report-params/DATE"/>
							        </xsl:call-template>
									 - 
									<xsl:call-template name="formatdate">
							             <xsl:with-param name="datestr" select="report/report-params/TODATE"/>
							        </xsl:call-template> 
							        &#160;&#160;&#160;
							        <xsl:value-of select="report/businessunits/row/businessunit_nm" />, 
									<xsl:value-of select="report/businessunits/row/bu_city" />
						    	</fo:block>
						    </fo:table-cell>
						    <fo:table-cell text-align="right" xsl:use-attribute-sets="text-style">
						   		<fo:block>
							     	Seite
									<fo:page-number />
									von
									<fo:page-number-citation ref-id="LastPage" />
								</fo:block>
						    </fo:table-cell>
						  </fo:table-row>
						</fo:table-body>
						
						</fo:table>	
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					
					<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>


					<fo:table table-layout="fixed" border-collapse="collapse" 
						 width="100%">
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="32%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="14%"></fo:table-column>
													<fo:table-header>
								<fo:table-row>

									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold-left">
										<fo:block>Ranking</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold">
										<fo:block>Produkt</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold">
										<fo:block>Produkt Nr.</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold">
										<fo:block>Lieferant</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold">
										<fo:block>EK</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold">
										<fo:block>Anzahl</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="th1bold">
										<fo:block>Letzte Ausbuchung</fo:block>
									</fo:table-cell>
									
								</fo:table-row>
							</fo:table-header>
						<fo:table-body>



							
						<xsl:for-each select="report/productConsumptionStock/row">
							<xsl:variable name="vItemCd" select="r_item_cd/text()" />
								
								<fo:table-row>

									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:number value="position()" format="1" />

										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style">
											<fo:block>
											<xsl:value-of select="r_item_nm" />

										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_item_cd" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:for-each select="/report/item_suppliers/row[item_cd=$vItemCd]/contact_nm">

												<xsl:value-of
													select="concat(substring(', ', 1 div (position()!=1)), .)" />
											</xsl:for-each>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(/report/purchase_item_prices/row[item_cd=$vItemCd]/item_net_price, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>						
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										
												<fo:block>
												<xsl:value-of select="format-number(r_amount, '###.##0', 'amount')" />
										
										</fo:block>
										
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										
											<fo:block>
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr"
														select="r_max_stock_dln_ts" />
												</xsl:call-template>
											</fo:block>
										
									</fo:table-cell>
									
								</fo:table-row>

							</xsl:for-each>
							
							
						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>