<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="color">white</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">gray</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">dashed</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.1mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.1mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<fo:block-container xsl:use-attribute-sets="report-title">
						<fo:block>
							Sitzungsprotokoll
							<xsl:call-template name="formatdate">
								<xsl:with-param name="datestr" select="report/report-params/DATE" />
							</xsl:call-template>
						</fo:block>
						<fo:block>
							Kasse:
							<xsl:value-of select="report/report-params/POS_CD" />
							,
							<xsl:value-of select="report/businessunits/row/businessunit_nm" />
						</fo:block>
						<fo:block>
							Sitzung:
							<xsl:value-of select="report/cash_start/row/pos_session_cd" />
						</fo:block>
						<fo:block>
							Schublade:
							<xsl:value-of select="report/report-params/DRAWER_NO" />
						</fo:block>

						<fo:block>
							erstellt am
							<xsl:call-template name="formatdatetime">
								<xsl:with-param name="datetimestr" select="report/report-params/NOW" />
							</xsl:call-template>
						</fo:block>

					</fo:block-container>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdatetime">
												<xsl:with-param name="datetimestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/cash_start/row/pos_session_cd" />
											,
											<xsl:value-of select="report/report-params/DRAWER_NO" />
											- Sitzungsprotokoll -
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					<fo:table border-collapse="separate" table-layout="fixed"
						border="1" width="100%">
						<fo:table-column column-width="17cm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Offene Posten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Anzahl Bons
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Offen
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Gesamt
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/open/row/c_total" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/open/row/r_total" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Älter als 30 Tage
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/open30/row/c_total" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/open30/row/r_total" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Berichtstag
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/open_d/row/c_total" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/open_d/row/r_total" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Tagesumsätze</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Umsätze
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Stornos
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Summe
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Anzahl Belege
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/notes/row/r_revenue" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/notes/row/r_canceled" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Gesamt
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_revenue" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_canceled" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_total" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Dienstleistungen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_revenue_services" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_canceled_services" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_total_services" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Produkte
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_revenue_products" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_canceled_products" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/revenue/row/r_total_products" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Einnahmen aus Verkäufen</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Bareinnahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cash_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															EC-Einnahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_ec_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Kreditkarten-Einnahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cc_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Gutschein-Einreichungen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_voucher_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Überweisung
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_transfer_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Anrechnung Gutschrift
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_creditnote_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>

												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Gewährte Skonti
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_discount_sales_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Ausgaben aus Einkäufen</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Barausgaben
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_cash_purchase_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Überweisung
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_transfer_purchase_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Gutscheine</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Einreichung
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_voucher_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>

												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Aushändigung
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_voucher_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>

												</fo:table-row>

											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Gutschriften</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>

												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Einreichung Gutschrift
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_creditnote_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>

												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Ausgabe Gutschrift
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_creditnote_sales_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Kasse (Bargeld)</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table border-collapse="separate" table-layout="fixed"
											border="1" width="100%">
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-column column-width="2.5cm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Anfangsbestand
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/cash_start/row/cash_start" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Einlagen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cash_in" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Entnahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cash_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Einnahmen aus Verkauf
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cash_sales_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Ausgaben durch Einkauf
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of
																select="report/pos_sessions/row/t_cash_purchase_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>

												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Rückzahlungen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cash_debt_in" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Ausleihen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/pos_sessions/row/t_cash_debt_out" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															Endbestand
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>
															<xsl:value-of select="report/cash_end/row/cash_end" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell" number-columns-spanned="2">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<fo:table border-collapse="separate" table-layout="fixed"
						border="1" width="100%">
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="3cm"></fo:table-column>
						<fo:table-column column-width="2.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell" number-columns-spanned="8">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title" number-columns-spanned="8">
									<fo:block>Kassenjournal Bar</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>ID</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zeit</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Typ</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Betrag BAR</fo:block>
								</fo:table-cell>
							
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Beleg</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Zahlung</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zahlung Storno Grund</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/cash_start/row/session_start_ts" />
										</xsl:call-template>
										<!-- <xsl:value-of select="report/cash_start/row/session_start_ts" 
											/> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block>Anfangsbestand</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="minicell">
									<fo:block>
										<xsl:value-of select="report/cash_start/row/cash_start" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="report/pos_payments/row">
								<xsl:choose>
									<xsl:when test="payment_type=2">
									</xsl:when>
									<xsl:when test="payment_type=4">
									</xsl:when>
									<xsl:when test="payment_type=5">
									</xsl:when>
									<xsl:when test="payment_type=6">


									</xsl:when>
									<xsl:when test="payment_type=7">


									</xsl:when>
									<xsl:when test="payment_type=8">


									</xsl:when>
									<xsl:when test="payment_type=9">


									</xsl:when>
									<xsl:when test="payment_type=10">


									</xsl:when>
									<xsl:when test="payment_type=11">


									</xsl:when>
									<!-- <xsl:when test="payment_type=3"> <xsl:value-of select="payment" 
										/> &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> </xsl:when> -->
									<xsl:otherwise>

										<fo:table-row>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="pos_session_id" />
													.
													<xsl:value-of select="pos_payment_id" />
													.
													<xsl:value-of select="payment_type" />
													.
													<xsl:value-of select="payment_direction" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:call-template name="formatdatetime">
														<xsl:with-param name="datetimestr" select="payment_ts" />
													</xsl:call-template>
													<!-- <xsl:value-of select="payment_ts" /> -->
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="report_nm" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:choose>
														<xsl:when test="payment_type=1">

															<fo:block>
																<xsl:value-of select="payment_diff" />
																&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
															</fo:block>
														</xsl:when>
														<!-- <xsl:when test="payment_type=3"> <xsl:value-of select="payment" 
															/> &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> </xsl:when> -->
														<xsl:otherwise>
														</xsl:otherwise>
													</xsl:choose>
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="ref_txt" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="payment_ref" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="cancel_reason" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="employee_nm" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/cash_end/row/session_end_ts" />
										</xsl:call-template>
										<!-- <xsl:value-of select="report/cash_end/row/session_end_ts" 
											/> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block>Endbestand</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="minicell">
									<fo:block>
										<xsl:value-of select="report/cash_end/row/cash_end" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="minicell">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:table border-collapse="separate" table-layout="fixed"
						border="1" width="100%">
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="3cm"></fo:table-column>
						<fo:table-column column-width="2.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell" number-columns-spanned="8">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title" number-columns-spanned="8">
									<fo:block>Kassenjournal UnBar</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>ID</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zeit</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Typ</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Betrag unbar</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Beleg</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Zahlung</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zahlung Storno Grund</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:for-each select="report/pos_payments/row">
								<xsl:choose>
									<xsl:when test="payment_type=1">


									</xsl:when>
									<xsl:when test="payment_type=2">


									</xsl:when>
									<xsl:when test="payment_type=6">


									</xsl:when>
									<xsl:when test="payment_type=7">


									</xsl:when>
									<xsl:when test="payment_type=10">


									</xsl:when>
									<xsl:when test="payment_type=11">


									</xsl:when>
									<!-- <xsl:when test="payment_type=3"> <xsl:value-of select="payment" 
										/> &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> </xsl:when> -->
									<xsl:otherwise>


										<fo:table-row>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="pos_session_id" />
													.
													<xsl:value-of select="pos_payment_id" />
													.
													<xsl:value-of select="payment_type" />
													.
													<xsl:value-of select="payment_direction" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:call-template name="formatdatetime">
														<xsl:with-param name="datetimestr" select="payment_ts" />
													</xsl:call-template>
													<!-- <xsl:value-of select="payment_ts" /> -->
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="report_nm" />
												</fo:block>
											</fo:table-cell>

											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="minicell">
												<fo:block>


													<xsl:value-of select="payment" />
													&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="ref_txt" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="payment_ref" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="cancel_reason" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="employee_nm" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>


						</fo:table-body>
					</fo:table>
					<fo:table border-collapse="separate" table-layout="fixed"
						border="1" width="100%">
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="3cm"></fo:table-column>
						<fo:table-column column-width="2.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell" number-columns-spanned="8">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title" number-columns-spanned="8">
									<fo:block>Kassenjournal Gutschein/Gutschrift</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>ID</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zeit</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Typ</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Betrag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Beleg</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Zahlung</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zahlung Storno Grund</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:for-each select="report/pos_payments/row">
								<xsl:choose>
									<xsl:when test="payment_type=1">


									</xsl:when>
									<xsl:when test="payment_type=4">


									</xsl:when>
									<xsl:when test="payment_type=5">


									</xsl:when>
									<xsl:when test="payment_type=6">


									</xsl:when>
									<xsl:when test="payment_type=8">


									</xsl:when>
									<xsl:when test="payment_type=9">


									</xsl:when>
									<xsl:when test="payment_type=10">


									</xsl:when>

									<!-- <xsl:when test="payment_type=3"> <xsl:value-of select="payment" 
										/> &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> </xsl:when> -->
									<xsl:otherwise>


										<fo:table-row>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="pos_session_id" />
													.
													<xsl:value-of select="pos_payment_id" />
													.
													<xsl:value-of select="payment_type" />
													.
													<xsl:value-of select="payment_direction" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:call-template name="formatdatetime">
														<xsl:with-param name="datetimestr" select="payment_ts" />
													</xsl:call-template>
													<!-- <xsl:value-of select="payment_ts" /> -->
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="report_nm" />
												</fo:block>
											</fo:table-cell>

											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="minicell">
												<fo:block>


													<xsl:value-of select="payment" />
													&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="ref_txt" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="payment_ref" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="cancel_reason" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="employee_nm" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>


						</fo:table-body>
					</fo:table>
					
										<fo:table border-collapse="separate" table-layout="fixed"
						border="1" width="100%">
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="3cm"></fo:table-column>
						<fo:table-column column-width="2.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell" number-columns-spanned="8">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title" number-columns-spanned="8">
									<fo:block>Kassenjournal Nachlass</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>ID</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zeit</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Typ</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Betrag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Beleg</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Referenz Zahlung</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Zahlung Storno Grund</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="minicell">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:for-each select="report/pos_payments/row">
								<xsl:choose>
									<xsl:when test="payment_type=1">


									</xsl:when>
									<xsl:when test="payment_type=2">


									</xsl:when>
									<xsl:when test="payment_type=4">


									</xsl:when>
									<xsl:when test="payment_type=5">


									</xsl:when>
									<xsl:when test="payment_type=7">


									</xsl:when>
									<xsl:when test="payment_type=8">


									</xsl:when>
									<xsl:when test="payment_type=9">


									</xsl:when>
									<xsl:when test="payment_type=11">


									</xsl:when>

									<!-- <xsl:when test="payment_type=3"> <xsl:value-of select="payment" 
										/> &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> </xsl:when> -->
									<xsl:otherwise>


										<fo:table-row>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="pos_session_id" />
													.
													<xsl:value-of select="pos_payment_id" />
													.
													<xsl:value-of select="payment_type" />
													.
													<xsl:value-of select="payment_direction" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:call-template name="formatdatetime">
														<xsl:with-param name="datetimestr" select="payment_ts" />
													</xsl:call-template>
													<!-- <xsl:value-of select="payment_ts" /> -->
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="report_nm" />
												</fo:block>
											</fo:table-cell>

											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="minicell">
												<fo:block>


													<xsl:value-of select="payment" />
													&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="ref_txt" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="payment_ref" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="cancel_reason" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="minicell">
												<fo:block>
													<xsl:value-of select="employee_nm" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>


						</fo:table-body>
					</fo:table>
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>