<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

    <xsl:import href="Header.xsl"/>
<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>
	

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>



	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Kundenkarten"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left" 
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Kundenkarten
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
				
					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm"></fo:table-column>
						<fo:table-column column-width="3mm"></fo:table-column>
						<fo:table-column column-width="65mm"></fo:table-column>
						
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Kundennummer
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/contact/row/contact_no" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Kundenname
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:choose>
								            <xsl:when test="report/contact/row/first_nm != ''"><xsl:value-of select="report/contact/row/first_nm" />&#160;<xsl:value-of select="report/contact/row/contact_nm" /></xsl:when>
								            <xsl:otherwise><xsl:value-of select="report/contact/row/contact_nm" /></xsl:otherwise>
								        </xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						
							
						
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="3"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="45mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
										<!-- 	<fo:table-column column-width="20mm"></fo:table-column> -->
											
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>Kartennummer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>Typ</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>Kondition</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>gültig ab</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>gültig bis</fo:block>
													</fo:table-cell>
												<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>Aktueller Punktestand</fo:block>
													</fo:table-cell>-->
												</fo:table-row>
												
												
												<xsl:for-each select="report/ccc/row">
													<xsl:variable name="grey_bg">
												        <xsl:choose>
												            <xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
												            <xsl:otherwise>#CCCCCC</xsl:otherwise>
												        </xsl:choose>
												    </xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="center" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="card_no" />
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:choose>
														            <xsl:when test="sales_pricelist_id != ''">Preisliste</xsl:when>
														            
														            <xsl:when test="sales_credit_cd != ''">Punkte</xsl:when>
														            <xsl:otherwise>Prozent</xsl:otherwise>
														        </xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
															<xsl:value-of select="condition_nm" />
															
															<!-- 	<xsl:choose>
														            <xsl:when test="sales_pricelist_id != ''"><xsl:value-of select="sales_pricelist_nm" /></xsl:when>
														            <xsl:when test="item_condition_cd != ''"><xsl:value-of select="item_condition_cd" /></xsl:when>
														            <xsl:when test="sales_credit_cd != ''"><xsl:value-of select="sales_credit_cd" /></xsl:when>
														        </xsl:choose> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr"
																		select="valid_from" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr"
																		select="valid_to" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
													<!-- 	<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
															<xsl:variable name="scp">
																<xsl:choose>
														            <xsl:when test="sales_credit_points != ''"><xsl:value-of select="sales_credit_points" /></xsl:when>
														            <xsl:otherwise>0</xsl:otherwise>
														        </xsl:choose>
															</xsl:variable>
															<fo:block>
																<xsl:choose>
														            <xsl:when test="sales_credit_cd != ''"><xsl:value-of select="$scp" /></xsl:when>
														            <xsl:otherwise>&#160;</xsl:otherwise>
														        </xsl:choose>
															</fo:block>
														</fo:table-cell> -->
														
													</fo:table-row>
												</xsl:for-each>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							
						</fo:table-body>
					</fo:table>
					
					
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>