<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
    <xsl:import href="Header.xsl"/>

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.1mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.1mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>






	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Umsatzbericht"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Umsatzbericht
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm"></fo:table-column>
						<fo:table-column column-width="3mm"></fo:table-column>
						<fo:table-column column-width="65mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum von
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/report-params/DATE" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum bis
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/report-params/TODATE" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Erstellungsdatum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/report-params/NOW" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell2">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>


						</fo:table-body>
					</fo:table>






					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="11%"></fo:table-column>
						<fo:table-column column-width="13%"></fo:table-column>
						<fo:table-column column-width="13%"></fo:table-column>
						<fo:table-column column-width="13%"></fo:table-column>
						<fo:table-column column-width="13%"></fo:table-column>
						<fo:table-column column-width="13%"></fo:table-column>
						<fo:table-column column-width="13%"></fo:table-column>
                        <fo:table-column column-width="11%"></fo:table-column>
						<fo:table-body>



							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Datum</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Tagesumsatz Gesamt</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Umsatz DL</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Umsatz Produkte</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Gutscheine</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Ausgegebene Gutscheine</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Stornos (Summe)</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Nachlass</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:for-each select="report/revenue/row">

								<xsl:variable name="vDay" select="daydt_d/text()" />

								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="/report/revenue/row[daydt_d=$vDay]/daydt" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/revenue/row[daydt_d=$vDay]/r_revenue, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>

											<xsl:value-of
												select="format-number(/report/revenue/row[daydt_d=$vDay]/r_revenue_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/revenue/row[daydt_d=$vDay]/r_revenue_products, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<fo:block>
												<xsl:value-of
													select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day[payment_dt=$vDay]/voucherInValue, '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</fo:block>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<fo:block>
												<xsl:value-of
													select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day[payment_dt=$vDay]/voucherOutValue, '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</fo:block>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>


											<xsl:value-of
												select="format-number(/report/notes/row[daydt_d=$vDay]/r_canceled_value, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<fo:block>
												<xsl:value-of
													select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day[payment_dt=$vDay]/discountValue, '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</fo:block>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</xsl:for-each>

							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>
										Summe
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenue/row/r_revenue), '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>

										<xsl:value-of
											select="format-number(sum(/report/revenue/row/r_revenue_services), '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenue/row/r_revenue_products), '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/voucherInValue), '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/voucherOutValue), '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>


										<xsl:value-of
											select="format-number(sum(/report/notes/row/r_canceled_value), '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
						
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold2">
									<fo:block>
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/discountValue), '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:block>
								</fo:table-cell>
							
	</fo:table-row>
						</fo:table-body>
					</fo:table>


					<xsl:for-each select="/report/drawers/row">

						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="16%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>
							<fo:table-column column-width="12%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="8" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										number-columns-spanned="8" xsl:use-attribute-sets="cell-subtitle">
										<fo:block>
											<xsl:value-of select="drawer_nm" />

										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="8" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Datum</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Bareinnahmen</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Einlagen</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Barausgaben</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Entnahmen</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>EC-Einnahmen / EC-Schnitt</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Kreditkarten- Einnahmen</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-title">
										<fo:block>Überweisungen</fo:block>
									</fo:table-cell>


								</fo:table-row>

								<xsl:variable name="drawerNo" select="drawer_no" />
								<xsl:for-each
									select="/report/pos_payment_statistics/pos_stats/pos_stats_day">
									<xsl:variable name="paymentDay" select="payment_dt" />

									<xsl:for-each
										select="/report/pos_payment_statistics/pos_stats/pos_stats_day[payment_dt=$paymentDay]/pos_stats_drawer/row[drawer_no=$drawerNo]">


										<fo:table-row>
											<fo:table-cell text-align="center"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<!-- <xsl:call-template name="formatdate"> <xsl:with-param name="datestr" 
														select="/report/pos_sessions/row[enddt_d=$vDay]/enddt" /> </xsl:call-template> -->
													<xsl:value-of select="$paymentDay" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(daySalesCashInValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(dayCashInValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(dayPurchaseCashOutValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(dayCashOutValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</fo:block>
											</fo:table-cell>

											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(ecValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</fo:block>
											</fo:table-cell>

											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(ccValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</fo:block>
											</fo:table-cell>


											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="cell">
												<fo:block>
													<xsl:value-of
														select="format-number(transferSIValue, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</fo:block>
											</fo:table-cell>
											
										
										</fo:table-row>

									</xsl:for-each>
								</xsl:for-each>

					 		<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											Summe
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/daySalesCashInValue), '###.##0,00', 'money')" />
										

										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/dayCashInValue), '###.##0,00', 'money')" />
										
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/dayPurchaseCashOutValue), '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/dayCashOutValue), '###.##0,00', 'money')" />
										
										</fo:block>
									</fo:table-cell>

									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/ecValue), '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>

									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/ccValue), '###.##0,00', 'money')" />
										
										</fo:block>
									</fo:table-cell>


									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold2">
										<fo:block>
											<xsl:value-of
												select="format-number(sum(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/transferSIValue), '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
								
									
								</fo:table-row>

							</fo:table-body>
						</fo:table>
					</xsl:for-each>

					<!-- <fo:block page-break-inside="avoid"> <fo:table table-layout="fixed" 
						width="33%"> <fo:table-column column-width="100%"></fo:table-column> <fo:table-body> 
						<fo:table-row height="50mm"> <fo:table-cell text-align="center" xsl:use-attribute-sets="cell"> 
						<fo:block>&#160;</fo:block> </fo:table-cell> </fo:table-row> <fo:table-row 
						border-top-style="solid"> <fo:table-cell text-align="center" xsl:use-attribute-sets="cell"> 
						<fo:block>Ort, Datum, Unterschrift</fo:block> </fo:table-cell> </fo:table-row> 
						</fo:table-body> </fo:table> </fo:block> -->


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>