<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="barcode date exsl">

	<xsl:import href="Header.xsl"/>

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding-top">0.25mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0.25mm</xsl:attribute>
		<xsl:attribute name="padding-left">2mm</xsl:attribute>
		<xsl:attribute name="padding-right">2mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding-top">0.25mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0.25mm</xsl:attribute>
		<xsl:attribute name="padding-left">2mm</xsl:attribute>
		<xsl:attribute name="padding-right">2mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="15mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">


				<fo:static-content flow-name="header">
				

					<xsl:variable name="filterRow">
						Mitarbeiter: &#160;
							<xsl:choose>
									<xsl:when test="not(report/employeenm/row/employee_nm)">
										Alle
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="report/employeenm/row/employee_nm" />
									</xsl:otherwise>
							</xsl:choose>
							
					</xsl:variable>
					
					<xsl:variable name="filterRows">	
						<filterRow>
							<content>
								<xsl:value-of select="$filterRow" />
							</content>
						</filterRow>
					</xsl:variable>
				
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Trinkgeld"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="viewMode" select='"Ansicht nach Wertstellungsdatum"' />
						<xsl:with-param name="filterRows" select="$filterRows" />
				
					</xsl:call-template>
				
				</fo:static-content>



				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%" />
							<fo:table-column column-width="60%" />
							<fo:table-column column-width="20%" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Trinkgeld
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">

	
				


	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
			<xsl:variable name="pos_sales_tip_employees_sum" select="exsl:node-set(report/pos_sales_tip_employees_sum)" />
				<fo:block-container margin-bottom="10px" >
					<fo:block   >
						<fo:table table-layout="fixed" width="100%" >
							
							<fo:table-column column-width="40%" />
							<fo:table-column column-width="40%" />
							<fo:table-column column-width="20%" />
							

							<fo:table-header>
								<fo:table-row>
										<fo:table-cell text-align="left" number-columns-spanned="3"
											xsl:use-attribute-sets="cell-title2">
											<fo:block>Trinkgeld Summen</fo:block>
										</fo:table-cell>
									
								</fo:table-row>
								<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="cell-title2">
											<fo:block>Mitarbeiter-Nr.</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="cell-title2">
											<fo:block>Mitarbeitername</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="cell-title2">
											<fo:block>Wert</fo:block>
										</fo:table-cell>
								</fo:table-row>
						
							</fo:table-header>		
							<fo:table-body>
							<xsl:if test="count($pos_sales_tip_employees_sum/row) = 0">
								
									<!-- leere Zeile -->
									<fo:table-row>
										<fo:table-cell text-align="left" number-columns-spanned="3"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:if>
								
								<xsl:if test="count($pos_sales_tip_employees_sum/row) != 0">
										<xsl:for-each select="$pos_sales_tip_employees_sum/row">
											<xsl:variable name="grey_bg">
												<xsl:choose>
													<xsl:when test="position() mod 2 = 1">
														#FFFFFF
													</xsl:when>
													<xsl:otherwise>
														#CCCCCC
													</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
											<fo:table-row background-color="{$grey_bg}">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:value-of select="employee_no" />
													
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left" 
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:value-of select="employee_nm" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:value-of select="format-number(tip_value, '###.##0,00', 'money')" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										
												</xsl:for-each>
												<fo:table-row>
															<fo:table-cell text-align="left"
																 xsl:use-attribute-sets="minicell-bold">
																<fo:block></fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right" xsl:use-attribute-sets="minicell-bold">
																<fo:block>Summe</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="minicell-bold">
																<fo:block>
																	<xsl:value-of
																		select="format-number(sum($pos_sales_tip_employees_sum/row/tip_value ), '###.##0,00', 'money')" />
																	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

																</fo:block>
															</fo:table-cell>
														</fo:table-row>
								</xsl:if>
							</fo:table-body>
						</fo:table>
						</fo:block>
					</fo:block-container>



<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="100%" />

							<fo:table-body>

								<xsl:variable name="pos_sales_tip" select="exsl:node-set(report/pos_sales_tip)" />
								<xsl:if test="count($pos_sales_tip/row) != 0">
									<fo:table-row>
										<fo:table-cell>
											<fo:block>
												<fo:table table-layout="fixed" width="100%">
													<fo:table-column column-width="15%" />
													<fo:table-column column-width="15%" />
													<fo:table-column column-width="60%" />
													<fo:table-column column-width="10%" />
												

													<fo:table-header>
													<fo:table-row>
															<fo:table-cell text-align="left" number-columns-spanned="4"
																xsl:use-attribute-sets="cell-title2">
																<fo:block>Trinkgelder Details</fo:block>
															</fo:table-cell>
														
													</fo:table-row>
																			
														<fo:table-row>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="cell-title2">
																<fo:block>Datum</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="cell-title2">
																<fo:block>Mitarbeiter-Nr.</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="cell-title2">
																<fo:block>Mitarbeitername</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="cell-title2">
																<fo:block>Wert</fo:block>
															</fo:table-cell>
															
														</fo:table-row>
													</fo:table-header>
													<fo:table-body>
														<xsl:for-each select="report/pos_sales_tip/row">
															<xsl:variable name="grey_bg">
																<xsl:choose>
																	<xsl:when test="position() mod 2 = 1">
																		#FFFFFF
																	</xsl:when>
																	<xsl:otherwise>
																		#CCCCCC
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:variable>
															<fo:table-row background-color="{$grey_bg}">
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="minicell">
																	<fo:block>
																	<xsl:call-template name="formatdate">
																		<xsl:with-param name="datestr" select="day" />
																	</xsl:call-template>
																		
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="minicell">
																	<fo:block>
																		<xsl:value-of select="employee_no" />
																	
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="left" 
																	xsl:use-attribute-sets="minicell">
																	<fo:block>
																		<xsl:value-of select="employee_nm" />
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="minicell">
																	<fo:block>
																		<xsl:value-of select="format-number(tip_value, '###.##0,00', 'money')" />
																	</fo:block>
																</fo:table-cell>
																
															</fo:table-row>
														</xsl:for-each>
														<fo:table-row>
															<fo:table-cell text-align="left"
																number-columns-spanned="2" xsl:use-attribute-sets="minicell-bold">
																<fo:block></fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right" xsl:use-attribute-sets="minicell-bold">
																<fo:block>Summe</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="minicell-bold">
																<fo:block>
																	<xsl:value-of
																		select="format-number(sum(report/pos_sales_tip/row/tip_value ), '###.##0,00', 'money')" />
																	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									
								</xsl:if>
							
							
								

							</fo:table-body>
						</fo:table>
 


 

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>