<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>



	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					    <xsl:call-template name="header">
						<xsl:with-param name="title" select='"Preisliste"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Preisliste
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm"></fo:table-column>
						<fo:table-column column-width="3mm"></fo:table-column>
						<fo:table-column column-width="65mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Preisliste
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/sales_pricelists/row/sales_pricelist_nm" />
										-
										<xsl:value-of
											select="report/sales_pricelist_instance/row/sales_pricelist_instance_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Gruppe
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/item_groups/row/item_group_nm" />

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Dls/Produkte
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/report-params/ITEM_FILTER_TYPE = 'dls'">
												Dienstleistungen
											</xsl:when>
											<xsl:when test="report/report-params/ITEM_FILTER_TYPE = 'products'">
												Produkte
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
										<xsl:value-of select="report/item_groups/row/item_group_nm" />

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										gültig ab
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/sales_pricelist_instance/row/valid_from" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										gültig bis
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/sales_pricelist_instance/row/valid_to" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="55mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>


											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Art.Nr.</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Beschreibung</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title">
														<fo:block>MwSt.</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Profession</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title">
														<fo:block>VK</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>

											<fo:table-body>
												<xsl:for-each select="/report/item-price-list/pricelist/itemList/row">
													<xsl:variable name="itemNm">
														<xsl:value-of select="itemNm"></xsl:value-of>
													</xsl:variable>
													<xsl:variable name="itemCd">
														<xsl:value-of select="itemCd"></xsl:value-of>
													</xsl:variable>
													<xsl:variable name="taxcd">
														<xsl:value-of select="taxCd"></xsl:value-of>
													</xsl:variable>
													
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#FFFFFF
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<xsl:choose>
														<xsl:when
															test="./itemProfList">
																		
															<xsl:for-each select="./itemProfList/itemProfElem">
																<xsl:variable name="itemprofessionno">
																	<xsl:value-of select="itemProfessionNo"></xsl:value-of>
																</xsl:variable>
																<fo:table-row background-color="{$grey_bg}">
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="cell">
																		<fo:block>
																			<xsl:value-of select="$itemCd" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="left"
																		xsl:use-attribute-sets="cell">
																		<fo:block>
																			<xsl:value-of select="$itemNm" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when
																					test="/report/purchase_item_prices/row[item_cd=$itemCd]/item_net_price != ''">
																					<xsl:value-of
																						select="format-number(/report/purchase_item_prices/row[item_cd=$itemCd]/item_net_price, '###.##0,00', 'money')" />
																					&#160;
																					<xsl:value-of select="$currencySymbol"></xsl:value-of>
																				</xsl:when>
																				<xsl:otherwise></xsl:otherwise>
			
																			</xsl:choose>
			
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="cell">
																		<fo:block>
																			<xsl:value-of select="/report/taxes/row[tax_cd=$taxcd]/tax_nm" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="cell">
																		<fo:block>
																			<xsl:value-of select="/report/item_professions/row[item_profession_no=$itemprofessionno]/item_profession_nm" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell">
																		<fo:block>
			
																			<xsl:choose>
			
																				<xsl:when test="itemSpecialPrice = 1">
																					S
																				</xsl:when>
																				<xsl:otherwise>
			
																					<xsl:choose>
			
																						<xsl:when test="itemGrossPrice != ''">
																							<xsl:value-of
																								select="format-number(itemGrossPrice, '###.##0,00', 'money')" />
																							&#160;
																							<xsl:value-of select="$currencySymbol"></xsl:value-of>
																						</xsl:when>
																						<xsl:otherwise></xsl:otherwise>
			
																					</xsl:choose>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
			
																</fo:table-row>
															</xsl:for-each>
														</xsl:when>
														<xsl:otherwise>
															<fo:table-row background-color="{$grey_bg}">
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																		<xsl:value-of select="$itemCd" />
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="left"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																		<xsl:value-of select="$itemNm" />
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																		<xsl:choose>
																			<xsl:when
																				test="/report/purchase_item_prices/row[item_cd=$itemCd]/item_net_price != ''">
																				<xsl:value-of
																					select="format-number(/report/purchase_item_prices/row[item_cd=$itemCd]/item_net_price, '###.##0,00', 'money')" />
																				&#160;
																				<xsl:value-of select="$currencySymbol"></xsl:value-of>
																			</xsl:when>
																			<xsl:otherwise></xsl:otherwise>
		
																		</xsl:choose>
		
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																		<xsl:value-of select="/report/taxes/row[tax_cd=$taxcd]/tax_nm" />
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																	
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																	</fo:block>
																</fo:table-cell>
		
															</fo:table-row>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>



											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>