<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="itemGroup">
		<xsl:param name="groupId" />

		<xsl:for-each select="/report/item_groups/row">

			<xsl:if test="id[text() = $groupId]">
				<xsl:if test="parent_item_group_cd[text() != '']">
					<xsl:call-template name="itemGroup">
						<xsl:with-param name="groupId" select="parent_item_group_cd" />
					</xsl:call-template>
					<xsl:text>/</xsl:text>
				</xsl:if>
				<xsl:value-of select="item_group_nm" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	
	
	<xsl:template match="/">
		
			<!-- Output the Produkt header -->
		<xsl:text>"Gruppen"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Art.-Nr."</xsl:text>
		<xsl:value-of select="$delimiter" />
			
		<xsl:text>"Name"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"EK"</xsl:text>
		<xsl:value-of select="$delimiter" />
			<!-- Output the Jedox header -->
		<xsl:text>"Lieferant"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Portfolio Code"</xsl:text>
		<xsl:value-of select="$delimiter" />
		
				<xsl:text>
</xsl:text>
					
		<xsl:for-each select="report/item-list/itemList/item">
        <xsl:text>"</xsl:text><xsl:call-template name="itemGroup">
									<xsl:with-param name="groupId" select="itemGroupCd" />
							</xsl:call-template><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"</xsl:text><xsl:value-of select="itemCd" /><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
			
		<xsl:text>"</xsl:text><xsl:value-of select="itemNm" /><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
			<xsl:text>"</xsl:text><xsl:value-of select="itemPurchasePrice" /><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
			
		<xsl:text>"</xsl:text><xsl:for-each select="supplierList/supplierNo">
												<xsl:variable name="selSupplierNo" select="."></xsl:variable>
												<xsl:for-each select="/report/supplier/row">

													<xsl:if test="id[text() = $selSupplierNo]">
														<xsl:choose>
															<xsl:when test="first_nm != ''">
																<xsl:value-of select="first_nm" />
																&#160;
																<xsl:value-of select="contact_nm" />
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="contact_nm" />
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>

												</xsl:for-each>
												<xsl:if test="position() = last() and position() != 1">
													,
												</xsl:if>
											</xsl:for-each><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>"</xsl:text><xsl:value-of select="portfolioCd" /><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
				<xsl:text>
</xsl:text>
	</xsl:for-each>

	</xsl:template>

</xsl:stylesheet>