<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">
   <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1Rotated">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="borderRotated">
		<xsl:attribute name="border-top-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableInnerSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
		<!-- <xsl:attribute name="font-weight">bold</xsl:attribute> -->
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableOuterSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderInnerSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderOuterSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="container_header">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.85cm</xsl:attribute>
	</xsl:attribute-set>
	
		<xsl:attribute-set name="containerHeader">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.00m</xsl:attribute>
		 <xsl:attribute name="width">3.0cm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	<xsl:attribute-set name="containerHeaderLabel">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.0cm</xsl:attribute>
		 <xsl:attribute name="margin-left">2mm</xsl:attribute>
		 <xsl:attribute name="keep-together">always</xsl:attribute>
		  <xsl:attribute name="padding-top">3mm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="tgDivision">
		<xsl:param name="divident" />
		<xsl:param name="divisor" />
		<xsl:param name="negativCorrection" />
			<xsl:choose>
				<xsl:when test="$divisor &lt; 0 and $divident &lt; 0">
					<xsl:value-of select="format-number($divident div  ($negativCorrection * $divisor ), '###.##0,00', 'money')" />
				</xsl:when>
				<xsl:when test="$divisor=0">
					0,00
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of	select="format-number($divident div  $divisor , '###.##0,00', 'money')" />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>


   <xsl:template name="rebateTableNoDataRow">
        <xsl:param name="title" />
       
            <fo:table-row  min-height="0.5cm">
                <fo:table-cell text-align="left"	number-columns-spanned="5" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="$title" />
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
    </xsl:template>

<xsl:template name="rebateTableTitleRow">
        <xsl:param name="title" />
        
            <fo:table-row >
                <fo:table-cell text-align="left"	number-columns-spanned="5" xsl:use-attribute-sets="cell-style0 text-bold">
                    <fo:block>
                        <xsl:value-of select="$title" />
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
    </xsl:template>



<xsl:template name="rebateTable">
    <xsl:param name="rebateInvs" />
	<xsl:param name="rebatePosPercent" />
	<xsl:param name="rebatePos" />
	<xsl:param name="employeeNm" />
	

	<fo:table table-layout="fixed" border-collapse="collapse" width="100%">
		<fo:table-column column-width="3.4cm"></fo:table-column>

	
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
<!--		<fo:table-column></fo:table-column>
		<fo:table-column></fo:table-column> -->

		<fo:table-header>
			<xsl:if test="$employeeNm != ''">
				<fo:table-row>
					<fo:table-cell text-align="left" xsl:use-attribute-sets="th1bold-left" number-columns-spanned="5">
						<fo:block>
							<xsl:value-of select="$employeeNm" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:if>
			<fo:table-row>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold-left">
					<fo:block>Rabatt Art</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold-left">
					<fo:block>Überschrift / Aktion</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Anzahl</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Gegebener Rabatt</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Rabatt in %</fo:block>
				</fo:table-cell>
		<!--		<fo:table-cell text-align="center"
					xsl:use-attribute-sets="th1bold">
					<fo:block>Umsatz vor Rabatt</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Umsatz nach Rabatt</fo:block>
				</fo:table-cell> -->
			</fo:table-row>
		</fo:table-header>
		<fo:table-body>
		
			<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="title" select="'Gesamtrabatt in %'" />
					<xsl:with-param name="data" select="$rebateInvs" />
			</xsl:call-template >
			

			<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="title" select="'Positionsrabatt in %'" />
					<xsl:with-param name="data" select="$rebatePosPercent" />
			</xsl:call-template >
										
			
			<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="title" select="'Positionsrabatt'" />
					<xsl:with-param name="data" select="$rebatePos" />
			</xsl:call-template >
			
		

			<!-- SUMMENANGABEN -->
			<fo:table-row>
				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0">
					<fo:block>
					Summe</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold-left">
					<fo:block></fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="sum($rebateInvs/anzahl) + sum($rebatePosPercent/anzahl)  + sum($rebatePos/anzahl) " />
					</fo:block>
				</fo:table-cell>

				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number((sum($rebateInvs/rr_rabate)  + sum($rebatePosPercent/rr_rabate)  + sum($rebatePos/rr_rabate) ), '###.##0,00', 'money')" />	
					</fo:block>
					
				</fo:table-cell>

				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
					<!--	<xsl:value-of select="format-number(( ( ((sum($rebateInvs/rr_rabate)  + sum($rebatePosPercent/rr_rabate)  + sum($rebatePos/rr_rabate)  )) div ($sumRebates/rr_rebate_base_price ) )   * 100) , '###.##0,00', 'money')" />% -->
					</fo:block>
				</fo:table-cell>

		<!--		<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number($sumRebates/rr_rebate_base_price  , '###.##0,00', 'money')" />
					</fo:block>
				</fo:table-cell>

				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number($sumRebates/rr_gross_price, '###.##0,00', 'money')" />
					</fo:block>
				</fo:table-cell>
-->
			</fo:table-row>
		</fo:table-body>
	</fo:table>


</xsl:template>


<xsl:template name="discountRebateTable">

	<xsl:param name="discounts" />
	

	<fo:table table-layout="fixed" border-collapse="collapse" width="100%">
		<fo:table-column column-width="3.4cm"></fo:table-column>

	
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
		<fo:table-column column-width="3.4cm"></fo:table-column>
	<!-- 	<fo:table-column></fo:table-column>-->
	<!--	<fo:table-column></fo:table-column>
		<fo:table-column></fo:table-column>
-->
		<fo:table-header>
			<fo:table-row>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold-left">
					<fo:block>Nachlass</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold-left">
					<fo:block>Überschrift / Aktion</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Anzahl</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Gegebener Rabatt</fo:block>
				</fo:table-cell>
		<!-- 		<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Rabatt in %</fo:block>
				</fo:table-cell> -->
		<!--		<fo:table-cell text-align="center"
					xsl:use-attribute-sets="th1bold">
					<fo:block>Umsatz vor Rabatt</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold">
					<fo:block>Umsatz nach Rabatt</fo:block>
				</fo:table-cell> -->
			</fo:table-row>
		</fo:table-header>
		<fo:table-body>
	
			
			<xsl:if test="$discounts">
				<xsl:call-template name="rebateTableContentDiscount">
					<xsl:with-param name="title" select="'Nachlässe'" />
					<xsl:with-param name="data" select="$discounts" />
				</xsl:call-template >
			</xsl:if>


			<!-- SUMMENANGABEN -->
			<fo:table-row>
				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0">
					<fo:block>
					Summe</fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="center" xsl:use-attribute-sets="th1bold-left">
					<fo:block></fo:block>
				</fo:table-cell>
				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="sum($discounts/anzahl)" />
					</fo:block>
				</fo:table-cell>

				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number( sum($discounts/rr_rabate), '###.##0,00', 'money')" />	
					</fo:block>
					
				</fo:table-cell>

	<!--			<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number(( (  sum($discounts/rr_rabate) div sum($discounts/rr_rebate_base_price) )   * 100) , '###.##0,00', 'money')" />%  
					</fo:block>
				</fo:table-cell>-->
<!--
				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number( sum($discounts/rr_rebate_base_price), '###.##0,00', 'money')" />
					</fo:block>
				</fo:table-cell>

				<fo:table-cell text-align="right" xsl:use-attribute-sets="th1bold">
					<fo:block>
						<xsl:value-of select="format-number(sum($discounts/rr_gross_price), '###.##0,00', 'money')" />
					</fo:block>
				</fo:table-cell>
-->
			</fo:table-row>
		</fo:table-body>
	</fo:table>


</xsl:template>





    <xsl:template name="rebateTableContent">
        <xsl:param name="title" />
        <xsl:param name="data" />
   
        <xsl:for-each select="$data">
            <fo:table-row>
				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="$title" />
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="reporting_nm" />
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="anzahl" />
                    </fo:block>
                </fo:table-cell> 
				<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="format-number(rr_rabate, '###.##0,00', 'money')" />
                    </fo:block>
                </fo:table-cell>

				<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="format-number(100 div rr_rebate_base_price * rr_rabate, '###.##0,00', 'money')" />%
                    </fo:block>
                </fo:table-cell>

            <!--    <fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0" >
                    <fo:block>
                        <xsl:value-of select="format-number(rr_rebate_base_price, '###.##0,00', 'money')" />
                    </fo:block>
                </fo:table-cell>
                
                <fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="format-number(rr_gross_price, '###.##0,00', 'money')" />
                    </fo:block>
                </fo:table-cell> -->
            </fo:table-row>
        </xsl:for-each>

    </xsl:template>

   <xsl:template name="rebateTableContentDiscount">
        <xsl:param name="title" />
        <xsl:param name="data" />
   
        <xsl:for-each select="$data">
            <fo:table-row>
				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="$title" />
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="reporting_nm" />
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="anzahl" />
                    </fo:block>
                </fo:table-cell> 
				<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="format-number(rr_rabate, '###.##0,00', 'money')" />
                    </fo:block>
                </fo:table-cell>

		<!-- 		<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="format-number(100 div rr_rebate_base_price * rr_rabate, '###.##0,00', 'money')" />%
                    </fo:block>
                </fo:table-cell>
-->
            <!--    <fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0" >
                    <fo:block>
                        <xsl:value-of select="format-number(rr_rebate_base_price, '###.##0,00', 'money')" />
                    </fo:block>
                </fo:table-cell>
                
                <fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style0">
                    <fo:block>
                        <xsl:value-of select="format-number(rr_gross_price, '###.##0,00', 'money')" />
                    </fo:block>
                </fo:table-cell> -->
            </fo:table-row>
        </xsl:for-each>

    </xsl:template>

	<xsl:template name="employeeRebateTables">
		<xsl:param name="rebateInvs" />
		<xsl:param name="rebatePosPercent" />
		<xsl:param name="rebatePos" />
		<xsl:param name="employeeList" />
		


		<xsl:for-each select="$employeeList">
			<xsl:variable name="employeeNo" select="rr_employee_no" />
			<xsl:if test="$rebateInvs[rr_employee_no=$employeeNo] or $rebatePosPercent[rr_employee_no=$employeeNo] or $rebatePos[rr_employee_no=$employeeNo]">
				<xsl:if test="position() != 1">
					<fo:block-container height="1cm" xsl:use-attribute-sets="title-style">
						<fo:block></fo:block>
					</fo:block-container>
				</xsl:if>

				<xsl:call-template name="rebateTable">
					<xsl:with-param name="rebateInvs" select="$rebateInvs[rr_employee_no=$employeeNo]" />
					<xsl:with-param name="rebatePosPercent" select="$rebatePosPercent[rr_employee_no=$employeeNo]" />
					<xsl:with-param name="rebatePos" select="$rebatePos[rr_employee_no=$employeeNo]" />
					<xsl:with-param name="employeeNm" select="rr_employee_nm" />
					
				</xsl:call-template >
					
			</xsl:if>
		</xsl:for-each>                      

	</xsl:template>





	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">

					<xsl:variable name="title">
						Rabattaktionen
					</xsl:variable>
					<xsl:variable name="filterRow">
						Rabattaktion: &#160;
							<xsl:choose>
									<xsl:when test="not(report/fastInput/row/fast_input_nm)">
										Alle
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="report/fastInput/row/fast_input_nm" />
									</xsl:otherwise>
							</xsl:choose>
							
					</xsl:variable>

					<xsl:variable name="filterRows">
						<xsl:if test="report/employeemode/row/employee_mode">
							<filterRow>
								<content>
								Modus:&#160;
									<xsl:choose>
										<xsl:when test="report/employeemode/row/employee_mode">
											<xsl:choose>
												<xsl:when test="report/employeemode/row/employee_mode = 'ausf'">
													ausführende Mitarbeitern
												</xsl:when>
												<xsl:otherwise>
													beratende Mitarbeitern
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
									</xsl:choose>
								</content>
							</filterRow>
						</xsl:if>
						<filterRow>
							<content>
								<xsl:choose>
									<xsl:when test="report/employeemode/row/employee_mode">
										Mitarbeiter:&#160; <xsl:value-of select="/report/employee/row/employee_nm" />
									</xsl:when>
									<xsl:otherwise>
										Ansicht:&#160; Salon
									</xsl:otherwise>
								</xsl:choose>
							</content>
						</filterRow>
						<filterRow>
							<content>
								<xsl:value-of select="$filterRow" />
							</content>
						</filterRow>
					</xsl:variable>

					<xsl:call-template name="header">
						<xsl:with-param name="title" select="$title" />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRows" select="$filterRows" />
						<xsl:with-param name="viewMode" select='"Ansicht nach Wertstellungsdatum"' />

					</xsl:call-template>


				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Rabattaktionen
											<xsl:if test="report/employeemode/row/employee_mode">
												<xsl:choose>
													<xsl:when test="report/employeemode/row/employee_mode = 'ausf'">
														bei ausführenden Mitarbeitern
													</xsl:when>
													<xsl:otherwise>
														bei beratenden Mitarbeitern
													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

			    <fo:flow flow-name="xsl-region-body">
				

					<xsl:choose>
						<xsl:when test="not(report/employeeList/row)">
							<xsl:call-template name="rebateTable">
								<xsl:with-param name="rebateInvs" select="report/rebatesInvPercent/row"/>
								<xsl:with-param name="rebatePosPercent" select="report/rebatesPosPercent/row" />
								<xsl:with-param name="rebatePos" select="report/rebatesPos/row"/>
							
								
							</xsl:call-template>
<fo:block >
 &#160;
</fo:block>
							<xsl:call-template name="discountRebateTable">
					
								<xsl:with-param name="discounts" select="report/disounts/row" />
					
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="employeeRebateTables">
								<xsl:with-param name="rebateInvs" select="report/rebatesInvPercent/row"/>
								<xsl:with-param name="rebatePosPercent" select="report/rebatesPosPercent/row" />
								<xsl:with-param name="rebatePos" select="report/rebatesPos/row"/>
								<xsl:with-param name="employeeList" select="report/employeeList/row"/>
								
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
        			
				

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
