<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox" xmlns:csv="csv:csv">
   
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />


	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	



    <xsl:template name="rebateTableContent">
        <xsl:param name="data" />
		<xsl:param name="rebateType" />
      	<xsl:for-each select="$data">

				<xsl:variable name="property" select="." />
				<!-- Loop through the columns in order -->
				<xsl:for-each select="document('')/*/csv:columns/*">
					<!-- Extract the column name and value -->
					<xsl:variable name="column" select="./text()" />
					<xsl:variable name="value" select="$property/*[name() = $column]" />
					<xsl:choose>
					
						<xsl:when test="$column='anzahl'">
							 <xsl:value-of select="format-number($value, '###.##0,##', 'amount')" />
						</xsl:when>
						<xsl:when test="$column='rr_rabate'">
							 <xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
						</xsl:when>
						<xsl:when test="$column='rebate_type'">
								<xsl:text>"</xsl:text><xsl:value-of select="$rebateType" /><xsl:text>"</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<!-- Add the delimiter unless we are the last expression -->
					<xsl:if test="position() != last()">
						<xsl:value-of select="$delimiter" />
					</xsl:if>
				</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
   
     
    </xsl:template>



	<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
        <column>rebate_type<desc>Rabattart</desc></column>
		<column>reporting_nm<desc>Rabattaktion</desc></column>
		<column>rr_customer_no<desc>Knd.-Nr</desc></column>
		<column>first_nm<desc>Vorname</desc></column>
		<column>contact_nm<desc>Nachname</desc></column>
		<column>customer_phone<desc>Telefon</desc></column>
		<column>customer_mobile<desc>Handy</desc></column>
		<column>customer_email<desc>email</desc></column>
		<column>customer_postal_cd<desc>PLZ</desc></column>
		<column>customer_city<desc>Ort</desc></column>
		<column>customer_street<desc>Straße</desc></column>

		<column>anzahl<desc>Anzahl</desc></column>
		<column>rr_rabate<desc>Rabatt</desc></column>
	
		
	</csv:columns>


	<xsl:template name="rebateTable">
	 	<xsl:param name="rebatesInvPercent"/>
		<xsl:param name="rebatesPosPercent"/>
		<xsl:param name="rebatesPos"/>
		<xsl:param name="disounts"/>
		<xsl:param name="employeeNm" select="'-#'"/>

		<xsl:text>&#xa;</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		
		<xsl:if test="not($employeeNm ='-#')">
			<xsl:value-of select="$employeeNm" />
		</xsl:if>
		<xsl:text>&#xa;</xsl:text>
		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>&#xa;</xsl:text>


		<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="data" select="$rebatesInvPercent" />
				<xsl:with-param name="rebateType" select="'Gesamtrabatt in %'" />
		</xsl:call-template >
		<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="data" select="$rebatesPosPercent" />
				<xsl:with-param name="rebateType" select="'Positionsrabatt in %'" />
		</xsl:call-template >
		<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="data" select="$rebatesPos" />
				<xsl:with-param name="rebateType" select="'Positionsrabatt'" />
		</xsl:call-template >
		<xsl:call-template name="rebateTableContent">
				<xsl:with-param name="data" select="$disounts" />
				<xsl:with-param name="rebateType" select="'Nachlässe'" />
		</xsl:call-template >
	</xsl:template>










	<xsl:template match="/">

		<xsl:variable name="title">Rabattaktionen nach Kunden: <xsl:value-of select="/report/businessunits/row/bu_nm_1" /></xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$title"/><xsl:text>"</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		<xsl:value-of select='"Ansicht nach Wertstellungsdatum"' />
		<xsl:text>&#xa;</xsl:text>
		
		<xsl:variable name="filterRebateAction">
				<xsl:choose>
						<xsl:when test="not(report/fastInput/row/fast_input_nm)">Rabattaktion: &#160;Alle</xsl:when>
						<xsl:otherwise>Rabattaktion: <xsl:value-of select="report/fastInput/row/fast_input_nm" /></xsl:otherwise>
				</xsl:choose>			
		</xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$filterRebateAction"/><xsl:text>"</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		
		<xsl:variable name="filterView">
			<xsl:choose>
				<xsl:when test="report/employeemode/row/employee_mode">Mitarbeiter:&#160; <xsl:value-of select="/report/employee/row/employee_nm" /></xsl:when>
				<xsl:otherwise>Ansicht:&#160; Salon </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$filterView"/><xsl:text>"</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		<xsl:if test="report/employeemode/row/employee_mode" >
			<xsl:variable name="filterEmployeeMode">
				<xsl:choose>
					<xsl:when test="report/employeemode/row/employee_mode = 'ausf'">Modus:&#160; ausführend</xsl:when>
					<xsl:otherwise>Modus:&#160; beratend</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:text>"</xsl:text><xsl:value-of select="$filterEmployeeMode"/><xsl:text>"</xsl:text>
			<xsl:text>&#xa;</xsl:text>
		</xsl:if>
		


		<xsl:choose>
			<xsl:when test="not(report/employeeList/row)">

				<xsl:call-template name="rebateTable">
					<xsl:with-param name="rebatesInvPercent" select="report/rebatesInvPercent/row"/>
					<xsl:with-param name="rebatesPosPercent" select="report/rebatesPosPercent/row" />
					<xsl:with-param name="rebatesPos" select="report/rebatesPos/row"/>
					<xsl:with-param name="disounts" select="report/disounts/row" />
					
					
				</xsl:call-template>
			
			</xsl:when>
			<xsl:otherwise>
			<xsl:for-each select="report/employeeList/row">	
				<xsl:variable name="employeeNo">
					<xsl:value-of select="rr_employee_no"/>
				</xsl:variable> 
			
				<xsl:call-template name="rebateTable">
					<xsl:with-param name="rebatesInvPercent" select="/report/rebatesInvPercent/row[rr_employee_no = $employeeNo]"/>
					<xsl:with-param name="rebatesPosPercent" select="/report/rebatesPosPercent/row[rr_employee_no = $employeeNo]" />
					<xsl:with-param name="rebatesPos" select="/report/rebatesPos/row[rr_employee_no = $employeeNo]"/>
					<xsl:with-param name="disounts" select="/report/disounts/row[rr_employee_no = $employeeNo]" />
					<xsl:with-param name="employeeNm" select="rr_employee_nm"/>
					
				</xsl:call-template>
			</xsl:for-each>	
				
			</xsl:otherwise>
		</xsl:choose>




	</xsl:template>




</xsl:stylesheet>
