<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell3">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.1mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.1mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>






	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="10mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					
					<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="15%"></fo:table-column>
							<fo:table-column column-width="30%"></fo:table-column>
							<fo:table-column column-width="35%"></fo:table-column>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell xsl:use-attribute-sets="report-title">
										<fo:block>
											Filialbericht
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="report-subtitle">
										<fo:block>
											<xsl:value-of select="report/businessunits/row/bu_nm_2" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="report-subtitle">
										<fo:block>
											<xsl:value-of select="report/businessunits/row/bu_street" />
											,
											<xsl:value-of select="report/businessunits/row/bu_postal_cd" />
											 
											<xsl:value-of select="report/businessunits/row/bu_city" />
											,
											<xsl:value-of select="report/businessunits/row/bu_country_cd" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="report-subtitle">
										<fo:block>
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											, Kostenstelle
											<xsl:value-of select="report/businessunits/row/bu_nm_1" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
					</fo:table>
				</fo:static-content>
					
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Tagesabschluss
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>
///
<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="32mm"></fo:table-column>
						<fo:table-column column-width="3mm"></fo:table-column>
						<fo:table-column column-width="65mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Abschluss für den
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/report-params/DATE" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Erstellungsdatum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/report-params/NOW" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell2">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Erster Bon
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/firstNote/row/sales_inv_cd" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Letzter Bon
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/lastNote/row/sales_inv_cd" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Anzahl Belege
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/notes/row/r_revenue" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Anzahl Stornos
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/notes/row/r_canceled" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Anzahl Kunden
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/notes/row/r_cnt_customer" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Anzahl Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/notes/row/r_credit_notes" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title2">
									<fo:block>Zusammenstellung Umsätze</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Tagesumsatz Gesamt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenue/row/r_revenue, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Umsatz DL
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenue/row/r_revenue_services, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:if test="report/revenue/row/r_revenue_services > 0">
								<xsl:for-each select="report/revenue_acct_service/row">


									<xsl:variable name="itemRevenueAcctNo" select="item_revenue_acct_no/text()" />

									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell">
											<fo:block>
												&#160;&#160;&#160;
												<xsl:value-of
													select="/report/item_revenue_accounts/row[item_revenue_acct_no=$itemRevenueAcctNo]/item_revenue_acct_nm" />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="cell">
											<fo:block>
												<xsl:value-of
													select="format-number(r_revenue_acct_value, '###.##0,00', 'money')" />
												&#160;€
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
							</xsl:if>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block> Umsatz Produkte </fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenue/row/r_revenue_products, 
								'###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:if test="report/revenue/row/r_revenue_products > 0">
								<xsl:for-each select="report/revenue_acct_product/row">


									<xsl:variable name="itemRevenueAcctNo" select="item_revenue_acct_no/text()" />

									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell">
											<fo:block>
												&#160;&#160;&#160;
												<xsl:value-of
													select="/report/item_revenue_accounts/row[item_revenue_acct_no=$itemRevenueAcctNo]/item_revenue_acct_nm" />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="cell">
											<fo:block>
												<xsl:value-of
													select="format-number(r_revenue_acct_value, '###.##0,00', 'money')" />
												&#160;€
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
							</xsl:if>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Rabatt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenue/row/r_rebate, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Offene Posten
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/open/row/r_total, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Offene Posten Sitzung-Start
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/open_b/row/r_total, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;offene Posten neu
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/open_d/row/r_total, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Ausgegebene Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_sessions/row/t_voucher_out, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Eingelöste Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_sessions/row/t_voucher_sales_in, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Ausgegebene Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_sessions/row/t_creditnote_sales_out, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Eingelöste Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_sessions/row/t_creditnote_sales_in, '###.##0,00', 'money')" />
										&#160;€
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Stornos
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Anzahl Stornos
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of select="report/notes/row/r_canceled" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Stornos (Summe)
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/notes/row/r_canceled_value, '###.##0,00', 'money')" />
										&#160;€

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Anzahl Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of select="report/notes/row/r_credit_notes" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Gutschriften (Summe)
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/notes/row/r_credit_notes_value, '###.##0,00', 'money')" />
										&#160;€

									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row page-break-after="always">
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Zahlungsverkehr</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:for-each select="report/drawers/row">

								<xsl:variable name="drawerNo" select="drawer_no/text()" />
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
										<fo:block>
											<xsl:value-of select="drawer_nm" />

										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>



								<fo:table-row>
									<fo:table-cell text-align="left"
										number-columns-spanned="2" xsl:use-attribute-sets="cell-bold">
										<fo:block>Bar</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-bold">
										<fo:block>
											Anfangsbestand:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/cash_start/row[t_drawer_no=$drawerNo]/cash_start, '###.##0,00', 'money')" />
											&#160;€
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell">
										<fo:block>
											+&#160;Bareinnahmen
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_cash_sales_in, '###.##0,00', 'money')" />
											&#160;€

										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- <fo:table-row> <fo:table-cell text-align="left" xsl:use-attribute-sets="cell"> 
									<fo:block> +&#160;Einlagen </fo:block> </fo:table-cell> <fo:table-cell text-align="right" 
									xsl:use-attribute-sets="cell"> <fo:block> <xsl:value-of select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_cash_in, 
									'###.##0,00', 'money')" /> &#160;€ </fo:block> </fo:table-cell> </fo:table-row> -->
								<xsl:for-each
									select="/report/pos_sessions_acct/row[t_drawer_no=$drawerNo]">


									<xsl:variable name="acctCd">
										<xsl:value-of select="contra_acct_cd" />
									</xsl:variable>


									<xsl:choose>
										<xsl:when
											test="/report/drawers/row[acct_cd=$acctCd]/drawer_no=$drawerNo">


											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell">
													<fo:block>
														+&#160;Einlagen

													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="cell">
													<fo:block>


														<xsl:value-of
															select="format-number(t_acct_cd_cash_in, '###.##0,00', 'money')" />
														&#160;€




													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:when>
										<xsl:otherwise>


											<xsl:if test="t_acct_cd_cash_in>0">


												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
															+&#160;Umbuchung

															von
															<xsl:value-of
																select="/report/drawers/row[acct_cd=$acctCd]/drawer_nm"></xsl:value-of>

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>


															<xsl:value-of
																select="format-number(t_acct_cd_cash_in, '###.##0,00', 'money')" />
															&#160;€



														</fo:block>
													</fo:table-cell>
												</fo:table-row>

											</xsl:if>

										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>



								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell">
										<fo:block>
											-&#160;Barausgaben
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_cash_purchase_out, '###.##0,00', 'money')" />
											&#160;€
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- <fo:table-row> <fo:table-cell text-align="left" xsl:use-attribute-sets="cell"> 
									<fo:block> -&#160;Entnahmen </fo:block> </fo:table-cell> <fo:table-cell text-align="right" 
									xsl:use-attribute-sets="cell"> <fo:block> <xsl:value-of select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_cash_out, 
									'###.##0,00', 'money')" /> &#160;€ </fo:block> </fo:table-cell> </fo:table-row> 
									<fo:table-row> <fo:table-cell text-align="left" xsl:use-attribute-sets="cell"> 
									<fo:block> -&#160;Entnahmen - Tresor </fo:block> </fo:table-cell> <fo:table-cell 
									text-align="right" xsl:use-attribute-sets="cell"> <fo:block> <xsl:if test="central=true"> 
									<xsl:value-of select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_cash_out, 
									'###.##0,00', 'money')" /> &#160;€ </xsl:if> </fo:block> </fo:table-cell> 
									</fo:table-row> -->

								<xsl:for-each
									select="/report/pos_sessions_acct/row[t_drawer_no=$drawerNo]">


									<xsl:variable name="acctCd">
										<xsl:value-of select="contra_acct_cd" />
									</xsl:variable>


									<xsl:choose>
										<xsl:when
											test="/report/drawers/row[acct_cd=$acctCd]/drawer_no=$drawerNo">


											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell">
													<fo:block>
														-&#160;Entnahme

													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="cell">
													<fo:block>


														<xsl:value-of
															select="format-number(t_acct_cd_cash_out, '###.##0,00', 'money')" />
														&#160;€




													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:when>
										<xsl:otherwise>


											<xsl:if test="t_acct_cd_cash_out>0">


												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
															-&#160;Umbuchung

															nach
															<xsl:value-of
																select="/report/drawers/row[acct_cd=$acctCd]/drawer_nm"></xsl:value-of>

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>


															<xsl:value-of
																select="format-number(t_acct_cd_cash_out, '###.##0,00', 'money')" />
															&#160;€



														</fo:block>
													</fo:table-cell>
												</fo:table-row>

											</xsl:if>

										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>


								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-bold">
										<fo:block>
											Endbestand:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-bold">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/cash_end/row[t_drawer_no=$drawerNo]/cash_end, '###.##0,00', 'money')" />
											&#160;€

										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										number-columns-spanned="2" xsl:use-attribute-sets="cell-bold">
										<fo:block>Bargeldlos</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell">
										<fo:block>
											+&#160;EC-Einnahmen / EC-Schnitt
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_ec_sales_in, '###.##0,00', 'money')" />
											&#160;€
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell">
										<fo:block>
											+&#160;Kreditkarten-Einnahmen
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_cc_sales_in, '###.##0,00', 'money')" />
											&#160;€
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell">
										<fo:block>
											+&#160;Überweisungen
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell">
										<fo:block>
											<xsl:value-of
												select="format-number(/report/pos_sessions/row[t_drawer_no=$drawerNo]/t_transfer_sales_in, '###.##0,00', 'money')" />
											&#160;€
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</xsl:for-each>



						</fo:table-body>
					</fo:table>



					<fo:block id="LastPage" />
				</fo:flow>

			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>