<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1Rotated">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="borderRotated">
		<xsl:attribute name="border-top-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableInnerSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
		<!-- <xsl:attribute name="font-weight">bold</xsl:attribute> -->
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableOuterSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderInnerSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderOuterSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="container_header">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.85cm</xsl:attribute>
	</xsl:attribute-set>
	
		<xsl:attribute-set name="containerHeader">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.00m</xsl:attribute>
		 <xsl:attribute name="width">3.0cm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	<xsl:attribute-set name="containerHeaderLabel">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.0cm</xsl:attribute>
		 <xsl:attribute name="margin-left">2mm</xsl:attribute>
		 <xsl:attribute name="keep-together">always</xsl:attribute>
		  <xsl:attribute name="padding-top">3mm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="tgDivision">
		<xsl:param name="divident" />
		<xsl:param name="divisor" />
		<xsl:param name="negativCorrection" />
			<xsl:choose>
				<xsl:when test="$divisor &lt; 0 and $divident &lt; 0">
					<xsl:value-of select="format-number($divident div  ($negativCorrection * $divisor ), '###.##0,00', 'money')" />
				</xsl:when>
				<xsl:when test="$divisor=0">
					0,00
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of	select="format-number($divident div  $divisor , '###.##0,00', 'money')" />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">

					<xsl:variable name="filterRows">
						<filterRow>
							<content>
								Modus:&#160; <xsl:choose>
									<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'"> ausführend  </xsl:when>
									<xsl:otherwise>	beratend	</xsl:otherwise>
								</xsl:choose>
							</content>
						</filterRow>
						<filterRow>
							<content>
								Profession:&#160;<xsl:value-of select="report/employee_profession/row/profession_nm" />
							</content>
						</filterRow>
						<filterRow>
							<content>
								Mitarbeiter:&#160;<xsl:value-of select="report/employeenm/row/employee_nm" />
							</content>
						</filterRow>
					

					</xsl:variable>
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Umsätze nach Mitarbeiter"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRows" select="$filterRows" />
					</xsl:call-template>



				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Umsätze nach <xsl:choose>
									<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'"> ausführendem  </xsl:when>
									<xsl:otherwise>	beratendem	</xsl:otherwise>
								</xsl:choose> Mitarbeiter
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>

					<xsl:variable name="totalProducts"
						select="sum(report/revenueData/employeeRevenue/row/r_total_products)" />
					<xsl:variable name="totalServices"
						select="sum(report/revenueData/employeeRevenue/row/r_total_services)" />
					<xsl:variable name="totalCustomers"
						select="sum(report/revenueData/employeeRevenue/row/r_amount_customer)" />
					<xsl:variable name="totalRevenue"
						select="sum(report/revenueData/employeeRevenue/row/r_total)" />
					<xsl:variable name="cntEmployees"
						select="report/revenueData/sumRevenue/row/r_cntEmpl_wf" />
					<fo:table table-layout="fixed" border-collapse="collapse"
						break-after="page" width="100%" margin-top="0cm">
						<fo:table-column column-width="9%"></fo:table-column>
						<fo:table-column column-width="3%"></fo:table-column>
						
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						
						<fo:table-header >
							<fo:table-row>
							
							  <fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold-left">
										<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Tage</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Dienstl.- Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Dienstl.- Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Dienstl.- Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Dienstl.- Gesamt</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Verkauf</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>PV Stk.</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderOuterSum">
									<fo:block>Gesamt-</fo:block>
									<fo:block>Umsatz</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz pro Tag</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz pro Tag FA</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>FA</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Verkaufs-anteil</fo:block>
								</fo:table-cell>
								
					
								
							
							</fo:table-row>
							</fo:table-header>
							<fo:table-body>
							<xsl:for-each select="report/revenueData/employeeRevenue/row">
								<fo:table-row >

									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="r_employee_nm" />
										</fo:block>
									</fo:table-cell>
									
									<!-- Arbeitstage -->
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_cnt_dt" />
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Dame // DL D -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g1_services, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Herr // DL H -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g2_services, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Kind // DL K -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g3_services, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Gesamt / Umsatz DL  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_services, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz Verkauf / Umsatz V  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_products, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Anzahl Produkte  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_amount_products, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dame Gesamt / Umsatz D  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g1, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Herr Gesamt / Umsatz H  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g2, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Kinde Gesamt / Umsatz K  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g3, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>

									
									
									<!-- Umsatz Gesamt -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
											<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									
									<!-- Ø pro Tag /  Ums. G/Tag -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_day, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									

									<!-- Ø pro Tag /  Ums. G/Tag mit Workfactor -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_day_wf, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									<!-- workfactor-->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_working_factor, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>


									<!-- %Verkaufsanteil /  Ums.V. / Ums. G % -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>


											<xsl:choose>
												<xsl:when test="r_total!=0">
													<xsl:value-of
														select="format-number((r_total_products div r_total) * 100, '###.##0,00', 'money')" />
													&#160;%

												</xsl:when>
												<xsl:otherwise>
													0,00&#160;%
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									

								</fo:table-row>

							</xsl:for-each>


							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>&#216;&#160;Mitarbeiter</fo:block>
								</fo:table-cell>
								
								<!-- Tag-->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
								<!--		<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_cnt_dt div $cntEmployees, '###.##0,#', 'amount')" /> -->
									</fo:block>
								</fo:table-cell>
								
								<!-- Umsatz Dienstleistung Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenueData/employeeRevenue/row/r_total_g1_services) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenueData/employeeRevenue/row/r_total_g2_services) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenueData/employeeRevenue/row/r_total_g3_services) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistungen / Umsatz DL -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_services) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf / Umsatz V -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_products) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Verkauf -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_amount_products) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Gesamt Damen / Umsatz D -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_g1) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Herr Gesamt / Umsatz H -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_g2) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Kind Gesamt / Umsatz K -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_g3) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								
								<!-- Umsatz Gesamt / Umsatz G -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
									<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								
								<!-- Ø pro Tag/  Ums. G / Tag-->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_per_day) div $cntEmployees, '###.##0,00', 'money')" />
										
								</fo:block>
								</fo:table-cell>
								
								<!-- Ø pro Tag /  Ums. G/Tag mit Workfactor -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_total_per_day_wf) div $cntEmployees, '###.##0,00', 'money')" />
										
										
										</fo:block>
									</fo:table-cell>
									<!-- workfactor-->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											
										</fo:block>
									</fo:table-cell>


	
								
								<!-- % Verkaufsanteil / Ums. V / Ums. G %--> 
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
												<xsl:value-of
													select="format-number(((sum(report/revenueData/employeeRevenue/row/r_total_products) div sum(report/revenueData/employeeRevenue/row/r_total))  div $cntEmployees) * 100, '###.##0,00', 'money')" />&#160;%
								
									</fo:block>
								</fo:table-cell>
							
							</fo:table-row>

							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>Summe</fo:block>
								</fo:table-cell>
								<!-- Tag -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/revenueData/sumRevenue/row/r_cnt_dt" />
									</fo:block>
								</fo:table-cell>
							
								<!-- Umsatz Dienstleistung Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_g1_services, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_g2_services, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_g3_services, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistungen / Umsatz DL -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_services, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf / Umsatz V -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_products, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
									<!--Anzahl Verkauf  -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_amount_products, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dame Gesamt / Umsatz D -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_g1, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Herr Gesamt / Umsatz H -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_g2, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Kind Gesamt / Umsatz K -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_g3, '###.##0,00', 'money')" />
										
									</fo:block>
								
								</fo:table-cell>
									<!-- Umsatz Gesamt / Umsatz G -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Ø pro Tag/  Ums. G / Tag-->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_per_day, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								
	<!-- Ø pro Tag /  Ums. G/Tag mit Workfactor -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:choose>
												<xsl:when test="report/revenueData/sumRevenue/row/r_cntEmpl_wf!=0">

													<xsl:value-of
														select="format-number(report/revenueData/sumRevenue/row/r_total_per_day_wf, '###.##0,00', 'money')" />
										
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>			
										</fo:block>
									</fo:table-cell>
									<!-- workfactor-->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
								
										</fo:block>
									</fo:table-cell>


								<!-- % Verkaufsanteil / Ums. V / Ums. G %-->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/revenueData/sumRevenue/row/r_total!=0">

												<xsl:value-of
													select="format-number((report/revenueData/sumRevenue/row/r_total_products div report/revenueData/sumRevenue/row/r_total) * 100, '###.##0,00', 'money')" />
												&#160;%
											</xsl:when>
											<xsl:otherwise>
												0&#160;%
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								
								
							
								
								

							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<!-- 
					** Zweite Tabelle 

					-->
					
					<fo:table table-layout="fixed" border-collapse="collapse"
						width="100%" >
						<fo:table-column column-width="2.50cm"></fo:table-column>
						<fo:table-column column-width="0.70cm"></fo:table-column>
						

						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>

						<fo:table-column ></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-header>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold-left">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Tage</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Anzahl Damen</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Anzahl Herren</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Anzahl Kinder</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Anzahl Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Anzahl pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø DL Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø DL Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø DL Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Ø DL / Besuch</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block># DL</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderOuterSum">
									<fo:block>Ø Umsatz / Besuch</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz DL / Besuch</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz VK / Besuch</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-header>
						<fo:table-body>
							<xsl:for-each select="report/revenueData/employeeRevenue/row">
							<xsl:variable name="employeeNo" select ="r_employee_no" />
								<fo:table-row>
									<!--Mitarbeiter -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="r_employee_nm" />
										</fo:block>
									</fo:table-cell>
									<!-- Tage --> 
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_cnt_dt" />
										</fo:block>
									</fo:table-cell>
									
									<!-- Anzahl Damen -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amount_group1" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Herren -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amount_group2" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Kinder -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amount_group3" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Kunden -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of select="r_amount_customer" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Kunden pro Tag -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="r_cnt_dt!=0">

 <xsl:value-of
														select="format-number( r_amount_customer div r_cnt_dt, '###.##0,00', 'money')" />


												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Dame -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>	
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">


													<xsl:value-of select="format-number( r_cnt_dl_bio_per_g1,'###.##0,00', 'money')" />	

												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number( r_services_per_g1,'###.##0,00', 'money')" /> 
												</xsl:otherwise>
											</xsl:choose>									
											
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Herr -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">


														<xsl:value-of select="format-number( r_cnt_dl_bio_per_g2,'###.##0,00', 'money')" />		
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number( r_services_per_g2,'###.##0,00', 'money')" /> 
												</xsl:otherwise>
											</xsl:choose>				
											
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Kind -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												
																<xsl:value-of select="format-number( r_cnt_dl_bio_per_g3,'###.##0,00', 'money')" />											
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number( r_services_per_g3,'###.##0,00', 'money')" /> 
												</xsl:otherwise>
											</xsl:choose>		
										
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">													
													
															<xsl:value-of select="format-number( r_cnt_dl_bio_per_cus,'###.##0,00', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number( r_services_per_cus,'###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>		
											
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(r_cnt_dl_bio,'###.##0,00', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_count_services,'###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Dame -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g1, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Herr -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g2, '###.##0,00', 'money')" />
					
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Kind -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g3, '###.##0,00', 'money')" />
											
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_customer, '###.##0,00', 'money')" />
										
								
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz Dienstleistungen pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>

										<xsl:value-of
												select="format-number(r_total_services_per_customer, '###.##0,00', 'money')" />

										</fo:block>
									</fo:table-cell>
									<!-- Umsatz Verkauf pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
												<xsl:value-of
												select="format-number(r_total_product_per_customer, '###.##0,00', 'money')" />
										
										
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</xsl:for-each>
	

							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>&#216;&#160;Mitarbeiter</fo:block>
								</fo:table-cell>
								<!-- Tage --> 
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									
									<fo:block>
										
									<!--	<xsl:value-of
											select="format-number(/report/revenueData/sumRevenue/row/r_cnt_dt div $cntEmployees, '###.##0,#', 'amount')" /> -->
									</fo:block>
								</fo:table-cell>
								
								<!-- Anzahl Damen -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_amount_group1) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Herren -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_amount_group2) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kinder -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_amount_group3) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/revenueData/employeeRevenue/row/r_amount_customer) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden pro Tag -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:value-of
											select="round((100*(sum(report/revenueData/employeeRevenue/row/r_amount_customer_per_day))) div $cntEmployees) div 100" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">	
													<xsl:call-template name="tgDivision">
														<xsl:with-param name="divident"	select="sum(/report/revenueData/employeeRevenue/row/r_cnt_dl_bio_per_g1)" />
														<xsl:with-param name="divisor"	select="$cntEmployees" />
														<xsl:with-param name="negativeCorrection"	select="1" />
													</xsl:call-template>
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(sum(/report/revenueData/employeeRevenue/row/r_services_per_g1) div $cntEmployees, '###.##0,0', 'amount')" />
												</xsl:otherwise>
											</xsl:choose>		
				
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">	
													<xsl:call-template name="tgDivision">
														<xsl:with-param name="divident"	select="sum(/report/revenueData/employeeRevenue/row/r_cnt_dl_bio_per_g2)" />
														<xsl:with-param name="divisor"	select="$cntEmployees" />
														<xsl:with-param name="negativeCorrection"	select="1" />
													</xsl:call-template>
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(sum(/report/revenueData/employeeRevenue/row/r_services_per_g2) div $cntEmployees, '###.##0,0', 'amount')" />
												</xsl:otherwise>
											</xsl:choose>		
				
									
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">	
													<xsl:call-template name="tgDivision">
														<xsl:with-param name="divident"	select="sum(/report/revenueData/employeeRevenue/row/r_cnt_dl_bio_per_g3)" />
														<xsl:with-param name="divisor"	select="$cntEmployees" />
														<xsl:with-param name="negativeCorrection"	select="1" />
													</xsl:call-template>
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(sum(/report/revenueData/employeeRevenue/row/r_services_per_g3) div $cntEmployees, '###.##0,0', 'amount')" />
												</xsl:otherwise>
										</xsl:choose>		
				
									
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:choose>
													<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">	
														<xsl:call-template name="tgDivision">
															<xsl:with-param name="divident"	select="sum(/report/revenueData/employeeRevenue/row/r_cnt_dl_bio_per_cus)" />
															<xsl:with-param name="divisor"	select="$cntEmployees" />
															<xsl:with-param name="negativeCorrection"	select="1" />
														</xsl:call-template>
													</xsl:when>	
													<xsl:otherwise>
														<xsl:value-of select="format-number(sum(/report/revenueData/employeeRevenue/row/r_services_per_cus) div $cntEmployees, '###.##0,0', 'amount')" />
													</xsl:otherwise>
												</xsl:choose>		
												

											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>

								</fo:table-cell>
								<!-- Anzahl Services -->
								<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											
											<xsl:choose>
													<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">	
														<xsl:call-template name="tgDivision">
															<xsl:with-param name="divident"	select="sum(/report/revenueData/employeeRevenue/row/r_cnt_dl_bio)" />
															<xsl:with-param name="divisor"	select="$cntEmployees" />
															<xsl:with-param name="negativeCorrection"	select="1" />
														</xsl:call-template>
													</xsl:when>	
													<xsl:otherwise>
														<xsl:value-of select="format-number(sum(/report/revenueData/employeeRevenue/row/r_count_services) div $cntEmployees, '###.##0,0', 'money')" />
													</xsl:otherwise>
											</xsl:choose>		
											
										</fo:block>
									</fo:table-cell>
								<!-- Umsatz pro Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenueData/employeeRevenue/row/r_total_per_g1) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenueData/employeeRevenue/row/r_total_per_g2) div $cntEmployees, '###.##0,00', 'money')" />
									
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(/report/revenueData/employeeRevenue/row/r_total_per_g3) div $cntEmployees, '###.##0,00', 'money')" />
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
								
									
									
										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
										
												<xsl:value-of
													select="format-number(round(100*(sum(/report/revenueData/employeeRevenue/row/r_total_per_customer ) ) div $cntEmployees) div 100, '###.##0,00', 'money')" />


												
											</xsl:when>
											<xsl:otherwise>
												0,00
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>

								<!-- Umsatz Dienstleistungen pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
										
												<xsl:value-of
													select="format-number(round(100*(sum(/report/revenueData/employeeRevenue/row/r_total_services_per_customer ) ) div $cntEmployees) div 100, '###.##0,00', 'money')" />



												
											</xsl:when>
											<xsl:otherwise>
												0,00
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
										
											<xsl:value-of
													select="format-number(round(100*(sum(/report/revenueData/employeeRevenue/row/r_total_product_per_customer ) ) div $cntEmployees) div 100, '###.##0,00', 'money')" />

										

											</xsl:when>
											<xsl:otherwise>
												0,00
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

													<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>Summe</fo:block>
								</fo:table-cell>
								<!-- Tage --> 
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/revenueData/sumRevenue/row/r_cnt_dt" />
									</fo:block>
								</fo:table-cell>
								
								<!-- Anzahl Damen -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/revenueData/sumRevenue/row/r_amount_group1" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Herren -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/revenueData/sumRevenue/row/r_amount_group2" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kinder -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/revenueData/sumRevenue/row/r_amount_group3" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/revenueData/sumRevenue/row/r_amount_customer" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden pro Tag -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="round(100*(report/revenueData/sumRevenue/row/r_amount_customer div report/revenueData/sumRevenue/row/r_cnt_dt)) div 100" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_cnt_dl_bio_per_g1,'###0,0', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_services_per_g1,'###0,0', 'money')" />
												</xsl:otherwise>
											</xsl:choose>		
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_cnt_dl_bio_per_g2,'###0,0', 'money')" />
													
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_services_per_g2,'###0,0', 'money')" />
												</xsl:otherwise>
										</xsl:choose>		
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
									<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_cnt_dl_bio_per_g3,'###0,0', 'money')" />
													
													
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_services_per_g3,'###0,0', 'money')" />
												</xsl:otherwise>
										</xsl:choose>		
										
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_cnt_dl_bio_per_cus,'###0,0', 'money')" />
													
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_services_per_cus,'###0,0', 'money')" />
												</xsl:otherwise>
										</xsl:choose>		
					
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services -->
								<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">	
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_cnt_dl_bio,'###0,0', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(report/revenueData/sumRevenue/row/r_count_services,'###0,0', 'money')" />
												</xsl:otherwise>
											</xsl:choose>		
											
										</fo:block>
									</fo:table-cell>
								<!-- Umsatz pro Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_per_g1, '###.##0,00', 'money')" />
										
									</fo:block>
								<!-- Umsatz pro Herr -->
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_per_g2, '###.##0,00', 'money')" />
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_per_g3, '###.##0,00', 'money')" />
									</fo:block>
								</fo:table-cell>
									<!-- Umsatz pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
									
									<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_per_customer, '###.##0,00', 'money')" />
									
									
										
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistungen pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_services_per_customer, '###.##0,00', 'money')" />
									

									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
									
											<xsl:value-of
											select="format-number(report/revenueData/sumRevenue/row/r_total_product_per_customer, '###.##0,00', 'money')" />
									

									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>

	
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
