<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="barcode date exsl">

	<xsl:import href="Header.xsl"/>

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#CCCCCC</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="15mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">


				<fo:static-content flow-name="header">
				
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"verwendete Gutscheinübersicht"' />
					
					
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
					
					</xsl:call-template>
				
				</fo:static-content>



				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%" />
							<fo:table-column column-width="60%" />
							<fo:table-column column-width="20%" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Übersicht verwendete Gutscheine
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">

				<fo:block-container margin-bottom="10px" page-break-after="always">
					<fo:block   >
						<fo:table table-layout="fixed" width="100%" >
							
							<fo:table-column column-width="40%" />
							<fo:table-column column-width="40%" />
							<fo:table-column column-width="20%" />
							

							<fo:table-header>
								
								<fo:table-row>
									
									
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-title2">
										<fo:block>Firma eingelöst</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-title2">
										<fo:block>Firma (ausgegeben)</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-title2">
										<fo:block>Betrag</fo:block>
									</fo:table-cell>
									
								</fo:table-row>
						
							</fo:table-header>		
							<fo:table-body>
								<xsl:if test="count(/report/vouchers_in) = 0">
									<!-- leere Zeile -->
									<fo:table-row>
										<fo:table-cell text-align="left" column-number-spanned="3"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:if>
								
								<xsl:if test="count(/report/vouchers_in) != 0">
									<xsl:for-each select="report/companies/row">
										<xsl:variable name="companyNo" select="company_no" />
										
										<xsl:variable name="vouchers_in_company" select="exsl:node-set(/report/vouchers_in/row[company_no_in = $companyNo])" />
										<xsl:if test="count($vouchers_in_company) != 0">
									
												<xsl:for-each select="/report/companies/row">
														<xsl:variable name="companyOut" select="company_no" />
																							
														<xsl:variable name="vouchers_in_company_out" select="exsl:node-set($vouchers_in_company[company_no_out=$companyOut])" />
														<xsl:if test="count($vouchers_in_company_out) != 0">
														<xsl:if test="$companyOut != $companyNo">
															<fo:table-row>
																<fo:table-cell text-align="left"
																	xsl:use-attribute-sets="minicell">
																	<fo:block>

																		<xsl:value-of select="/report/companies/row[company_no=$companyNo]/company_nm" />
																		
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="left"
																	xsl:use-attribute-sets="minicell">
																	<fo:block>
																		<xsl:value-of select="/report/companies/row[company_no=$companyOut]/company_nm" />
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="minicell">
																	<fo:block>
																			<xsl:value-of select="format-number(sum($vouchers_in_company_out/voucher_value ), '###.##0,00', 'money')" />
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:if>
														</xsl:if>
												</xsl:for-each>
										</xsl:if>
									</xsl:for-each>
								</xsl:if>
							</fo:table-body>
						</fo:table>
						</fo:block>
					</fo:block-container>

					<xsl:for-each select="report/companies/row">
						<xsl:variable name="companyNo" select="company_no" />
						
						<xsl:variable name="vouchers_in_company" select="exsl:node-set(/report/vouchers_in/row[company_no_in = $companyNo])" />
						<xsl:if test="count($vouchers_in_company) != 0">
						<fo:block-container page-break-after="always">
						
						<fo:block-container background-color="#333333" margin-top="10px">
							<fo:block  padding="5px 5px 5px 5px" color="#FFFFFF"  >
								<xsl:value-of select="company_nm" />
							</fo:block>
						</fo:block-container>
						<xsl:for-each select="/report/departments/row[company_no=$companyNo]">
							<xsl:variable name="departmentNo" select="department_no" />
							<xsl:variable name="vouchers_in_department" select="exsl:node-set(/report/vouchers_in/row[company_no_in=$companyNo][department_no_in=$departmentNo])" />
							<xsl:if test="count($vouchers_in_department) != 0">
							
									<fo:block-container background-color="#888888" margin-top="7px">
										<fo:block  padding="5px 10px 5px 10px" >
										  <xsl:value-of select="department_nm" />
										</fo:block>
									</fo:block-container>
									<xsl:for-each select="/report/businessunits/row[company_no=$companyNo][department_no=$departmentNo]">
										<xsl:variable name="posCd" select="pos_cd_hint" />
										<xsl:variable name="vouchers_in_businessunit" select="exsl:node-set(/report/vouchers_in/row[company_no_in=$companyNo][department_no_in=$departmentNo][pos_cd_in=$posCd])" />
											<xsl:if test="count($vouchers_in_businessunit) != 0">
										
												<fo:block-container  margin="5px 0px 5px 0px" >
														<fo:block  padding="6px 0px 6px 0px"  margin-bottom="5px">
															eingelöste Gutscheine in:   <xsl:value-of select="businessunit_nm" />
														</fo:block>




																<fo:table table-layout="fixed" width="100%" >
																	
																	<fo:table-column column-width="30%" />
																	<fo:table-column column-width="30%" />
																	<fo:table-column column-width="30%" />
																	
																	<fo:table-column column-width="10%" />
																	

																	<fo:table-header>
																		
																		<fo:table-row>
																			
																			
																			<fo:table-cell text-align="left"
																				xsl:use-attribute-sets="cell-title2">
																				<fo:block>Firma</fo:block>
																			</fo:table-cell>
																			<fo:table-cell text-align="left"
																				xsl:use-attribute-sets="cell-title2">
																				<fo:block>Department</fo:block>
																			</fo:table-cell>
																			<fo:table-cell text-align="left"
																				xsl:use-attribute-sets="cell-title2">
																				<fo:block>Geschäftsstellen</fo:block>
																			</fo:table-cell>
																			
																			<fo:table-cell text-align="right"
																				xsl:use-attribute-sets="cell-title2">
																				<fo:block>Betrag</fo:block>
																			</fo:table-cell>
																			
																		</fo:table-row>
																	</fo:table-header>
																	<fo:table-body>
																		
																		
																		<xsl:for-each select="/report/businessunits/row">
																			<xsl:variable name="posCdOut" select="pos_cd_hint" />
																			
																			<xsl:variable name="vouchers_in_businessunit_out" select="exsl:node-set($vouchers_in_businessunit[pos_cd_out=$posCdOut])" />
																				<xsl:if test="count($vouchers_in_businessunit_out) != 0">
																					<xsl:variable name="buVoucherOut" select="/report/businessunits/row[pos_cd_hint=$posCdOut]" />
																					<xsl:variable name="companyVoucherOut" select="$buVoucherOut/company_no" />
																					<xsl:variable name="departmentVoucherOut" select="$buVoucherOut/department_no" />
																					
																					<fo:table-row >
																						<fo:table-cell text-align="left"
																								xsl:use-attribute-sets="minicell">
																								<fo:block>

																									<xsl:value-of select="/report/companies/row[company_no=$companyVoucherOut]/company_nm" />
																									
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell text-align="left"
																								xsl:use-attribute-sets="minicell">
																								<fo:block>
																									<xsl:value-of select="/report/departments/row[department_no=$departmentVoucherOut]/department_nm" />
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell text-align="left"
																								xsl:use-attribute-sets="minicell">
																								<fo:block>
																									<xsl:value-of select="$buVoucherOut/businessunit_nm" />
																								</fo:block>
																							</fo:table-cell>
																						<fo:table-cell text-align="right"
																							xsl:use-attribute-sets="minicell">
																							<fo:block>
																								<xsl:value-of
																									select="format-number(sum($vouchers_in_businessunit_out/voucher_value ), '###.##0,00', 'money')" />
																							

																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>

																					</xsl:if>
																		</xsl:for-each>
																	</fo:table-body>
																</fo:table>
														</fo:block-container>
												</xsl:if>
											</xsl:for-each>		
									</xsl:if>
								</xsl:for-each>
								</fo:block-container>
							</xsl:if>
 					</xsl:for-each>

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>