<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="barcode date exsl">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


<xsl:template name="numberEFormat" >
  <xsl:param name="value" />
 
	<xsl:choose>
		<xsl:when test="not(contains($value,'E'))">
			<xsl:value-of select="$value"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="vExponent" select="substring-after($value,'E')"/>
			<xsl:variable name="vMantissa" select="substring-before($value,'E')"/>
			
			<xsl:variable name="vFactor">
				<xsl:choose>
					<xsl:when test="starts-with($vExponent,'-')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>		
					<xsl:when test="starts-with($vExponent,'+')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>							
					<xsl:otherwise>
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,1) + 1)" />
					</xsl:otherwise>
				</xsl:choose>				   
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($vExponent,'-')">
					<xsl:value-of select="$vMantissa div $vFactor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$vMantissa * $vFactor"/>
				</xsl:otherwise>
			</xsl:choose>
		
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>



	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="15mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
				    <xsl:call-template name="header">
        <xsl:with-param name="title" select='"Gutscheine"' />
        <xsl:with-param name="businessunit" select="report/businessunits/row" />
		<xsl:with-param name="filterRow" select='"Filter: Gutscheine ausgegeben"' />
								<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
							<xsl:with-param name="viewMode" select='"Ansicht nach Wertstellungsdatum"' />
    </xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%" />
							<fo:table-column column-width="60%" />
							<fo:table-column column-width="20%" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Ausgegebene Gutscheine
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">

	
				


	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>

						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="100%" />

							<fo:table-body>

				
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<fo:table table-layout="fixed" width="100%">
												<fo:table-column column-width="20mm" />
												<fo:table-column column-width="20mm" />
												<fo:table-column column-width="20mm" />
												<fo:table-column column-width="30mm" />
												<fo:table-column column-width="20mm" />
												<fo:table-column column-width="35mm" />
												<fo:table-column column-width="25mm" />

												<fo:table-header>
																								<fo:table-row>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell-subtitle" number-columns-spanned="7">
																<fo:block>Ausgegeben</fo:block>
															</fo:table-cell>
														</fo:table-row>
													<fo:table-row>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Ausgabedatum</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Einlösedatum</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Kassierer</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Gutschein Nr</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Betrag</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Kunde</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Beleg Nr</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body>
													<xsl:for-each select="report/sales_voucher_out/row">
														<xsl:variable name="grey_bg">
															<xsl:choose>
																<xsl:when test="position() mod 2 = 1">
																	#FFFFFF
																</xsl:when>
																<xsl:otherwise>
																	#CCCCCC
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<xsl:variable name="voucherValue">
																<xsl:call-template name="numberEFormat">
																	<xsl:with-param name="value" select="voucher_value" />
					
																</xsl:call-template>
															</xsl:variable>
														<fo:table-row background-color="{$grey_bg}">
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																<xsl:call-template name="formatdate">
																<xsl:with-param name="datestr"
																	select="voucher_use_ts" />
															</xsl:call-template>
																	
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
															
																		<xsl:choose>
																			<xsl:when test="redeemed_sales_voucher_state = '6'">
																				Deaktiviert
																			</xsl:when>
																			<xsl:otherwise>	
																				<xsl:call-template name="formatdate">
																					<xsl:with-param name="datestr" select="redeemed_sales_voucher_use_ts" />
																				</xsl:call-template>
																		</xsl:otherwise>
																		</xsl:choose>
																	
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="employee_nm" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="voucher_cd" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of
																		select="format-number($voucherValue, '###.##0,00', 'money')" />	
																	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="customer_nm" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="sales_inv_cd" />
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
													<fo:table-row>
														<fo:table-cell text-align="left"
															number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
															<fo:block></fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right" xsl:use-attribute-sets="minicell-bold">
															<fo:block>Summe</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell-bold">
															<fo:block>
																<xsl:variable name="sumVoucherValues">	
																	<xsl:for-each select="report/sales_voucher_out/row">
																		
																		<xsl:variable name="vVoucherValue">
																			<xsl:call-template name="numberEFormat">
																				<xsl:with-param name="value" select="voucher_value" />
											
																			</xsl:call-template>
																		</xsl:variable>
																		
																		<number>
																			<xsl:value-of select="$vVoucherValue" />
																		</number>
																	</xsl:for-each>
																	
																</xsl:variable>
																<xsl:value-of select='format-number(sum(exsl:node-set($sumVoucherValues)/number), "###.##0,00", "money")' />
																

															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								


							</fo:table-body>
						</fo:table>
 

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>