<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />

	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

<xsl:template name="numberEFormat" >
  <xsl:param name="value" />
 
	<xsl:choose>
		<xsl:when test="not(contains($value,'E'))">
			<xsl:value-of select="$value"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="vExponent" select="substring-after($value,'E')"/>
			<xsl:variable name="vMantissa" select="substring-before($value,'E')"/>
			
			<xsl:variable name="vFactor">
				<xsl:choose>
					<xsl:when test="starts-with($vExponent,'-')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>		
					<xsl:when test="starts-with($vExponent,'+')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>							
					<xsl:otherwise>
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,1) + 1)" />
					</xsl:otherwise>
				</xsl:choose>				   
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($vExponent,'-')">
					<xsl:value-of select="$vMantissa div $vFactor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$vMantissa * $vFactor"/>
				</xsl:otherwise>
			</xsl:choose>
		
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>



	<xsl:template match="/">


		<!-- HEADER -->
		<xsl:text>&#xa;</xsl:text>
		<xsl:value-of select='"Ansicht nach Wertstellungsdatum"' />
		<xsl:text>&#xa;</xsl:text>

		<xsl:text>Von</xsl:text><xsl:value-of select="$delimiter" />

		<xsl:call-template name="formatdate">
			<xsl:with-param name="datestr" select="report/report-params/DATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />

		<xsl:text>Bis</xsl:text><xsl:value-of select="$delimiter" />
		<xsl:call-template name="formatdate">
			<xsl:with-param name="datestr" select="report/report-params/TODATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />

		<!-- AUSGEGEBEN -->
		<xsl:text>&#xa;</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		<xsl:text>Ausgegeben</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		<xsl:text>&#xa;</xsl:text>

		<xsl:text>Ausgabedatum</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>Einlösedatum</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:text>Kassierer</xsl:text>
		<xsl:value-of select="$delimiter" />
			<xsl:text>Gutschein Nr</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Betrag</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Beleg Nr</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Kunde</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Telefon</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Handy</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>EMail</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>PLZ</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Ort</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Straße</xsl:text>
			<xsl:value-of select="$delimiter" />
		<xsl:text>&#xa;</xsl:text>

		<xsl:for-each select="report/sales_voucher_out/row">
			<xsl:variable name="voucherValue">
				<xsl:call-template name="numberEFormat">
					<xsl:with-param name="value" select="voucher_value" />
	
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="formatdate">
				<xsl:with-param name="datestr" select="voucher_use_ts" />
			</xsl:call-template>
			<xsl:value-of select="$delimiter" />

				<xsl:choose>
					<xsl:when test="redeemed_sales_voucher_state = '6'">
						<xsl:text>Deaktiviert</xsl:text>
					</xsl:when>
					<xsl:otherwise>	
						<xsl:if test="redeemed_sales_voucher_use_ts">
							<xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="redeemed_sales_voucher_use_ts" /></xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			
			<xsl:value-of select="$delimiter" />

			<xsl:value-of select="employee_nm" />
			<xsl:value-of select="$delimiter" />

				<xsl:value-of select="voucher_cd" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="format-number($voucherValue, '###.##0,00', 'money')" />	
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="sales_inv_cd" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="customer_nm" />
				<xsl:value-of select="$delimiter" />

				<xsl:text>#</xsl:text><xsl:value-of select="phone" />
				<xsl:value-of select="$delimiter" />

				<xsl:text>#</xsl:text><xsl:value-of select="mobile" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="email" />
				<xsl:value-of select="$delimiter" />

				<xsl:text>#</xsl:text><xsl:value-of select="postal_cd" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="city" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="street" />
				<xsl:value-of select="$delimiter" />

			<xsl:text>&#xa;</xsl:text>
		</xsl:for-each>

		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:text>Summe</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:variable name="sumVoucherValues">	
			<xsl:for-each select="report/sales_voucher_out/row">
				
				<xsl:variable name="vVoucherValue">
					<xsl:call-template name="numberEFormat">
						<xsl:with-param name="value" select="voucher_value" />

					</xsl:call-template>
				</xsl:variable>
				
				<number>
					<xsl:value-of select="$vVoucherValue" />
				</number>
			</xsl:for-each>
			
		</xsl:variable>
		<xsl:value-of select='format-number(sum(exsl:node-set($sumVoucherValues)/number), "###.##0,00", "money")' />
										

		<xsl:value-of select="$delimiter" />
		<xsl:text>&#xa;</xsl:text>


	</xsl:template>

</xsl:stylesheet>