<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO" page-height="29.7cm" page-width="80mm" margin-top="0mm" margin-bottom="10mm" margin-left="5mm" margin-right="5mm">
					<fo:region-body margin-top="0mm" margin-bottom="10mm" margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="0mm" />
					<fo:region-after region-name="footer" extent="0mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="THERMO">
				<fo:static-content flow-name="header">
					<fo:block></fo:block>
				</fo:static-content>

				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left" font-size="8pt">
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block text-align="center" xsl:use-attribute-sets="report-title" width="70mm">
						Zählprotokoll
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/businessunit_nm" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_street" />
						,
						<xsl:value-of select="report/businessunits/row/bu_postal_cd" />
						&#160;
						<xsl:value-of select="report/businessunits/row/bu_city" />
						,
						<xsl:value-of select="report/businessunits/row/bu_country_cd" />
					</fo:block>

					<!-- Currency Symbol -->
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>

					<fo:table width="65mm" margin-top="10mm">
						<fo:table-column column-width="40%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="55%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr" select="report/report-params/DATE" />
										</xsl:call-template>
									</fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Kassenlade
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/drawers/row/drawer_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Erstellungsdatum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr" select="report/report-params/NOW" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Mitarbeiter
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/cashProtocolDetail/cash_protocol/employeeNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<fo:table width="65mm" margin-top="5mm">
						<fo:table-column column-width="52%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="43%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/cashProtocolDetail/cash_protocol/mode = 'modeCnt'">Summe laut Zählung</xsl:when>
											<xsl:otherwise>Kassenbestand</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/cashProtocolDetail/cash_protocol/sumCashProtocolDesc" />&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Kassenstand soll
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/cashProtocolDetail/cash_protocol/sumCashPosDesc" />&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="text-bold">
									<fo:block>
										Differenz
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="text-bold">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="text-bold">
									<fo:block>
										<xsl:value-of select="report/cashProtocolDetail/cash_protocol/cashProtocolDiffDesc" />&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:table table-layout="fixed" width="70mm" margin-top="5mm">
						<fo:table-column column-width="24mm"></fo:table-column>
						<fo:table-column column-width="5mm"></fo:table-column>
						<fo:table-column column-width="15mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row >
								<fo:table-cell text-align="left" number-columns-spanned="3" xsl:use-attribute-sets="text-bold">
									<fo:block>
										Anzahl
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:for-each select="report/cashProtocolDetail/cash_protocol/cash_protocol_list/cashnote">
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block margin-top="5mm">
											<xsl:value-of select="description" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block  margin-top="5mm">
											:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell2">
										<fo:block  margin-top="5mm">
											<xsl:value-of select="amount" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</xsl:for-each>

						
						</fo:table-body>
					</fo:table>
					<fo:block margin-top="10mm">
						&#160;  
					</fo:block>
					<fo:block id="LastPage"/>
			    </fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>