<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt"
	xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="barcode date">

<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4" page-height="29.7cm" page-width="21cm" margin-top="20mm" margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="5mm" margin-bottom="5mm" margin-left="5mm" margin-right="5mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="0mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<fo:block>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block text-align="right" font-size="8pt">
						Seite
						<fo:page-number />
						von
						<fo:page-number-citation ref-id="LastPage" />
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						Artikel mit Barcode
					</fo:block>
					<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
						<fo:table-column column-width="2cm"></fo:table-column>
						<fo:table-column column-width="5cm"></fo:table-column>
						<fo:table-column column-width="5cm"></fo:table-column>
						<fo:table-column column-width="5cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left">
									<fo:block>Artikel</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left">
									<fo:block>Bezeichnung</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left">
									<fo:block>EAN</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left">
									<fo:block>EAN 2</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="report/items/row">
								<fo:table-row>
									<fo:table-cell text-align="left" font-size="9pt" border-color="gray">
										<fo:block>
											<xsl:value-of select="item_cd" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left" font-size="9pt">
										<fo:block>
											<xsl:value-of select="item_nm" />
											<xsl:value-of select="item_nm2" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left" font-size="9pt">
										<fo:block>
											<fo:block text-align="center">
												<xsl:if test="item_ean != ''">
													<fo:instream-foreign-object>
														<xsl:variable name="barcode-cfg">
															<barcode>
																<code128>
																	<human-readable>none</human-readable>
																	<height>10mm</height>
																	<quiet-zone enabled="false" />
																</code128>
															</barcode>
														</xsl:variable>
														<xsl:copy-of select="barcode:generate($barcode-cfg, item_ean)" />
													</fo:instream-foreign-object>
												</xsl:if>
											</fo:block>
										</fo:block>
										<fo:block  text-align="center">
											<xsl:value-of select="item_ean" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left" font-size="9pt">
										<fo:block>
											<fo:block text-align="center">
												<xsl:if test="item_ean2 != ''">
													<fo:instream-foreign-object>
														<xsl:variable name="barcode-cfg">
															<barcode>
																<code128>
																	<human-readable>none</human-readable>
																	<height>10mm</height>
																	<quiet-zone enabled="false" />
																</code128>
															</barcode>
														</xsl:variable>
														<xsl:copy-of select="barcode:generate($barcode-cfg, item_ean2)" />
													</fo:instream-foreign-object>
												</xsl:if>
											</fo:block>
										</fo:block>
										<fo:block text-align="center">
											<xsl:value-of select="item_ean2" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</xsl:for-each>
						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>