<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">
 <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1Rotated">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="borderRotated">
		<xsl:attribute name="border-top-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableInnerSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
		<!-- <xsl:attribute name="font-weight">bold</xsl:attribute> -->
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableOuterSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderInnerSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderOuterSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="container_header">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.85cm</xsl:attribute>
	</xsl:attribute-set>
	
		<xsl:attribute-set name="containerHeader">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.00m</xsl:attribute>
		 <xsl:attribute name="width">3.0cm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	<xsl:attribute-set name="containerHeaderLabel">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.0cm</xsl:attribute>
		 <xsl:attribute name="margin-left">2mm</xsl:attribute>
		 <xsl:attribute name="keep-together">always</xsl:attribute>
		  <xsl:attribute name="padding-top">3mm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
						<xsl:variable name="employeeNm">
						Mitarbeiter: <xsl:value-of select="/report/employee/row/employee_nm" />
					</xsl:variable>
					    <xsl:call-template name="header">
							<xsl:with-param name="title" select='"Umsatzentwicklung (Modus: Ausführender MA)"' />
							<xsl:with-param name="businessunit" select="report/businessunits/row" />
							<xsl:with-param name="period1" select="report/report-params/DATE" />
							<xsl:with-param name="period2" select="report/report-params/TODATE" />
														<xsl:with-param name="filterRow" select="$employeeNm" />
						</xsl:call-template>
										
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="65%"></fo:table-column>
							<fo:table-column column-width="15%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Umsatz im Zeitverlauf (Modus: Ausführender MA)
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="totalProducts"
						select="sum(report/timeRevenue/row/r_total_products)" />
					<xsl:variable name="totalServices"
						select="sum(report/timeRevenue/row/r_total_services)" />
					<xsl:variable name="totalCustomers"
						select="sum(report/timeRevenue/row/r_amountcustomer)" />
					<xsl:variable name="totalRevenue"
						select="sum(report/timeRevenue/row/r_total)" />
					<xsl:variable name="countTime"
						select="count(report/timeRevenue/row/sort)" />
					
										<fo:table table-layout="fixed" border-collapse="collapse"
						 width="100%" margin-top="0.2cm">
						
						<fo:table-column column-width="15%"></fo:table-column>
						<xsl:for-each select="report/timeRevenue/row">
							<fo:table-column></fo:table-column>
						</xsl:for-each>
						<fo:table-column></fo:table-column>
						<fo:table-column></fo:table-column>
						<fo:table-header >
							<fo:table-row>
							
							  <fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold-left">
										<fo:block></fo:block>
								</fo:table-cell>
							<xsl:for-each select="report/timeRevenue/row">	
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block><xsl:value-of select="label" /></fo:block>
								</fo:table-cell>
							</xsl:for-each>
							 <fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
										<fo:block>Gesamt</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
										<fo:block>Ø</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-header>
						<fo:table-body>
							
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Umsatz DL Dame
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g1_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_g1_services, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(sum(report/sumRevenue/row/r_total_g1_services) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>	
								<!-- Umsatz Dienstleistung Herr // DL H -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Umsatz DL Herr
										</fo:block>
									</fo:table-cell>
									
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g2_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_g2_services, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(sum(report/sumRevenue/row/r_total_g2_services) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>	
								<!-- Umsatz Dienstleistung Kind // DL K -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Umsatz DL Kind
										</fo:block>
									</fo:table-cell>
									
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g3_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_g3_services, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(sum(report/sumRevenue/row/r_total_g3_services) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
								<!-- Umsatz Dienstleistung Gesamt / Umsatz DL  -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderInnerSum">
										<fo:block>
										 	Umsatz DL
										</fo:block>
									</fo:table-cell>
									
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_services, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of
												select="format-number(sum(report/sumRevenue/row/r_total_services) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									<!-- Umsatz Verkauf / Umsatz V  -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderInnerSum">
										<fo:block>
										 	Umsatz Verkauf
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_products, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_products, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_total_products) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									<!-- Umsatz Dame Gesamt / Umsatz D  -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Umsatz Dame Gesamt
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g1, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_g1, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_total_g1) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									<!-- Umsatz Herr Gesamt / Umsatz H  -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Umsatz Herr Gesamt
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g2, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_g2, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_total_g2) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									<!-- Umsatz Kind Gesamt / Umsatz K  -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Umsatz Kind Gesamt
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g3, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_g3, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_total_g3) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									
									<!-- Umsatz Gesamt -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderOuterSum">
										<fo:block>
										 	Umsatz Gesamt
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
											<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell></xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_total) div $countTime, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									<!-- Ø pro Tag /  Ums. G/Tag -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø Umsatz pro Tag
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row">
										<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style">
											<fo:block>
												<xsl:value-of
													select="format-number(r_total_per_day, '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</fo:block>
										</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_per_day, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 <xsl:value-of
												select="format-number(report/sumRevenue/row/r_total_per_day, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								<fo:table-row>	
									
									<!-- %Verkaufsanteil /  Ums.V. / Ums. G % -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Verkaufsanteil
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> <fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>


											<xsl:choose>
												<xsl:when test="r_total!=0">
													<xsl:value-of
														select="format-number((r_total_products div r_total) * 100, '###.##0,00', 'money')" />
													&#160;%

												</xsl:when>
												<xsl:otherwise>
													0,00&#160;%
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:choose>
											<xsl:when test="report/sumRevenue/row/r_total!=0">

												<xsl:value-of
													select="format-number((report/sumRevenue/row/r_total_products div report/timeRevenue/row/r_total) * 100, '###.##0,00', 'money')" />
												&#160;%
											</xsl:when>
											<xsl:otherwise>
												0&#160;%
											</xsl:otherwise>
										</xsl:choose>
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
								 	<xsl:choose>
											<xsl:when test="report/sumRevenue/row/r_total!=0">

												<xsl:value-of
													select="format-number((report/sumRevenue/row/r_total_products div report/timeRevenue/row/r_total) * 100, '###.##0,00', 'money')" />
												&#160;%
											</xsl:when>
											<xsl:otherwise>
												0&#160;%
											</xsl:otherwise>
										</xsl:choose>
										</fo:block>
									</fo:table-cell>
								
								</fo:table-row>
									<fo:table-row>	
									
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Anzahl Damen 
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row">
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amountgoup1" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of select="report/sumRevenue/row/r_amountgoup1" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_amountgoup1) div $countTime, '###.##0,##', 'amount')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Anzahl Herren
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row">
								
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amountgoup2" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of select="report/sumRevenue/row/r_amountgoup2" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_amountgoup2) div $countTime, '###.##0,##', 'amount')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Anzahl Kinder
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row">
								
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amountgoup3" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of select="report/sumRevenue/row/r_amountgoup3" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_amountgoup3) div $countTime, '###.##0,##', 'amount')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderInnerSum">
										<fo:block>
										 	Anzahl Besuche
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row">
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of select="r_amountcustomer" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 		<xsl:value-of select="report/sumRevenue/row/r_amountcustomer" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of
											select="format-number(sum(report/sumRevenue/row/r_amountcustomer) div $countTime, '###.##0,##', 'amount')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderInnerSum">
										<fo:block>
										 	Anzahl pro Tag
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row">
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="r_cnt_dt!=0">
													<xsl:value-of
														select="format-number( r_amountcustomer div r_cnt_dt, '###.##0,00', 'money')" />

												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of
											select="round(100*(report/sumRevenue/row/r_amountcustomer div report/sumRevenue/row/r_cnt_dt)) div 100" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
					 	<xsl:value-of
											select="round(100*(report/sumRevenue/row/r_amountcustomer div report/sumRevenue/row/r_cnt_dt)) div 100" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Ø DL Dame
										</fo:block>
									</fo:table-cell>
									
									<xsl:for-each select="report/timeRevenue/row">
									<!-- Anzahl Services/Dame -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_g1,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g1,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g1,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø DL Herr
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Anzahl Services/Herr -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_g2,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g2,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g2,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø DL Kind
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Anzahl Services/Kind -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_g3,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 		<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g3,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g3,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
								
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderInnerSum">
										<fo:block>
										 	Ø DL Besuch
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Anzahl Services/Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_cus,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
										 	<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_cus,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_cus,'###0,0', 'money')"/>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderInnerSum">
										<fo:block>
										 	Anzahl DL Gesamt
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<xsl:variable name="timeLabel" select="label" />
									<!-- Anzahl Services -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/anzahlDlNachBio/row[label = $timeLabel]/cnt_dl_bio,'###0,0', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_count_services,'###0,0', 'money')" />
												</xsl:otherwise>
											</xsl:choose>			
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/summeAnzahlDlNachBio/row/cnt_dl_bio,'###0,0', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(report/sumRevenue/row/r_count_services,'###0,0', 'money')" />
												</xsl:otherwise>
											</xsl:choose>			
										 	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(sum(/report/anzahlDlNachBio/row/cnt_dl_bio) div $countTime, '###.##0,0', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(sum(report/sumRevenue/row/r_count_services) div $countTime, '###.##0,0', 'money')" />
												</xsl:otherwise>
											</xsl:choose>			
										 	
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø Umsatz Dame
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Umsatz pro Dame -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g1, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g1, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g1, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø Umsatz Herr
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Umsatz pro Herr -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g2, '###.##0,00', 'money')" />
					
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g2, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g2, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Ø Umsatz Kind
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Umsatz pro Kind -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g3, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g3, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 	<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g3, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="tableHeaderOuterSum">
										<fo:block>
											 Ø Umsatz Gesamt
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Umsatz pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
										
										<xsl:choose>
												<xsl:when test="r_amountcustomer &lt; 0 and r_total &lt; 0">
													<xsl:value-of
														select="format-number(r_total div  (-1 * r_amountcustomer ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="r_amountcustomer=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number(r_total div  r_amountcustomer , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										
										

										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
										
										<xsl:choose>
												<xsl:when test="report/sumRevenue/row/r_amountcustomer &lt; 0 and report/sumRevenue/row/r_total &lt; 0">
													<xsl:value-of
														select="format-number(report/sumRevenue/row/r_total div  (-1 * report/sumRevenue/row/r_amountcustomer ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="report/sumRevenue/row/r_amountcustomer=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number(report/sumRevenue/row/r_total div  report/sumRevenue/row/r_amountcustomer , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										
										
										 	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
										 							<xsl:choose>
												<xsl:when test="report/sumRevenue/row/r_amountcustomer &lt; 0 and report/sumRevenue/row/r_total &lt; 0">
													<xsl:value-of
														select="format-number(report/sumRevenue/row/r_total div  (-1 * report/sumRevenue/row/r_amountcustomer ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="report/sumRevenue/row/r_amountcustomer=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number(report/sumRevenue/row/r_total div  report/sumRevenue/row/r_amountcustomer , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø Umsatz DL
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Umsatz Dienstleistungen pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:choose>
												<xsl:when test="r_amountcustomer &lt; 0 and r_total_services &lt; 0">
													<xsl:value-of
														select="format-number(r_total_services div  (-1 * r_amountcustomer ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="r_amountcustomer=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number(r_total_services div  r_amountcustomer , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										

										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										
										<xsl:choose>
												<xsl:when test="$totalCustomers &lt; 0 and $totalServices &lt; 0">
													<xsl:value-of
														select="format-number($totalServices div  (-1 * $totalCustomers ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="$totalCustomers=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number($totalServices div  $totalCustomers , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										
										
										 
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 											
										<xsl:choose>
												<xsl:when test="$totalCustomers &lt; 0 and $totalServices &lt; 0">
													<xsl:value-of
														select="format-number($totalServices div  (-1 * $totalCustomers ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="$totalCustomers=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number($totalServices div  $totalCustomers , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										
										
										 	
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
									<fo:table-row>	
								
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 	Ø Umsatz VK
										</fo:block>
									</fo:table-cell>
									<xsl:for-each select="report/timeRevenue/row"> 
									<!-- Umsatz Verkauf pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										
										
												<xsl:choose>
												<xsl:when test="r_amountcustomer &lt; 0 and r_total_products &lt; 0">
													<xsl:value-of
														select="format-number(r_total_products div  (-1 * r_amountcustomer ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="r_amountcustomer=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number(r_total_products div  r_amountcustomer , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
											

										</fo:block>
									</fo:table-cell>
									</xsl:for-each>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										<xsl:choose>
												<xsl:when test="$totalCustomers &lt; 0 and $totalProducts &lt; 0">
													<xsl:value-of
														select="format-number($totalProducts div  (-1 * $totalCustomers ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="$totalCustomers=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number($totalProducts div  $totalCustomers , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										
										
										 	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										 										<xsl:choose>
												<xsl:when test="$totalCustomers &lt; 0 and $totalProducts &lt; 0">
													<xsl:value-of
														select="format-number($totalProducts div  (-1 * $totalCustomers ), '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:when test="$totalCustomers=0">
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number($totalProducts div  $totalCustomers , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
					</fo:table>
					<fo:block id="LastPage"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
