<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt"
	xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." />

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="Voucher" page-height="57mm" page-width="57mm" margin-top="0mm" margin-bottom="0mm" margin-left="0mm" margin-right="0mm" reference-orientation="0">
					<fo:region-body margin-top="5mm" margin-bottom="5mm" margin-left="6mm" margin-right="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="Voucher">
				<fo:flow flow-name="xsl-region-body">
					<fo:block-container width="46mm">
						<fo:block text-align="center" font-size="8pt">
							<fo:instream-foreign-object>
								<xsl:variable name="barcode-cfg">
									<barcode width="40mm">
										<code128>
											<human-readable>none</human-readable>
											<height>16mm</height>
											<module-width>0.23mm</module-width>
											<quiet-zone enabled="false" />
										</code128>
									</barcode>
								</xsl:variable>
								<xsl:copy-of select="barcode:generate($barcode-cfg, /SalesVoucher/salesVoucherCd)" /> 
							</fo:instream-foreign-object>
						</fo:block>
						<fo:block font-size="8pt" text-align="center"><xsl:value-of select="/SalesVoucher/salesVoucherCd"/>&#160;
						<xsl:value-of select='format-number(/SalesVoucher/voucherValue, "###.##0,00", "money")' />&#160;€
						</fo:block>
					</fo:block-container>
					
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>