<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />



	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>

			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdate2">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdate3">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm" select="'01'">

		</xsl:variable>

		<xsl:variable name="dd" select="'01'">

		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdatedmm">
		<xsl:param name="datestr" />

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,4,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,1,2)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:choose>
					<xsl:when test="substring($dd,1,1) = 0">
						<xsl:value-of select="substring($dd,2,1)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$dd" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$mm" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />

	<xsl:include href="./CustomCashJounalMap.xsl" />
	<xsl:include href="./csvRowCashJournalType2.xsl" />
	<xsl:include href="./csvRowCashJournalType1.xsl" />

	<xsl:template name="numberEFormat" >
  <xsl:param name="value" />
 
	<xsl:choose>
		<xsl:when test="not(contains($value,'E'))">
			<xsl:value-of select="$value"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="vExponent" select="substring-after($value,'E')"/>
			<xsl:variable name="vMantissa" select="substring-before($value,'E')"/>
			
			<xsl:variable name="vFactor">
				<xsl:choose>
					<xsl:when test="starts-with($vExponent,'-')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>		
					<xsl:when test="starts-with($vExponent,'+')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>							
					<xsl:otherwise>
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,1) + 1)" />
					</xsl:otherwise>
				</xsl:choose>				   
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($vExponent,'-')">
					<xsl:value-of select="$vMantissa div $vFactor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$vMantissa * $vFactor"/>
				</xsl:otherwise>
			</xsl:choose>
		
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>


	<xsl:template name="getCSVTypeForAllBu">
	<xsl:for-each select="/report/businessunits/row[position()=1]">

			
			
					<xsl:call-template name="getCsvType">
						<xsl:with-param name="posCd" select="pos_cd_hint"></xsl:with-param>
					</xsl:call-template>

		</xsl:for-each>
	
	</xsl:template>

	<xsl:template match="/">

		<xsl:variable name="currencyCd">
			<xsl:value-of select="report/departmentCurrency/row/currency_cd"></xsl:value-of>
		</xsl:variable>

        <xsl:variable name="csvRowType">
			<xsl:call-template name="getCSVTypeForAllBu">				
			</xsl:call-template>

		</xsl:variable>
		
		

		<xsl:if test="$csvRowType = '2'">
			<!-- Output the CSV column header -->
			<xsl:call-template name="printheader2">
			</xsl:call-template>
		</xsl:if>
    	<xsl:if test="$csvRowType = '1'">
			<!-- Output the CSV column header -->
			<xsl:call-template name="printheader1">
			</xsl:call-template>
		</xsl:if>
			

			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		

		<xsl:for-each select="/report/businessunits/row">
			<xsl:variable name="pointOfSales" select="pos_cd_hint" />
			<xsl:variable name="buNm1" select="bu_nm_1" />



			<xsl:for-each
				select="/report/cash_journal/pos_cash_journal/point_of_sales[pos_cd=$pointOfSales]/data/row">
				<xsl:variable name="counter" select="position()" />
				<xsl:variable name="property" select="." />

				<xsl:choose>
					<xsl:when test="$csvRowType = '2'">

						<xsl:call-template name="printbusinessunitdata2">
							<xsl:with-param name="posCd" select="$pointOfSales"></xsl:with-param>
							<xsl:with-param name="buNm1" select="$buNm1"></xsl:with-param>
							<xsl:with-param name="property" select="$property"></xsl:with-param>
							<xsl:with-param name="counter" select="$counter"></xsl:with-param>

						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="printbusinessunitdata1">
							<xsl:with-param name="posCd" select="$pointOfSales"></xsl:with-param>
							<xsl:with-param name="buNm1" select="$buNm1"></xsl:with-param>
							<xsl:with-param name="property" select="$property"></xsl:with-param>
							<xsl:with-param name="counter" select="$counter"></xsl:with-param>

						</xsl:call-template>
					</xsl:otherwise>

				</xsl:choose>
				<!-- Add a newline at the end of the record -->
				<xsl:text>
</xsl:text>


			</xsl:for-each>

		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>