<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
   <xsl:import href="Header.xsl"/>

<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>
	
	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>
	

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:value-of select="$dd" />
		<xsl:value-of select="'.'" />
		<xsl:value-of select="$mm" />
		<xsl:value-of select="'.'" />
		<xsl:value-of select="$yyyy" />
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:value-of select="$time" />
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		

		<xsl:value-of select="$dd" />
		<xsl:value-of select="'.'" />
		<xsl:value-of select="$mm" />
		<xsl:value-of select="'.'" />
		<xsl:value-of select="$yyyy" />
		<xsl:text>, </xsl:text>
		<xsl:value-of select="$time" />
	</xsl:template>
	
	<xsl:template name="getECAcctCd">
		<xsl:param name="acctCd" />
		<xsl:param name="posCd" />
		<xsl:choose>
			<xsl:when test="$acctCd = 2350">
				<xsl:choose>
					<xsl:when test="$posCd = 'P1'">
							<xsl:value-of select="2320" />
					</xsl:when>
					<xsl:when test="$posCd = 'P2'">
							<xsl:value-of select="2310" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$acctCd" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
					<xsl:value-of select="$acctCd" />
				</xsl:otherwise>
		</xsl:choose>							
		
	</xsl:template>
	
	
	<xsl:template name="getCCAcctCd">
	<xsl:param name="acctCd" />
		<xsl:param name="posCd" />
		<xsl:call-template name="getECAcctCd">
			<xsl:with-param name="acctCd" select='$acctCd' />
			<xsl:with-param name="posCd" select='$posCd' />
		</xsl:call-template>
	</xsl:template>
	
		<xsl:template name="getDrawerAcctCd">
		<xsl:param name="acctCd" />
		<xsl:param name="posCd" />
		<xsl:choose>
			<xsl:when test="$acctCd = 2703">
				<xsl:choose>
					<xsl:when test="$posCd = 'P1'">
							<xsl:value-of select="2701" />
					</xsl:when>
					<xsl:when test="$posCd = 'P2'">
							<xsl:value-of select="2700" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$acctCd" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
					<xsl:value-of select="$acctCd" />
				</xsl:otherwise>
			</xsl:choose>				
		
	</xsl:template>
	
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="23mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="23mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>



			<fo:page-sequence master-reference="A4">
			
				<xsl:variable name="viewMode">
					<xsl:choose>
						<xsl:when test="report/report-params/USE_BOOKUNG_TS = 'true'">
							<xsl:value-of select="'Ansicht nach Buchungsdatum'"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'Ansicht nach Wertstellungsdatum'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
			
			<xsl:variable name="posCd"  >
				<xsl:value-of select="report/businessunits/row/pos_cd_hint"></xsl:value-of>
			</xsl:variable>
			
				<fo:static-content flow-name="header">
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Kassenauswertung"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="creation" select="report/report-params/NOW" />
						<xsl:with-param name="viewMode" select="$viewMode" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											Erstellt: <xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Kassenauswertung									
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>&#160;-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
								<xsl:for-each select="report/pos_payment_statistics/pos_stats/pos_stats_day">
								
									<xsl:variable name="dateIter" select="payment_dt/text()" />
								
									
					<fo:table table-layout="fixed"  border-collapse="collapse" 
						 width="100%">
						 <xsl:if test="position() != last()">
						    <xsl:attribute name="page-break-after">always</xsl:attribute>
						 </xsl:if>
						<fo:table-column column-width="1.5cm"></fo:table-column>
						<fo:table-column column-width="1.2cm"></fo:table-column>
						<fo:table-column column-width="3.9cm"></fo:table-column>
						<fo:table-column column-width="1.8cm"></fo:table-column>
						<fo:table-column column-width="1.9cm"></fo:table-column>
						<fo:table-column column-width="0.9cm"></fo:table-column>
						<fo:table-column column-width="1.9cm"></fo:table-column>
						<fo:table-column column-width="1.7cm"></fo:table-column>
						<fo:table-column column-width="0.9cm"></fo:table-column>
						<fo:table-column column-width="1.3cm"></fo:table-column>
						
						<fo:table-header>
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Konto
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Belegtext
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Eingang
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Netto
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										MwSt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Ausgang
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										Netto
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										MwSt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
									<fo:block>
										i
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</fo:table-header>
						
							
					<fo:table-body>
								
									<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="$dateIter" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Saldovortrag
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										
										<xsl:value-of
											select="format-number(beforeCashValue, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="pos_stats_drawer/row">
							
							<xsl:variable name="drawerNo" select="drawer_no"></xsl:variable>
							
									<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									Saldovortrag <xsl:value-of
											select="/report/pos_drawers/row[drawer_no=$drawerNo]/drawer_nm" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										
										<xsl:value-of
											select="format-number(beforeCashValue, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
								
								
								</xsl:for-each>
					
							
							<xsl:for-each select="pos_stats_rev_acct/row">
								<xsl:variable name="itemRevenueAcctNo" select="itemRevenueAcctNo/text()" />
							
							
							
						<xsl:if test="grossPrice != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of select="/report/simple_accounts/row[simple_acct_cd=$itemRevenueAcctNo]/acct_cd" />
									
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of select="/report/simple_accounts/row[simple_acct_cd=$itemRevenueAcctNo]/simple_acct_nm" />
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(grossPrice, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(netPrice, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$itemRevenueAcctNo]/tax_rate_percent" />
										&#160;
								
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						<xsl:if test="rebate!=0">	
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									Rabatte  									
											<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_cd=$itemRevenueAcctNo]/simple_acct_nm" />
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										&#160;
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
								
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
											<xsl:value-of
											select="format-number(rebate, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</xsl:if>
							</xsl:for-each>
							
						
							
							
							
						<xsl:if test="paymentForPrevDaysNotes != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=10]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=10]/simple_acct_nm" />
									
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(paymentForPrevDaysNotes, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
									&#160;
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						<xsl:if test="dayOpenDepts != 0">				
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=13]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=13]/simple_acct_nm" />
									
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(dayOpenDepts, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
									&#160;
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						<xsl:if test="creditNoteOutValue != 0">	
									<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=12]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=12]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(creditNoteOutValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										&#160;
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						
						
							<xsl:for-each select="pos_stats_voucher_acct/row[direction=2]">
							
						<xsl:variable name="acctCd" select="simpleAcctCd" />
						
						<xsl:if test="grossValue != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
								
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/acct_cd" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
								
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
								
										<xsl:value-of
											select="format-number(grossValue, '###.##0,00', 'money')" />
									    
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
						
						<xsl:for-each select="pos_stats_sales_tip_acct/row[direction=2]">
							
						<xsl:variable name="acctCd" select="simpleAcctCd" />
						<xsl:variable name="contraAcctCd" select="contraSimpleAcctCd" />
						
						<xsl:if test="grossValue != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
								
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/acct_cd" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:choose>
											 <xsl:when test="$contraAcctCd">
												 <xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />- <xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$contraAcctCd]/simple_acct_nm" />
											 </xsl:when>
											<xsl:otherwise>
											
												<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
									<xsl:value-of
											select="format-number(grossValue, '###.##0,00', 'money')" />
								
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
							
										
							
						
						<xsl:if test="transferPurchaseOutValue != 0">				
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=15]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=15]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(transferPurchaseOutValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
											&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
					
									<xsl:variable name="totalIn" select="sum(/report/payments_in_out/row[payment_dt_d=$dateIter][payment_direction=1]/payment)" />
				
						<xsl:for-each select="/report/payments_in_out/row[payment_dt_d=$dateIter][payment_direction=1]">
							<xsl:variable name="drawerNo" select="drawer_no/text()" />
						<xsl:variable name="acctCd" select="/report/pos_drawers/row[drawer_no=$drawerNo]/acct_cd" />
						<xsl:variable name="contraAcctCd" select="contra_acct_cd/text()" />
						<xsl:if test="payment != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
								
									
									<xsl:call-template name="getDrawerAcctCd">
										<xsl:with-param name="acctCd" select='/report/simple_accounts/row[simple_acct_cd=$acctCd]/acct_cd' />
										<xsl:with-param name="posCd" select='$posCd' />
									</xsl:call-template>
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:choose>
										<xsl:when test="/report/pos_drawers/row[acct_cd=$contraAcctCd]/drawer_no">
									
									 <xsl:if test="payment_direction=2">
									    	 Umbuchung nach  
								            </xsl:if>
								              <xsl:if test="payment_direction=1">
									    	 Umbuchung von  
								            </xsl:if>
								            <xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$contraAcctCd]/simple_acct_nm" />
													
									
									</xsl:when>
									 <xsl:otherwise>
									 <xsl:if test="payment_direction=1">
										Einlage  <xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
									</xsl:if>
									<xsl:if test="payment_direction=2">
											Entnahme <xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
									</xsl:if>
									<xsl:if test="$contraAcctCd!='-'"> - <xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$contraAcctCd]/simple_acct_nm" />
															</xsl:if>
									 </xsl:otherwise>
									 </xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
									<xsl:choose>
								    	<xsl:when test="payment_direction=1">
								           
										<xsl:value-of
											select="format-number(payment, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</xsl:when>
									    <xsl:otherwise>
									    
										
											&#160;
									
									    	</xsl:otherwise>
									</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:choose>
								    	<xsl:when test="payment_direction=2">
								           
										<xsl:value-of
											select="format-number(payment, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</xsl:when>
									    <xsl:otherwise>
									    
										
											&#160;
									
									    	</xsl:otherwise>
									</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
		
							
						<xsl:if test="transferSIValue != 0">				
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=16]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=16]/simple_acct_nm" />
									
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
											&#160;
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
									<xsl:value-of
											select="format-number(transferSIValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>			
						</xsl:if>	
						<xsl:if test="dayOpenNotesToPayValue != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=9]/acct_cd" />
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=9]/simple_acct_nm" />
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(dayOpenNotesToPayValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						<xsl:if test="payedOpenDepts != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=14]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=14]/simple_acct_nm" />
									
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
										<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(payedOpenDepts, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>	
					
						
							
						<xsl:for-each select="pos_purchase_accts/row">
						
						<xsl:variable name="simpleAcctCd" select="simpleAcctCd/text()" />
						
						
						<xsl:if test="grossPrice != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_cd=$simpleAcctCd]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$simpleAcctCd]/simple_acct_nm" />
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(grossPrice, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="format-number(netPrice, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$simpleAcctCd]/tax_rate_percent" />
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
					
					
					
					
					<xsl:variable name="totalOut" select="sum(/report/payments_in_out/row[payment_dt_d=$dateIter][payment_direction=2]/payment)" />
						
						<xsl:for-each select="/report/payments_in_out/row[payment_dt_d=$dateIter][payment_direction=2]">
						
						<xsl:variable name="drawerNo" select="drawer_no/text()" />
						<xsl:variable name="acctCd" select="/report/pos_drawers/row[drawer_no=$drawerNo]/acct_cd" />
						<xsl:variable name="contraAcctCd" select="contra_acct_cd/text()" />
						<xsl:if test="payment != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									
									
									<xsl:call-template name="getDrawerAcctCd">
										<xsl:with-param name="acctCd" select='/report/simple_accounts/row[simple_acct_cd=$acctCd]/acct_cd' />
										<xsl:with-param name="posCd" select='$posCd' />
									</xsl:call-template>
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:choose>
									
									<xsl:when test="/report/pos_drawers/row[acct_cd=$contraAcctCd]/drawer_no">
									
									 <xsl:if test="payment_direction=2">
									    	 Umbuchung nach  
								            </xsl:if>
								              <xsl:if test="payment_direction=1">
									    	 Umbuchung von  
								            </xsl:if>
								            <xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$contraAcctCd]/simple_acct_nm" />
													
									
									</xsl:when>
									 <xsl:otherwise>
									 <xsl:if test="payment_direction=1">
										Einlage <xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
									</xsl:if>
									<xsl:if test="payment_direction=2">
											Entnahme <xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
									</xsl:if>
									<xsl:if test="$contraAcctCd!='-'"> - <xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$contraAcctCd]/simple_acct_nm" />
															</xsl:if>
									 </xsl:otherwise>
									 
									 
								    
									</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
									<xsl:choose>
								    	<xsl:when test="payment_direction=1">
								           
										<xsl:value-of
											select="format-number(payment, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</xsl:when>
									    <xsl:otherwise>
									    
										
											&#160;
									
									    	</xsl:otherwise>
									</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:choose>
								    	<xsl:when test="payment_direction=2">
								           
										<xsl:value-of
											select="format-number(payment, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</xsl:when>
									    <xsl:otherwise>
									    
										
											&#160;
									
									    	</xsl:otherwise>
									</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
		
		
						<xsl:if test="creditNoteInValue != 0">	
						<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=11]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=11]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(creditNoteInValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						
						
							<xsl:for-each select="pos_stats_voucher_acct/row[direction=1]">
							
						<xsl:variable name="acctCd" select="simpleAcctCd" />
						
						<xsl:if test="grossValue != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
								
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/acct_cd" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
								
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
								
									&#160;
									    
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(grossValue, '###.##0,00', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
						
									
						<xsl:for-each select="pos_stats_sales_tip_acct/row[direction=1]">
							
						<xsl:variable name="acctCd" select="simpleAcctCd" />
						<xsl:variable name="contraAcctCd" select="contraSimpleAcctCd" />
						
						<xsl:if test="grossValue != 0">
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
								
									<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/acct_cd" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:choose>
											 <xsl:when test="$contraAcctCd">
												 <xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />- <xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$contraAcctCd]/simple_acct_nm" />
											 </xsl:when>
											<xsl:otherwise>
											
												<xsl:value-of
													select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(grossValue, '###.##0,00', 'money')" />
									    
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
									&#160;  
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							</xsl:for-each>
							
						
							
						<xsl:if test="onlineValue != 0">		
						<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=25]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=25]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(onlineValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>				
			
						<xsl:if test="lossValue != 0">		
						<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=27]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=27]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(lossValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>				
							
							
					
						<xsl:if test="ecValue != 0">		
							
						
						<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:call-template name="getECAcctCd">
										<xsl:with-param name="acctCd" select='/report/simple_accounts/row[simple_acct_type=6]/acct_cd' />
										<xsl:with-param name="posCd" select='$posCd' />
									</xsl:call-template>
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=6]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(ecValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						
					<xsl:if test="ccValue != 0">		
						<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:call-template name="getCCAcctCd">
										<xsl:with-param name="acctCd" select='/report/simple_accounts/row[simple_acct_type=7]/acct_cd' />
										<xsl:with-param name="posCd" select='$posCd' />
									</xsl:call-template>
									
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=7]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(ccValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
							
						
					<xsl:if test="discountValue != 0">		
						<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
									&#160;
									</fo:block>
								</fo:table-cell>
							<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=8]/acct_cd" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
									<xsl:value-of
											select="/report/simple_accounts/row[simple_acct_type=8]/simple_acct_nm" />
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										
										<xsl:value-of
											select="format-number(discountValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									&#160;
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
									
											&#160;
									
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						
							<xsl:variable name="paymentOut" select="paymentOut" />
				        	<xsl:variable name="paymentIn" select="paymentIn" />
								
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										Tagessumme
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										<xsl:value-of
											select="format-number($totalIn  + $paymentIn, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
								
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										<xsl:value-of
											select="format-number( $totalOut  + $paymentOut, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									    	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
											&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="pos_stats_drawer/row">
										
							<xsl:variable name="drawerNo" select="drawer_no"></xsl:variable>
							
									<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Saldo <xsl:value-of
											select="/report/pos_drawers/row[drawer_no=$drawerNo]/drawer_nm" /> am <xsl:value-of
											select="$dateIter" />
									</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										
										<xsl:value-of
											select="format-number(endCashValue, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
								
								
								</xsl:for-each>
							<fo:table-row>
								<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										Saldo am <xsl:value-of
											select="$dateIter" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
											<xsl:value-of
											select="format-number(endCashValue, '###.##0,00', 'money')" />
									    	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						
							
					   	</fo:table-body>
					 </fo:table>
						</xsl:for-each>
					
					
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>