<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	 xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
	    <column>r_dt<desc>Tag</desc></column>
        <column>r_employee_no<desc>Mitarbeiter-Nr.</desc></column>
		<column>r_employee_nm<desc>Mitarbeiter</desc></column>
		<column>r_total_g1_services<desc>Umsatz DL D</desc></column>
		<column>r_total_g2_services<desc>Umsatz DL H</desc></column>
		<column>r_total_g3_services<desc>Umsatz DL K</desc></column>
		<column>r_total_services<desc>Umsatz DL</desc></column>
		<column>r_total_products<desc>Umsatz V</desc></column>
		<column>r_total_g1<desc>Umsatz G D</desc></column>
		<column>r_total_g2<desc>Umsatz G H</desc></column>
		<column>r_total_g3<desc>Umsatz G K</desc></column>
		<column>r_total<desc>Umsatz G</desc></column>
		<column>r_amount_group1<desc>Anzahl D</desc></column>
		<column>r_amount_group2<desc>Anzahl H</desc></column>
		<column>r_amount_group3<desc>Anzahl K</desc></column>
		<column>r_amount_customer<desc>Anzahl Besuche G</desc></column>
		<column>r_count_services<desc>Anzahl DL</desc></column>
	
		
	</csv:columns>

	<xsl:template match="/">

		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>



			<xsl:for-each select="report/employeeRevenue/row">
			<xsl:variable name="property" select="." />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
					<xsl:when test="starts-with($column,'r_total')"><xsl:value-of select="format-number($value, '###.##0,00', 'money')" /></xsl:when>
					<xsl:when test="$column='r_dt'">
					<xsl:call-template name="formatdate"><xsl:with-param name="datestr"	select="$value" /></xsl:call-template></xsl:when>
					<xsl:when test="$column='r_employee_nm'"><xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text></xsl:when>
					
					<xsl:otherwise>
						<xsl:value-of select="$value" />
					</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		</xsl:for-each>
	</xsl:template>

	

</xsl:stylesheet>