<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO"
					page-height="20cm" page-width="80mm" margin-top="0mm"
					margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
					<fo:region-body margin-top="0mm" margin-bottom="0mm"
						margin-left="5mm" margin-right="5mm" />
					<fo:region-before region-name="header" extent="7mm" />
					<fo:region-after region-name="footer" extent="7mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="THERMO">
				<fo:static-content flow-name="header">
					<fo:block>
						<!-- <fo:instream-foreign-object xmlns:svg="http://www.w3.org/2000/svg"> 
							<svg:svg width="80mm" height="150mm"> <svg:g style="fill:red; stroke:#000000; 
							fill-opacity=0.8"> <svg:text x="50" y="70" font-family="Verdana" font-size="30" 
							transform="rotate(60 20,40)"> Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> 
							</fo:instream-foreign-object> -->
					</fo:block>
				</fo:static-content>
				<!-- <fo:static-content flow-name="footer"> <fo:block xsl:use-attribute-sets="text-style" 
					text-align="center"> Seite <fo:page-number /> von <fo:page-number-citation 
					ref-id="LastPage" /> </fo:block> </fo:static-content> -->

				<fo:flow flow-name="xsl-region-body">




					<fo:block-container width="100%">
						<xsl:for-each select="EcashNote/EcashNoteLine">


							<xsl:choose>
								<xsl:when test="lineDecoration = 'L'">
									<!-- linksbündig -->
									<fo:block xsl:use-attribute-sets="text-style"
										text-align="left">
										<xsl:value-of select="lineTxt" />
									</fo:block>

								</xsl:when>

								<xsl:when test="lineDecoration = 'R'">
									<!-- rechtsbündig -->
									<fo:block xsl:use-attribute-sets="text-style"
										text-align="right">
										<xsl:value-of select="lineTxt" />
									</fo:block>

								</xsl:when>

								<xsl:when test="lineDecoration = 'Z'">
									<!-- zentriert -->
									<fo:block xsl:use-attribute-sets="text-style"
										text-align="center">
										<xsl:value-of select="lineTxt" />
									</fo:block>

								</xsl:when>

								<xsl:when test="lineDecoration = 'ZF'">
									<!-- zentriert -->
									<fo:block xsl:use-attribute-sets="text-bold"
										text-align="center">
										<xsl:value-of select="lineTxt" />
									</fo:block>

								</xsl:when>

								<xsl:when test="lineDecoration = 'F'">
									<!-- bold -->
									<fo:block xsl:use-attribute-sets="text-bold"
										text-align="left">
										<xsl:value-of select="lineTxt" />
									</fo:block>

								</xsl:when>


								<xsl:otherwise>

									<fo:block xsl:use-attribute-sets="text-style"
										text-align="left">
										<xsl:choose>
											<xsl:when test="lineTxt">
												<xsl:value-of select="lineTxt" />
											</xsl:when>
											<xsl:otherwise>
												&#160;
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>

								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</fo:block-container>

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
