<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">

	
	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." />


<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell-style-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="content-separator">
		<xsl:attribute name="border-bottom">0.5mm solid</xsl:attribute>
		<xsl:attribute name="margin-top">2mm</xsl:attribute>
		<xsl:attribute name="margin-bottom">2mm</xsl:attribute>
	</xsl:attribute-set>


	<xsl:template name="receiptdata">
		<xsl:param name="PosPayment" />
		<!-- Body Variables -->
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="$PosPayment/departmentCurrencySymbol"></xsl:value-of>
					</xsl:variable>
				
					<!-- LOGO -->
					<fo:block-container width="100%" text-align="center" >
						<fo:block>
							<fo:external-graphic content-width="scale-to-fit" content-height="100%" width="100%" scaling="uniform">
								<xsl:attribute name="src"><xsl:value-of select="$PosPayment/buLogoUrl" /></xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</fo:block-container>

					<!-- BU DATA -->
					<fo:block-container width="100%">
						<!-- CompanyName shows only if differently from SalonName -->
						<xsl:if test="$PosPayment/businessunitAdr0 != $PosPayment/buNm1">
							<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
								<xsl:value-of select="$PosPayment/businessunitAdr0" />
							</fo:block>
						</xsl:if>

						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$PosPayment/buNm1" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$PosPayment/buNm2" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$PosPayment/businessunitAdr2" />&#160;<xsl:value-of select="$PosPayment/businessunitAdr3" />
						</fo:block>

						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							eMail:&#160;<xsl:value-of select="$PosPayment/buEmail" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Telefon:&#160;<xsl:value-of select="$PosPayment/buPhone" />
						</fo:block>

					</fo:block-container>



				



					<!-- Kassierer -->
					<fo:block-container width="100%" margin-top="5mm">
						
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Mitarbeiter/in:<xsl:value-of select="$PosPayment/employeeNm" />
						</fo:block>
					</fo:block-container>

				

					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="content-separator">
						</fo:block>
					</fo:block-container>

					
					<fo:block-container width="100%" text-align="center">
						<fo:block >
							<xsl:choose>
								<xsl:when test="$PosPayment/paymentDirection = 2">
									Entnahme
								</xsl:when>
								
								<xsl:otherwise>
									Einlage
								</xsl:otherwise>
							
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container width="100%" margin-top="2mm" margin-bottom="2mm">

					
								<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
									Schublade:<xsl:value-of select="$PosPayment/drawerNm" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
									Wertstellung:<xsl:value-of select="$PosPayment/paymentTsD" />&#160;<xsl:value-of select="$PosPayment/paymentTsT" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
									Gebucht: <xsl:value-of select="$PosPayment/paymentBookingTsD" />&#160;<xsl:value-of select="$PosPayment/paymentBookingTsT" />
								</fo:block>
					</fo:block-container>


					<fo:block-container width="100%">
					<!-- payments Tabelle -->
					<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">

						
						<fo:table-column column-width="80%"></fo:table-column>
					
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-body>
						
							<!-- EMPTY ROW -->
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-default" text-align="left"></fo:block> 
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row >
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-style-bold" text-align="left">Anmerkung</fo:block> 
								</fo:table-cell>
							<!--	<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-default" text-align="left">Nach</fo:block> 
								</fo:table-cell> -->
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-style-bold" text-align="left">Wert</fo:block> 
								</fo:table-cell>
							</fo:table-row> 
		

							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
								<!--	<xsl:choose>
								<xsl:when test="$PosPayment/paymentDirection = 2">
									Nach
								</xsl:when>
								
								<xsl:otherwise>
									Von
								</xsl:otherwise>
							
							</xsl:choose> -->
									
										<xsl:choose>
											<xsl:when test="$PosPayment/contraDrawerNo">
												<xsl:value-of select="$PosPayment/contraDrawerNm" />
												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$PosPayment/contraAcctNm" />
											</xsl:otherwise>
										
										</xsl:choose>
										
									</fo:block> 
								
									<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
										<xsl:value-of select="$PosPayment/paymentRef" />
									</fo:block> 
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
										<xsl:value-of select='format-number($PosPayment/payment,"###.##0,00", "money")' />
									</fo:block> 
								</fo:table-cell>
							</fo:table-row>
										
						
				


						
						</fo:table-body>
					</fo:table>

					</fo:block-container>
					
				
				
					<fo:block-container border="1px solid #ffffff">
						<fo:block margin-top="5mm"/>
					</fo:block-container>
						
					<fo:block id="LastPage" margin-top="5mm"/>
	</xsl:template>

</xsl:stylesheet>