<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" 	xmlns:exsl="http://exslt.org/common" 
	extension-element-prefixes="barcode exsl date">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="footer-text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>

	</xsl:attribute-set>


	<xsl:attribute-set name="report-table">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>		
		<xsl:attribute name="border-width">1pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell">
		<xsl:attribute name="border-style">solid</xsl:attribute>		
		<xsl:attribute name="border-width">1pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-header"  use-attribute-sets="report-cell">		
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="report-cell-bold"  use-attribute-sets="report-cell">		
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-main-topic"  use-attribute-sets="report-cell-bold">		
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
		<xsl:attribute name="background-color">#999999</xsl:attribute>
		
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-main-topic-no-bg"  use-attribute-sets="report-cell-bold">		
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>	
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-sub-topic"  use-attribute-sets="report-cell-bold">		
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		
	</xsl:attribute-set>
	


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="tgDivision-format">
		<xsl:param name="divident" />
		<xsl:param name="divisor" />
		<xsl:param name="format" />
		<xsl:param name="negativCorrection" />
			<xsl:choose>
				<xsl:when test="$divisor &lt; 0 and $divident &lt; 0">
					<xsl:value-of select="format-number($divident div  ($negativCorrection * $divisor ), $format, 'money')" />
				</xsl:when>
				<xsl:when test="$divisor=0">
					0,00
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of	select="format-number($divident div  $divisor , $format, 'money')" />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>

	<xsl:template name="tgDivision">
		<xsl:param name="divident" />
		<xsl:param name="divisor" />
		<xsl:param name="negativCorrection" />
			<xsl:choose>
			<!--	<xsl:when test="string(number($divident)) = 'NaN'">
  					 <xsl:value-of	select="0" />
				</xsl:when>
				<xsl:when test="string(number($divisor)) = 'NaN'">
  					 <xsl:value-of	select="0" />
				</xsl:when>  -->
				<xsl:when test="$divisor &lt; 0 and $divident &lt; 0">
					<xsl:value-of select="$divident div  ($negativCorrection * $divisor )" />
				</xsl:when>
				<xsl:when test="$divisor=0">
					<xsl:value-of	select="$divisor" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of	select="$divident div  $divisor " />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>


	<xsl:template name="table-customer">
		<xsl:param name="customerVisitData" />
		<xsl:param name="customerVisitDataFreq" />
		<xsl:param name="frequences" />
		
	<!--	<xsl:call-template name="table-title-row">
			<xsl:with-param name="title" select="'Neukunden'" />
			<xsl:with-param name="cntFrequenzes" select="count($frequences)"/>
		</xsl:call-template>
		-->


		<xsl:variable name="cntFrequences" select="count($frequences)"/>
		
		
		<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="'Neukunden'" />
						</fo:block>
					</fo:table-cell> 
	
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
							<fo:block>
								<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg1 + $customerVisitDataFreq[label=$freqLabel]/neukunden_cg2 + $customerVisitDataFreq[label=$freqLabel]/neukunden_cg3, '###.##0,##', 'amount')"/>
							</fo:block>
						</fo:table-cell> 

					</xsl:for-each>
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>

							<xsl:variable name="avgD">
								<xsl:for-each select="$frequences">
									<xsl:variable name="freqLabel" select="label" />
									<number>
										<xsl:choose>
											<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg1 + $customerVisitDataFreq[label=$freqLabel]/neukunden_cg2 + $customerVisitDataFreq[label=$freqLabel]/neukunden_cg3)) != 'NaN'">
												<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/neukunden_cg1 + $customerVisitDataFreq[label=$freqLabel]/neukunden_cg2 + $customerVisitDataFreq[label=$freqLabel]/neukunden_cg3"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
									
									</number> 
								</xsl:for-each>
							</xsl:variable>
								
							<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
		
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="format-number($customerVisitData/neukunden_cg1 + $customerVisitData/neukunden_cg2+ $customerVisitData/neukunden_cg3, '###.##0,##', 'amount')"/>
						</fo:block>
					</fo:table-cell> 
		</fo:table-row>



		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Damen
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg1, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>


			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
							<number>
								<xsl:choose>
										<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg1)) != 'NaN'">
											<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/neukunden_cg1"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="0"/>
										</xsl:otherwise>
									</xsl:choose>
									
							</number> 
						</xsl:for-each>
					</xsl:variable>
								
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/neukunden_cg1, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Herren
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg2, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<number>
									<xsl:choose>
										<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg2)) != 'NaN'">
											<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/neukunden_cg2"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="0"/>
										</xsl:otherwise>
									</xsl:choose>
									
							</number> 
						</xsl:for-each>
					</xsl:variable>
								
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/neukunden_cg2, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Kinder
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg3, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<number>
								<xsl:choose>
										<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/neukunden_cg3)) != 'NaN'">
											<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/neukunden_cg3"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="0"/>
										</xsl:otherwise>
									</xsl:choose>
									
							</number> 
						</xsl:for-each>
					</xsl:variable>
								
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/neukunden_cg3, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

		
	<!--	<xsl:call-template name="table-title-row">
			<xsl:with-param name="title" select="'Kunden'" />
			<xsl:with-param name="cntFrequenzes" select="count($frequences)"/>
		</xsl:call-template> -->
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="'Kunden'" />
						</fo:block>
					</fo:table-cell> 
				
				
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
							<fo:block>
								<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg1 + $customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg2 + $customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg3, '###.##0,##', 'amount')"/>
							</fo:block>
						</fo:table-cell> 

					</xsl:for-each>
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:variable name="avgD">
								<xsl:for-each select="$frequences">
									<xsl:variable name="freqLabel" select="label" />
										<number>
										<xsl:choose>
											<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg1 + $customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg2 + $customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg3)) != 'NaN'">
												<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg1 + $customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg2 + $customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg3"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
											
										</number> 
								</xsl:for-each>
							</xsl:variable>
								
							<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
					
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="format-number($customerVisitData/bestandskunden_cg1 + $customerVisitData/bestandskunden_cg2 + $customerVisitData/bestandskunden_cg1, '###.##0,##', 'amount')" />
						</fo:block>
					</fo:table-cell> 
		</fo:table-row>
		
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Damen
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg1, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
								<number>
									<xsl:choose>
										<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg1)) != 'NaN'">
											<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg1"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="0"/>
										</xsl:otherwise>
									</xsl:choose>
									
								</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/bestandskunden_cg1, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Herren
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg2, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
								<number>
									<xsl:choose>
												<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg2)) != 'NaN'">
													<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg2"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="0"/>
												</xsl:otherwise>
											</xsl:choose>
								</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/bestandskunden_cg2, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Kinder
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg3, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
								<number>
									<xsl:choose>
												<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg3)) != 'NaN'">
													<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/bestandskunden_cg3"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="0"/>
												</xsl:otherwise>
											</xsl:choose>
								
								</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
					
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/bestandskunden_cg3, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	</xsl:template>

	<xsl:template name="table-visits">
		<xsl:param name="customerVisitData" />
		<xsl:param name="customerVisitDataFreq" />
		<xsl:param name="frequences" />
		



		<xsl:variable name="cntFrequences" select="count($frequences)"/>
		
		
		<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="'Besuche'" />
						</fo:block>
					</fo:table-cell> 
	
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
							<fo:block>
								<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/amount_customer, '###.##0,##', 'amount')"/>
							</fo:block>
						</fo:table-cell> 

					</xsl:for-each>
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:variable name="avgD">
								<xsl:for-each select="$frequences">
									<xsl:variable name="freqLabel" select="label" />
										<number>
											<xsl:choose>
												<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/amount_customer)) != 'NaN'">
													<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/amount_customer"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="0"/>
												</xsl:otherwise>
											</xsl:choose>
						
										</number> 
								</xsl:for-each>
							</xsl:variable>
						
							<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
				
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="format-number($customerVisitData/amount_customer, '###.##0,##', 'amount')"/>
						</fo:block>
					</fo:table-cell> 
		</fo:table-row>



		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Damen
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/r_amount_group1, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>


			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
								<number>
									<xsl:choose>
											<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/r_amount_group1)) != 'NaN'">
												<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/r_amount_group1"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
									
								</number> 
						</xsl:for-each>
					</xsl:variable>
				
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/r_amount_group1, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Herren
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/r_amount_group2, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
								<number>
									<xsl:choose>
											<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/r_amount_group2)) != 'NaN'">
												<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/r_amount_group2"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
									
								</number> 
						</xsl:for-each>
					</xsl:variable>
				
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/r_amount_group2, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Kinder
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="format-number($customerVisitDataFreq[label=$freqLabel]/r_amount_group3, '###.##0,##', 'amount')"/>
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
								<number>
									<xsl:choose>
											<xsl:when test="string(number($customerVisitDataFreq[label=$freqLabel]/r_amount_group3)) != 'NaN'">
												<xsl:value-of select="$customerVisitDataFreq[label=$freqLabel]/r_amount_group3"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
								</number> 
						</xsl:for-each>
					</xsl:variable>
				
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'amount')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="format-number($customerVisitData/r_amount_group3, '###.##0,##', 'amount')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>


	</xsl:template>	



	<xsl:template name="table-title-row">
		<xsl:param name="title" />
		<xsl:param name="cntFrequenzes" />
		<xsl:variable name="numRowsSpan" select="(2*$cntFrequenzes) + 5"/>
		<fo:table-row> 
					<fo:table-cell number-columns-spanned="{$numRowsSpan}" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="$title" />
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>

	</xsl:template>


	<xsl:template name="table-sub-title-row">
		<xsl:param name="title" />
		<xsl:param name="cntFrequenzes" />
		<xsl:variable name="numRowsSpan" select="(2*$cntFrequenzes) + 5"/>
		<fo:table-row> 
			<fo:table-cell number-columns-spanned="{$numRowsSpan}" xsl:use-attribute-sets="report-cell-sub-topic"> 
				<fo:block>
					<xsl:value-of select="$title" />
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	</xsl:template>


	<xsl:template name="table-structure-dl">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryReportGroupList" />
		<xsl:param name="reportGroupData" />
		<xsl:param name="reportGroupDataFreq" />
		<xsl:param name="frequences" />

		<xsl:variable name="cntFrequences" select="count($frequences)"/>
		
		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />
				
				
				
				<xsl:call-template name="table-sub-title-row">
					<xsl:with-param name="title" select="item_report_category_nm" />
					<xsl:with-param name="cntFrequenzes" select="$cntFrequences"/>
				</xsl:call-template>
				


			
			<xsl:for-each select="$categoryReportGroupList[item_report_category_cd=$itemReportCategoryCd]">
	
				<xsl:variable name="itemReportGroupCd" select="item_report_group_cd" />
				
					<fo:table-row> 

						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="item_report_group_nm" />
							</fo:block>
						</fo:table-cell> 

						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block>
									<xsl:value-of select="format-number( $reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl , '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 

						</xsl:for-each>


						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
											<number>
											<xsl:choose>
												<xsl:when test="string(number($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl)) != 'NaN'">
													<xsl:value-of select="$reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="0"/>
												</xsl:otherwise>
											</xsl:choose>
												
											</number> 
									</xsl:for-each>
								</xsl:variable>
							
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
				
							</fo:block>
						</fo:table-cell> 
						
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block>
									<xsl:value-of select="format-number(    $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl , '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 
					</fo:table-row>
				
				</xsl:for-each>
				

				<fo:table-row> 

						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="'Gesamt'" />
							</fo:block>
						</fo:table-cell> 

						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block  font-weight="bold">
									<xsl:value-of select="format-number(sum( $reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/cnt_dl ), '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 

						</xsl:for-each>


						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block  font-weight="bold">
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
											<number>
												<xsl:value-of select="sum( $reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/cnt_dl)"/>
											</number> 
									</xsl:for-each>
								</xsl:variable>
							
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
				
							</fo:block>
						</fo:table-cell> 
						
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block  font-weight="bold">
									<xsl:value-of select="format-number(  sum( $reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl) , '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 
					</fo:table-row>
			
		</xsl:for-each>

    </xsl:template>   

	<xsl:template name="table-structure-withcustomergroups-dl">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryReportGroupList" />
		<xsl:param name="reportGroupData" />
		<xsl:param name="reportGroupDataFreq" />
		<xsl:param name="frequences" />

		<xsl:variable name="cntFrequences" select="count($frequences)"/>

		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />
		
			
			<xsl:if test="$reportGroupData[item_report_category_cd=$itemReportCategoryCd]">
				<fo:table-row> 
					<fo:table-cell xsl:use-attribute-sets="report-cell-sub-topic"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 

					<xsl:for-each select="$frequences">
						<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
							<fo:block>
								D
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
							<fo:block>
								H
							</fo:block>
						</fo:table-cell> 
					</xsl:for-each>

					<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
						<fo:block>
							D
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
						<fo:block>
							H
						</fo:block>
					</fo:table-cell> 

					<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
						<fo:block>
							D
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
						<fo:block>
							H
						</fo:block>
					</fo:table-cell> 

				</fo:table-row>

				<xsl:for-each select="$categoryReportGroupList[item_report_category_cd=$itemReportCategoryCd]">
					<xsl:variable name="itemReportGroupCd" select="item_report_group_cd" />
		
					<fo:table-row> 
						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="item_report_group_nm" />
							</fo:block>
						</fo:table-cell> 
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
							<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block>
									<xsl:value-of select="format-number( $reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1 , '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 
							<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block>
									<xsl:value-of select="format-number( $reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3 , '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 
						</xsl:for-each >
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
											<number>
												
												<xsl:choose>
												<xsl:when test="string(number($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1)) != 'NaN'">
													<xsl:value-of select="$reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="0"/>
												</xsl:otherwise>
											</xsl:choose>
												
											</number> 
									</xsl:for-each>
								</xsl:variable>
							
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
			
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
											<number>
												<xsl:choose>
													<xsl:when test="string(number($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3)) != 'NaN'">
														<xsl:value-of select="$reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="0"/>
													</xsl:otherwise>
												</xsl:choose>
									
											</number> 
									</xsl:for-each>
								</xsl:variable>
							
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
			
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number( $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1 , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number( $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3 , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 

					</fo:table-row>
				</xsl:for-each>
			
					<fo:table-row> 
						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block  font-weight="bold">
								<xsl:value-of select="'Gesamt'" />
							</fo:block>
						</fo:table-cell> 
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
							<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block  font-weight="bold">
									<xsl:value-of select="format-number( sum($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1) , '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 
							<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
								<fo:block  font-weight="bold">
									<xsl:value-of select="format-number( sum($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3 ), '#', 'amount')"/>
								</fo:block>
							</fo:table-cell> 
						</xsl:for-each >
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block  font-weight="bold">
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
											<number>
												<xsl:value-of select="sum($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1)"/>
											</number> 
									</xsl:for-each>
								</xsl:variable>
							
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
			
							
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block  font-weight="bold">
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
											<number>
												<xsl:value-of select=" sum($reportGroupDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3 )"/>
											</number> 
									</xsl:for-each>
								</xsl:variable>
							
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
			
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block  font-weight="bold">
								<xsl:value-of select="format-number( sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1 ), '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block  font-weight="bold">
								<xsl:value-of select="format-number( sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3) , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 

					</fo:table-row>

			</xsl:if>
		</xsl:for-each>

    </xsl:template>   


 	<xsl:template name="table-revenue">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryData" />
		<xsl:param name="categoryDataFreq" />
		<xsl:param name="frequences" />

		<xsl:variable name="cntFrequences" select="count($frequences)"/>
		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />			
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 
					
					<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
					
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
							
								<xsl:value-of select="format-number($categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/r_total_services , '###.##0,00', 'money')"/>
							</fo:block>
						</fo:table-cell> 
					</xsl:for-each>

					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
						
							<xsl:value-of select="format-number(round($categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services   div $cntFrequences) , '###.##0,##', 'money')"/>
						</fo:block>
					</fo:table-cell> 

					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
						
							<xsl:value-of select="format-number($categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services , '###.##0,00', 'money')"/>
						</fo:block>
					</fo:table-cell> 

				</fo:table-row>
		</xsl:for-each>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Verkauf
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
			<xsl:variable name="freqLabel" select="label" />
					
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
						
							<xsl:value-of select="format-number($categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products , '###.##0,00', 'money')"/>
						</fo:block>
					</fo:table-cell> 
				</xsl:for-each>

			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
				
					<xsl:value-of select="format-number(round($categoryData[item_report_category_cd='-']/r_total_products   div $cntFrequences), '###.##0,##', 'money')"/>
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
				
					<xsl:value-of select="format-number($categoryData[item_report_category_cd='-']/r_total_products , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 

		</fo:table-row>

	<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
			<xsl:variable name="freqLabel" select="label" />
					
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block  font-weight="bold">
						
							<xsl:value-of select="format-number(sum($categoryDataFreq[label=$freqLabel][item_report_category_cd !='-']/r_total_services) + $categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products, '###.##0,00', 'money')"/>
						</fo:block>
					</fo:table-cell> 
				</xsl:for-each>

			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
				
					<xsl:value-of select="format-number(round((sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products)   div $cntFrequences) , '###.##0,##', 'money')"/>
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
				
					<xsl:value-of select="format-number(sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

    </xsl:template>    	

 	<xsl:template name="table-revenue-per-value">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryData" />
		<xsl:param name="value" />
		<xsl:param name="categoryDataFreq" />
		<xsl:param name="valuesFreq" />
		<xsl:param name="frequences" />
		
		<xsl:variable name="cntFrequences" select="count($frequences)"/>

		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />			
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="divValue">							
										<xsl:call-template name="tgDivision">
											<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/r_total_services "/>
											<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/cnt_working_days"/>
											<xsl:with-param name="negativCorrection" select="-1"/>
											
										</xsl:call-template>	
									</xsl:variable>	

									<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
								
							</fo:block>
						</fo:table-cell> 
					</xsl:for-each>

					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								<xsl:variable name="avgD">
									<xsl:for-each select="$frequences">
										<xsl:variable name="freqLabel" select="label" />
										<xsl:variable name="divValue">							
											<xsl:call-template name="tgDivision">
												<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/r_total_services "/>
												<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/cnt_working_days"/>
												<xsl:with-param name="negativCorrection" select="-1"/>
												
											</xsl:call-template>	
										</xsl:variable>	
										<number>
											<xsl:choose>
												<xsl:when test="string(number($divValue)) != 'NaN'">
													<xsl:value-of select="$divValue"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="0"/>
												</xsl:otherwise>
											</xsl:choose>
											
										</number> 
									</xsl:for-each>
								</xsl:variable>
								
								<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
		
							
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services "/>
										<xsl:with-param name="divisor" select="$value"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
							
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
		</xsl:for-each>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Verkauf
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
									<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/cnt_working_days"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
									
								</xsl:call-template>	
							</xsl:variable>	

							<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
						
					</fo:block>
				</fo:table-cell> 
			</xsl:for-each>


			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>

					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
									<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/cnt_working_days"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
									
								</xsl:call-template>	
							</xsl:variable>	
							<number>
								<xsl:choose>
									<xsl:when test="string(number($divValue)) != 'NaN'">
										<xsl:value-of select="$divValue"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="0"/>
									</xsl:otherwise>
								</xsl:choose>
							</number> 
						</xsl:for-each>
					</xsl:variable>
				
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
		
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
		
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 


			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block  font-weight="bold">
						<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="sum($categoryDataFreq[label=$freqLabel][item_report_category_cd !='-']/r_total_services) + $categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
									<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/cnt_working_days"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
									
								</xsl:call-template>	
							</xsl:variable>	

							<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
						
					</fo:block>
				</fo:table-cell> 
			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">

					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="sum($categoryDataFreq[label=$freqLabel][item_report_category_cd !='-']/r_total_services) + $categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
									<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/cnt_working_days"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
									
								</xsl:call-template>	
							</xsl:variable>	
							<number>
							<xsl:choose>
								<xsl:when test="string(number($divValue)) != 'NaN'">
									<xsl:value-of select="$divValue"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="0"/>
								</xsl:otherwise>
							</xsl:choose>
							</number> 
						</xsl:for-each>
					</xsl:variable>
				
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
		
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

    </xsl:template>    

 	<xsl:template name="table-work-days">
		<xsl:param name="workdays" />
		<xsl:param name="workdaysFreq" />
		<xsl:param name="frequences" />
		   <xsl:variable name="cntFrequences" select="count($frequences)"/>
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell-bold"> 
						<fo:block>
							Arbeitstage
						</fo:block>
					</fo:table-cell> 
				
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								
								<xsl:value-of select="format-number($workdaysFreq[label=$freqLabel]/cnt_working_days,'###.##0,##', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
					</xsl:for-each>
					
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="avgD">
								<xsl:for-each select="$frequences">
									<xsl:variable name="freqLabel" select="label" />
								
									<number>
										<xsl:choose>
											<xsl:when test="string(number($workdaysFreq[label=$freqLabel]/cnt_working_days)) != 'NaN'">
												<xsl:value-of select="$workdaysFreq[label=$freqLabel]/cnt_working_days"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
										
									</number> 
								</xsl:for-each>
							</xsl:variable>
				
							<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100),'###.##0,##', 'money')"/>
		
						</fo:block>
					</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="format-number($workdays,'###.##0,##', 'amount')"/>
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
	
    </xsl:template>    


 	<xsl:template name="table-revenue-per-customer">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryData" />
		<xsl:param name="value" />
		<xsl:param name="categoryDataFreq" />
		<xsl:param name="valuesFreq" />
		<xsl:param name="frequences"/>

  		<xsl:variable name="cntFrequences" select="count($frequences)"/>

		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />			
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 
					
					<xsl:for-each select="$frequences">
						<xsl:variable name="freqLabel" select="label" />
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/r_total_services"/>
									<xsl:with-param name="divisor" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/amount_customer"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	

							<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

							</fo:block>
						</fo:table-cell> 
					</xsl:for-each>
					
					
					
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							
							<xsl:variable name="avgD">
								<xsl:for-each select="$frequences">
									<xsl:variable name="freqLabel" select="label" />
									<xsl:variable name="divValue">							
										<xsl:call-template name="tgDivision">
											<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/r_total_services"/>
											<xsl:with-param name="divisor" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd=$itemReportCategoryCd]/amount_customer"/>
											<xsl:with-param name="negativCorrection" select="-1"/>
										</xsl:call-template>	
									</xsl:variable>	
									<number>
										<xsl:choose>
											<xsl:when test="string(number($divValue)) != 'NaN'">
												<xsl:value-of select="$divValue"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="0"/>
											</xsl:otherwise>
										</xsl:choose>
									</number> 
								</xsl:for-each>
							</xsl:variable>
				
							<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100),'###.##0,##', 'money')"/>
								
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services"/>
									<xsl:with-param name="divisor" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/amount_customer"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	

							<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

							
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
		</xsl:for-each>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Verkauf
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/amount_customer"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					</fo:block>
				</fo:table-cell> 
			</xsl:for-each>
					


			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
									<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/amount_customer"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	
							<number>
								<xsl:choose>
									<xsl:when test="string(number($divValue)) != 'NaN'">
										<xsl:value-of select="$divValue"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="0"/>
									</xsl:otherwise>
								</xsl:choose>
							</number> 
						</xsl:for-each>
					</xsl:variable>
		
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100),'###.##0,##', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
					
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block  font-weight="bold">
						<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryDataFreq[label=$freqLabel][item_report_category_cd !='-']/r_total_services) + $categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/amount_customer"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					</fo:block>
				</fo:table-cell> 
			</xsl:for-each>




			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">

					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="sum($categoryDataFreq[label=$freqLabel][item_report_category_cd !='-']/r_total_services) + $categoryDataFreq[label=$freqLabel][item_report_category_cd='-']/r_total_products"/>
									<xsl:with-param name="divisor" select="$valuesFreq[label=$freqLabel]/amount_customer"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	
							<number>
								<xsl:choose>
									<xsl:when test="string(number($divValue)) != 'NaN'">
										<xsl:value-of select="$divValue"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="0"/>
									</xsl:otherwise>
								</xsl:choose>
							</number> 
						</xsl:for-each>
					</xsl:variable>
		
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

    </xsl:template>    


	<xsl:template name="table-treatment-factor">
		<xsl:param name="treatmentData" />
		<xsl:param name="treatmentDataFreq" />
		<xsl:param name="frequences"/>

			<xsl:variable name="cntFrequences" select="count($frequences)"/>		
			<fo:table-row> 
				<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						Damen
					</fo:block>
				</fo:table-cell> 
				<xsl:for-each select="$frequences">
					<xsl:variable name="freqLabel" select="label" />
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$treatmentDataFreq[label=$freqLabel]/r_cnt_dl_cg1"/>
										<xsl:with-param name="divisor" select="$treatmentDataFreq[label=$freqLabel]/r_amount_group1"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

						</fo:block>
					</fo:table-cell> 
				</xsl:for-each>

				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						
						<xsl:variable name="avgD">
							<xsl:for-each select="$frequences">
								<xsl:variable name="freqLabel" select="label" />
								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
											<xsl:with-param name="divident" select="$treatmentDataFreq[label=$freqLabel]/r_cnt_dl_cg1"/>
											<xsl:with-param name="divisor" select="$treatmentDataFreq[label=$freqLabel]/r_amount_group1"/>
											<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<number>
									<xsl:choose>
										<xsl:when test="string(number($divValue)) != 'NaN'">
											<xsl:value-of select="$divValue"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="0"/>
										</xsl:otherwise>
									</xsl:choose>
								</number> 
							</xsl:for-each>
						</xsl:variable>
		
						<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
				
					

						
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="divValue">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$treatmentData/r_cnt_dl_cg1"/>
								<xsl:with-param name="divisor" select="$treatmentData/r_amount_group1"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

						
					</fo:block>
				</fo:table-cell> 
			</fo:table-row>
	
			<fo:table-row> 
				<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						Herren
					</fo:block>
				</fo:table-cell> 
			
				<xsl:for-each select="$frequences">
					<xsl:variable name="freqLabel" select="label" />
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$treatmentDataFreq[label=$freqLabel]/r_cnt_dl_cg2"/>
										<xsl:with-param name="divisor" select="$treatmentDataFreq[label=$freqLabel]/r_amount_group2"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

						</fo:block>
					</fo:table-cell> 
				</xsl:for-each>

				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="avgD">
							<xsl:for-each select="$frequences">
								<xsl:variable name="freqLabel" select="label" />
								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
											<xsl:with-param name="divident" select="$treatmentDataFreq[label=$freqLabel]/r_cnt_dl_cg2"/>
											<xsl:with-param name="divisor" select="$treatmentDataFreq[label=$freqLabel]/r_amount_group2"/>
											<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<number>
									<xsl:choose>
										<xsl:when test="string(number($divValue)) != 'NaN'">
											<xsl:value-of select="$divValue"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="0"/>
										</xsl:otherwise>
									</xsl:choose>
								</number> 
							</xsl:for-each>
						</xsl:variable>
		
						<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences) div 100), '###.##0,##', 'money')"/>
				
						
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="divValue">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$treatmentData/r_cnt_dl_cg2"/>
								<xsl:with-param name="divisor" select="$treatmentData/r_amount_group2"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

						
					</fo:block>
				</fo:table-cell> 
			</fo:table-row>

    </xsl:template>    


	<xsl:template name="table-lma-ama">
		<xsl:param name="amaData" />
		<xsl:param name="lmaData" />
		<xsl:param name="amaDataFreq" />
		<xsl:param name="lmaDataFreq" />
		<xsl:param name="amaDataFreqWf" />
		<xsl:param name="lmaDataFreqWf" />
		<xsl:param name="frequences"/>

		<xsl:variable name="cntFrequences" select="count($frequences)"/>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						AMA
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						LMA
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>
			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					AMA
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					LMA
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					AMA
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					LMA
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Damen
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_group1"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 

				<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_group1"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>



			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_group1"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_group1"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_group1"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_group1"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 	
		</fo:table-row>
	
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Herren
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_group2"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 

				<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_group2"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>

			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_group2"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_group2"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
					<fo:table-cell text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_group2"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_group2"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Kinder
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_group3"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 

				<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_group3"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>

			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_group3"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_group3"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell>
		
				<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_group3"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_group3"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 


			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block  font-weight="bold">
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_customer"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 

				<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block  font-weight="bold">
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_customer"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					
					</fo:block>
				</fo:table-cell> 

			</xsl:for-each>

			<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$amaDataFreq[label=$freqLabel]/r_amount_customer"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$amaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 

			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$lmaDataFreq[label=$freqLabel]/r_amount_customer"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$lmaDataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell>

					<fo:table-cell  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_customer"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_customer"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	</xsl:template>  

	<xsl:template name="table-amaOrLma">
		<xsl:param name="typeTitle" />
		<xsl:param name="data" />
		<xsl:param name="dataFreq" />
		<xsl:param name="dataFreqWf" />
		<xsl:param name="frequences"/>

		<xsl:variable name="cntFrequences" select="count($frequences)"/>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell> 
			<xsl:for-each select="$frequences">
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:value-of select="$typeTitle" />
					</fo:block>
				</fo:table-cell> 


			</xsl:for-each>
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="$typeTitle" />
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:value-of select="$typeTitle" />
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Damen
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_group1"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell>
			</xsl:for-each>



			
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_group1"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$data/r_amount_group1"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			
		</fo:table-row>
	
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Herren
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_group2"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 
			</xsl:for-each>

			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_group2"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
		
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$data/r_amount_group2"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
		
		</fo:table-row>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Kinder
				</fo:block>
			</fo:table-cell> 

			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_group3"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 
			</xsl:for-each>

			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_group3"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
			
				</fo:block>
			</fo:table-cell> 
		
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$data/r_amount_group3"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 


			<xsl:for-each select="$frequences">
				<xsl:variable name="freqLabel" select="label" />
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block  font-weight="bold">
						<xsl:variable name="valuePerEmployee">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_customer"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:variable name="valuePerDay">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$valuePerEmployee"/>
								<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	
						<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell>
			</xsl:for-each>

			<fo:table-cell  number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="avgD">
						<xsl:for-each select="$frequences">
							<xsl:variable name="freqLabel" select="label" />
							
								<xsl:variable name="valuePerEmployee">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$dataFreq[label=$freqLabel]/r_amount_customer"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_employee_wf"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	
								<xsl:variable name="valuePerDay">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$valuePerEmployee"/>
										<xsl:with-param name="divisor" select="$dataFreq[label=$freqLabel]/r_cnt_dt"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
									</xsl:call-template>	
								</xsl:variable>	

							<number>
								<xsl:value-of select="$valuePerDay" />
							</number> 
						</xsl:for-each>
					</xsl:variable>
						
					<xsl:value-of select="format-number(round(100*(sum(exsl:node-set($avgD)/number) div $cntFrequences)) div 100, '###.##0,00', 'money')"/>
			
				</fo:block>
			</fo:table-cell> 
		
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block  font-weight="bold">
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$data/r_amount_customer"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_employee_wf"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$data/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
		
		</fo:table-row>

	</xsl:template>  

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="15mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="15mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			
				
			

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<xsl:variable name="filterRow">
						<xsl:choose>
							<xsl:when test="report/report-params/SALON_EMPLOYEE_VIEW_MODE ='employee' and report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
								ausführend - <xsl:value-of select="report/employeeNm/row/employee_nm" /> 
							</xsl:when>
							<xsl:when test="report/report-params/SALON_EMPLOYEE_VIEW_MODE ='employee' and report/report-params/EMPLOYEE_MODE= 'consultingEmployee'">
								beratend - <xsl:value-of select="report/employeeNm/row/employee_nm" /> 
							</xsl:when>
							<xsl:otherwise>
								Ansicht: Salon
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"BV Entwicklung"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRow" select="$filterRow" />
					</xsl:call-template>

				</fo:static-content>

				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="footer-text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="footer-text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="footer-text">
										<fo:block>
											BV Entwicklung <xsl:choose>
											<xsl:when test="report/report-params/SALON_EMPLOYEE_VIEW_MODE ='employee' and report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
												AMA - <xsl:value-of select="report/employeeNm/row/employee_nm" />  
											</xsl:when>
											<xsl:when test="report/report-params/SALON_EMPLOYEE_VIEW_MODE ='employee' and report/report-params/EMPLOYEE_MODE= 'consultingEmployee'">
												LMA - <xsl:value-of select="report/employeeNm/row/employee_nm" /> 
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="report/businessunits/row/bu_nm_2" /> 
											</xsl:otherwise>
										</xsl:choose>
                                       / <xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template> - <xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template> 
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="footer-text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">


					<fo:table table-layout="fixed" width="100%"  xsl:use-attribute-sets="report-table">
						<fo:table-column column-width="15%"></fo:table-column>
					
						<xsl:for-each select="/report/bv/frequences/row">
							<fo:table-column></fo:table-column>
							<fo:table-column></fo:table-column>
						</xsl:for-each>

						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
                        <fo:table-column ></fo:table-column>




						<fo:table-header>
						<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell-header"> 
                                    <fo:block>
                                    </fo:block>  
                                </fo:table-cell> 
                               
							   	<xsl:for-each select="/report/bv/frequences/row">
									<fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell-header" text-align="center"> 
										<fo:block>
										<xsl:value-of select="label" />
										</fo:block>  
									</fo:table-cell> 
									
								</xsl:for-each>
							   
							     <fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                      Durchschnitt
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block  font-weight="bold">
                                         Gesamt
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>




                            <fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell-header"> 
                                    <fo:block>
                                    </fo:block>  
                                </fo:table-cell> 
                               
							   	<xsl:for-each select="/report/bv/frequences/row">
									<fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell-header" text-align="center"> 
										<fo:block>
										Anzahl / Wert
										</fo:block>  
									</fo:table-cell> 
									
								</xsl:for-each>
							   
							     <fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                      Anzahl / Wert
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                         Anzahl / Wert
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>
						</fo:table-header>


						<fo:table-body>

                        
							

							<xsl:variable name="cntFrequenzes" select="count(/report/bv/frequences/row)"/>

							<xsl:call-template name="table-customer">
								<xsl:with-param name="customerVisitData" select="/report/bv/p1/customerVisits/row"/>
								<xsl:with-param name="customerVisitDataFreq" select="/report/bv/freqData/customerVisits/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>     
							 <xsl:call-template name="table-visits">
								<xsl:with-param name="customerVisitData" select="/report/bv/p1/globalData/row"/>
								<xsl:with-param name="customerVisitDataFreq" select="/report/bv/freqData/globalData/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>     
							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Arbeitstage'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>
			
			 				<xsl:call-template name="table-work-days">
								<xsl:with-param name="workdays" select="/report/bv/p1/globalData/row/cnt_working_days"/>
								<xsl:with-param name="workdaysFreq" select="/report/bv/freqData/globalData/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
							</xsl:call-template>
							
						
							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Dienstleistungsstruktur'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>  
							
							<xsl:call-template name="table-structure-dl">
								<xsl:with-param name="categoryList" select="/report/categorylist/row[use_customer_group=0]"/>
								<xsl:with-param name="categoryReportGroupList" select="/report/itemCategoryReportGrouplist/row"/>
								<xsl:with-param name="reportGroupData" select="/report/bv/p1/serviceStructure_dl/row"/>						
								<xsl:with-param name="reportGroupDataFreq" select="/report/bv/freqData/serviceStructure_dl/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>     
							
							<xsl:call-template name="table-structure-withcustomergroups-dl">
								<xsl:with-param name="categoryList" select="/report/categorylist/row[use_customer_group=1]"/>
								<xsl:with-param name="categoryReportGroupList" select="/report/itemCategoryReportGrouplist/row"/>
								<xsl:with-param name="reportGroupData" select="/report/bv/p1/serviceStructure_withcustomergroup_dl/row"/>
								<xsl:with-param name="reportGroupDataFreq" select="/report/bv/freqData/serviceStructure_withcustomergroup_dl/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>   

							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Umsatz'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>

							<xsl:call-template name="table-revenue">
								<xsl:with-param name="categoryList" select="/report/categorylist/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/p1/categoryData/row"/>
								<xsl:with-param name="categoryDataFreq" select="/report/bv/freqData/categoryData/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>    	

						
							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Leistungskennzahlen'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>

						
							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Auslastung pro MA pro Tag'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>
							
							<xsl:choose >
								<xsl:when test="/report/report-params/SALON_EMPLOYEE_VIEW_MODE ='employee' and  /report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
									<xsl:call-template name="table-amaOrLma">
										<xsl:with-param name="typeTitle" select="'AMA'" />
										<xsl:with-param name="data" select="/report/bv/p1/ama-data/row"/>
										<xsl:with-param name="dataFreq" select="/report/bv/freqData/ama-data/row"/>
										<xsl:with-param name="dataFreqWf" select="/report/bv/freqData/employeeWorkFactorAMA/row"/>
										<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
									</xsl:call-template>  
								</xsl:when>
								<xsl:when test="/report/report-params/SALON_EMPLOYEE_VIEW_MODE ='employee' and  /report/report-params/EMPLOYEE_MODE= 'consultingEmployee'">
									<xsl:call-template name="table-amaOrLma">
										<xsl:with-param name="typeTitle" select="'LMA'" />
										<xsl:with-param name="data" select="/report/bv/p1/lma-data/row"/>
										<xsl:with-param name="dataFreq" select="/report/bv/freqData/lma-data/row"/>
										<xsl:with-param name="dataFreqWf" select="/report/bv/freqData/employeeWorkFactorLMA/row"/>
										<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
									</xsl:call-template>  
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="table-lma-ama">
										<xsl:with-param name="amaData" select="/report/bv/p1/ama-data/row"/>
										<xsl:with-param name="lmaData" select="/report/bv/p1/lma-data/row"/>
										<xsl:with-param name="amaDataFreq" select="/report/bv/freqData/ama-data/row"/>
										<xsl:with-param name="lmaDataFreq" select="/report/bv/freqData/lma-data/row"/>
									
										<xsl:with-param name="amaDataFreqWf" select="/report/bv/freqData/employeeWorkFactorAMA/row"/>
										<xsl:with-param name="lmaDataFreqWf" select="/report/bv/freqData/employeeWorkFactorLMA/row"/>
										<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
									</xsl:call-template>    	

								</xsl:otherwise>
							</xsl:choose>
							

							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Behandlungsfaktor'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>
							<xsl:call-template name="table-treatment-factor">
									<xsl:with-param name="treatmentData" select="/report/bv/p1/globalData/row"/>
									<xsl:with-param name="treatmentDataFreq" select="/report/bv/freqData/globalData/row"/>
									<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
							</xsl:call-template>		


							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Umsatz pro Tag'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>
							<xsl:call-template name="table-revenue-per-value">
								<xsl:with-param name="categoryList" select="/report/categorylist/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/p1/categoryData/row"/>
								<xsl:with-param name="value" select="/report/bv/p1/globalData/row/cnt_working_days"/>
								<xsl:with-param name="categoryDataFreq" select="/report/bv/freqData/categoryData/row"/>
								<xsl:with-param name="valuesFreq" select="/report/bv/freqData/globalData/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>    	
	
							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Umsatz pro Besuch'" />
								<xsl:with-param name="cntFrequenzes" select="$cntFrequenzes"/>
							</xsl:call-template>
							<xsl:call-template name="table-revenue-per-customer">
								<xsl:with-param name="categoryList" select="/report/categorylist/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/p1/categoryData/row"/>
								<xsl:with-param name="value" select="/report/bv/p1/globalData/row/amount_customer"/>
								<xsl:with-param name="categoryDataFreq" select="/report/bv/freqData/categoryData/row"/>
								<xsl:with-param name="valuesFreq" select="/report/bv/freqData/globalData/row"/>
								<xsl:with-param name="frequences"  select="/report/bv/frequences/row"/>
         					</xsl:call-template>    	


			            </fo:table-body>

					</fo:table>
					<fo:table table-layout="fixed" width="100%"  xsl:use-attribute-sets="report-table" margin-top="10mm">
						<fo:table-column column-width="25%"></fo:table-column>
						<fo:table-column column-width="75%"></fo:table-column>
						
						

						<fo:table-body>

                          <fo:table-row> 
                               
                                 <fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell" font-weight="bold" text-align="left"> 
                                    <fo:block>
										Legende
                                    </fo:block>  
                                </fo:table-cell> 
                                
                            </fo:table-row>

                            <fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Auslastung pro MA pro Tag:
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                      Anzahl Kundenbesuche pro Tag / Anzahl MA
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Behandlungsfaktor: 
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                      Anzahl Damen (Herren) DL Gesamt / Anzahl Damenbesuche (Herren) Gesamt
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Umsatz pro Besuch: 
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                     Durchschnittlicher Umsatz je Kundengruppe bzw. durchschnittlicher Verkaufsumsatz je Besuch
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Strukturwert in %:
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                       Anzahl Behandlungsart / Anzahl Besuche je Kundengruppe; Eine Behandlungsart ist eine Gruppe von Dienstleistungen zB Farbe
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Dienstleistungsstruktur: 
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                    gibt die Anzahl der Dienstleistungen in einer DL Gruppe bzw. im Struktur das Verhältnis zu der Gesamtanzahl Besuche der jeweiligen Kundengruppe
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>
						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>