<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="30mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4" >
				<fo:static-content flow-name="header">

					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Bonjournal zum Filialbericht"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
					</xsl:call-template>

					<fo:table table-layout="auto" width="200mm" margin-top="3mm">
						<fo:table-column column-width="100mm"></fo:table-column>
						<fo:table-column column-width="100mm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:table table-layout="auto" width="100mm">
										<fo:table-column column-width="32mm"></fo:table-column>
										<fo:table-column column-width="3mm"></fo:table-column>
										<fo:table-column column-width="65mm"></fo:table-column>

										<fo:table-body>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														Journal für den
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:call-template name="formatdate">
															<xsl:with-param name="datestr"
																select="report/report-params/DATE" />
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														Erstellungsdatum
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:call-template name="formatdatetime">
															<xsl:with-param name="datetimestr"
																select="report/report-params/NOW" />
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								
								<fo:table-cell>
									<fo:table table-layout="auto" width="100mm">
										<fo:table-column column-width="32mm"></fo:table-column>
										<fo:table-column column-width="3mm"></fo:table-column>
										<fo:table-column column-width="65mm"></fo:table-column>

										<fo:table-body>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														Erster Bon
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:value-of select="report/firstNote/row/sales_inv_cd" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														Letzter Bon
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:value-of select="report/lastNote/row/sales_inv_cd" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														Anzahl Belege
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="minicell">
													<fo:block>
														<xsl:value-of select="report/notes/row/r_revenue" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>

					</fo:table>


				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Bonjournal zum Filialbericht
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>

					

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Bonjournal</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="15mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>

											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="10mm"></fo:table-column>

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Belegart</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlart</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/all_si/row">

													<xsl:variable name="salesInvId" select="sales_inv_id/text()" />
													<xsl:variable name="employeeNm">
														<xsl:for-each
															select="/report/all_si_payments/row[sales_inv_id=$salesInvId]/employee_nm">
															
																<xsl:value-of
																	select="concat(substring(', ', 1 div (position()!=1)), .)" />
															
														</xsl:for-each>
													</xsl:variable>

													<xsl:variable name="drawerNm">
														<xsl:for-each
															select="/report/all_si_payments/row[sales_inv_id=$salesInvId]/drawer_nm">

															<xsl:value-of
																select="concat(substring(', ', 1 div (position()!=1)), .)" />
														</xsl:for-each>
													</xsl:variable>

													<xsl:variable name="paymentTypes">
														<xsl:for-each
															select="/report/all_si_payments/row[sales_inv_id=$salesInvId]/payment_type_nm">
															<xsl:value-of
																select="concat(substring(', ', 1 div (position()!=1)), .)" />
														</xsl:for-each>
													</xsl:variable>

													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:if test="sales_inv_type=1">
																	Rechnung
																</xsl:if>
																<xsl:if test="sales_inv_type=2">
																	Gutschrift
																</xsl:if>
															</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="$drawerNm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="$employeeNm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="minicell">
															<fo:block>

																<xsl:call-template name="formattime">
																	<xsl:with-param name="timestr" select="sales_inv_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(total_gross_price, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="$paymentTypes" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="5" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/all_si/row/total_gross_price), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Legende</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="50mm"></fo:table-column>


											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlart</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlartname</fo:block>
													</fo:table-cell>

												</fo:table-row>
											</fo:table-header>
											<fo:table-body>

												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															1
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Bar
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															2
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Gutschein
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															4
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															EC
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															5
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Kreditkarte
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															6
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Nachlass
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															7
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Gutschrift
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															8
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Überweisung
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															9
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Auslagen
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															10
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Punktenachlass
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															11
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															generierter Gutschein
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															12
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Treuegutschein/Punkte
														</fo:block>
													</fo:table-cell>



												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															13
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Gutscheinkarten
														</fo:block>
													</fo:table-cell>



												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															14
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															OnlineZahlung
														</fo:block>
													</fo:table-cell>



												</fo:table-row>

											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>