<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="barcode date exsl">
    <xsl:import href="Header.xsl"/>
<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />
	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">

    <xsl:call-template name="header">
        <xsl:with-param name="title" select='"Kunden, DL/Produkt-Umsätze"' />
        <xsl:with-param name="businessunit" select="report/businessunits/row" />
        <xsl:with-param name="period1" select="report/report-params/DATE" />
        <xsl:with-param name="period2" select="report/report-params/TODATE" />
    </xsl:call-template>

				
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left" font-size="8pt">
						<fo:table>	
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="60%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						
						<fo:table-body>
						  <fo:table-row>
						    <fo:table-cell text-align="left" xsl:use-attribute-sets="text-style">
						    	<fo:block>
						    		Erstellt:
									<xsl:call-template name="formatdate">
							             <xsl:with-param name="datestr" select="report/report-params/NOW"/>
							        </xsl:call-template>
							   	</fo:block>
						    </fo:table-cell>
						    <fo:table-cell text-align="center" xsl:use-attribute-sets="text-style">
						    	<fo:block>
						    		Kunden, DL/Produkt-Umsätze  
						    		<xsl:call-template name="formatdate">
							             <xsl:with-param name="datestr" select="report/report-params/DATE"/>
							        </xsl:call-template>
									 - 
									<xsl:call-template name="formatdate">
							             <xsl:with-param name="datestr" select="report/report-params/TODATE"/>
							        </xsl:call-template> 
							        &#160;&#160;&#160;
							        <xsl:value-of select="report/businessunits/row/businessunit_nm" />, 
									<xsl:value-of select="report/businessunits/row/bu_city" />
						    	</fo:block>
						    </fo:table-cell>
						    <fo:table-cell text-align="right" xsl:use-attribute-sets="text-style">
						   		<fo:block>
							     	Seite
									<fo:page-number />
									von
									<fo:page-number-citation ref-id="LastPage" />
								</fo:block>
						    </fo:table-cell>
						  </fo:table-row>
						</fo:table-body>
						
						</fo:table>	
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
						<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>


					<fo:table table-layout="fixed" border-collapse="collapse" 
						 width="100%">
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold-left">
									<fo:block>Datum</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Stunden</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Damen</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Herren</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Kinder</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Kunden</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz D</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz H</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz K</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz DL</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Produkte</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt</fo:block>
								</fo:table-cell>
								
							</fo:table-row>
							
								<fo:table-row>

									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											13.06.2017
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(10, '###.##0,0', 'amount')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											23
										</fo:block>
									</fo:table-cell>
										<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											18
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											9
											
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											50
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(925.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(725.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(109.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(1759.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(759.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number(2518.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
								</fo:table-row>

							
							<fo:table-row >

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>Summe</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>					
										<xsl:value-of select="format-number(10, '###.##0,0', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										23
									</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										18
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										9
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										50
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="format-number(925.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(725.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(109.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(1759.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(759.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(2518.0, '###.##0,00', 'money')" /><!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
							</fo:table-row>
							
						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>