<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">

				<xsl:call-template name="header">
					<xsl:with-param name="title" select='"Eingelöste Gutschriften"' />
					<xsl:with-param name="businessunit" select="report/businessunits/row" />
				</xsl:call-template>

				
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Eingelöste Gutschriften
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					
					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm"></fo:table-column>
						<fo:table-column column-width="3mm"></fo:table-column>
						<fo:table-column column-width="65mm"></fo:table-column>
						
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzung
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/cash_start/row/pos_session_cd" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Schublade
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/drawers/row/drawer_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzungsstart
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr" select="report/cash_start/row/session_start_ts" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzungsende
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr" select="report/cash_end/row/session_end_ts" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Erstellungsdatum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr" select="report/report-params/NOW" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="3"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="30mm"></fo:table-column>
						<fo:table-column column-width="30mm"></fo:table-column>
						<fo:table-column column-width="10mm"></fo:table-column>
						<fo:table-column column-width="25mm"></fo:table-column>
						<fo:table-column column-width="20mm"></fo:table-column>
						<fo:table-column column-width="20mm"></fo:table-column>
						<fo:table-column column-width="15mm"></fo:table-column>
						<fo:table-column column-width="20mm"></fo:table-column>
						
						<fo:table-header>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Kunden</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Zeit</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Rechnungsnr.</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Zahlart</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Betrag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Retour</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title2">
									<fo:block>Gesamt</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-header>
						<fo:table-body>
							<!-- <xsl:for-each select="report/row"> -->

								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											Jasmin Abel
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											20 Chris Coenen/21 Ramona Sommer
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											14:34
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											I-PCW1-2
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											&#160;
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											&#160;
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											&#160;
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="minicell">
										<fo:block>
											<xsl:value-of
											select="format-number('70.10', '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								
								<!-- <xsl:for-each select="report/row"> -->
									<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												Bar
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('20', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('0', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												EC
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('60', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												Bar
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('0', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('9.90', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												Bar (storno)
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('-0', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('9.90', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												EC (storno)
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('-60', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												Bar
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('60', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												<xsl:value-of
													select="format-number('9.90', '###.##0,00', 'money')" />
												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="minicell">
											<fo:block>
												&#160;
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								<!-- </xsl:for-each> -->
							<!-- </xsl:for-each> -->
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="7" xsl:use-attribute-sets="minicell-bold">
									<fo:block>SUMME</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="minicell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number('1299.15', '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
									

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>