<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="barcode date exsl">

<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.1mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.1mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="footer-text">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>

	</xsl:attribute-set>
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>


<xsl:template name="tokenize">
	<xsl:param name="input"/>
	<xsl:param name="length" select="26"/>
	<token><text><xsl:value-of select="substring($input,1,$length)"/></text></token>
	<xsl:if test="substring($input,$length+1)">
	<xsl:call-template name="tokenize">
	<xsl:with-param name="input" select="substring($input,$length+1)"/>
	</xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template name="treatmentAppNonWidthSpaces2">
		<xsl:param name="treatmentTxt" />
		
		<xsl:choose>
		 <xsl:when test="string-length($treatmentTxt) > 1">
				<xsl:variable name="appendString">
					<xsl:call-template name="treatmentAppNonWidthSpaces">
						<xsl:with-param name="treatmentTxt" select="substring($treatmentTxt,2,string-length($treatmentTxt))" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($treatmentTxt,1,1), '&#x200B;' , $appendString)"></xsl:value-of> 
			
		 </xsl:when>
		
		 <xsl:otherwise>
		 	<xsl:value-of select="$treatmentTxt"></xsl:value-of>
		 </xsl:otherwise>
		</xsl:choose>
		
	
	
		<!-- hänge zwischen jedes Zeichen ein  zero-width space Zeichen, damit ein Umbruch von langen Strings möglich wird -->
		<!--<xsl:value-of select="concat(substring($treatmentTxt,1,1), $appendString)"></xsl:value-of>-->

		<!--<xsl:value-of select="concat(substring($treatmentTxt,1,1), '&#x200B;' , $appendString)"></xsl:value-of> -->
		

		
		
	</xsl:template>
	
	<xsl:template name="treatmentAppNonWidthSpaces">
		<xsl:param name="treatmentTxt" />
		<xsl:variable name="appendString">
		<xsl:choose>
		 <xsl:when test="string-length($treatmentTxt) > 1">
			<xsl:choose>
				<xsl:when test="contains($treatmentTxt, '&#xA;')">
						<xsl:variable name="firstPart">
							<xsl:call-template name="treatmentAppNonWidthSpaces2">
								<xsl:with-param name="treatmentTxt" select="substring-before($treatmentTxt,'&#xA;')" />
							</xsl:call-template> 
							
							<!--<xsl:value-of select="concat(substring-before($treatmentTxt,'&#xA;'), 'GGG')"></xsl:value-of>-->
							
						</xsl:variable>
						<xsl:variable name="pos">
								<xsl:choose>
									<xsl:when test="string-length(substring-before($treatmentTxt,'&#xA;')) > 0">
										<xsl:value-of select="string-length(substring-before($treatmentTxt,'&#xA;'))+2"></xsl:value-of>
									</xsl:when>
									 <xsl:otherwise>
										<xsl:value-of select="2"></xsl:value-of>
									 </xsl:otherwise>
								</xsl:choose>
						</xsl:variable>
						<xsl:variable name="secondPart">
							<!--<xsl:value-of select="concat(substring($treatmentTxt,string-length(substring-before($treatmentTxt,'&#xA;'))+1,string-length($treatmentTxt)), 'CCC')"></xsl:value-of>-->
							<xsl:call-template name="treatmentAppNonWidthSpaces">
								<xsl:with-param name="treatmentTxt" select="substring($treatmentTxt,$pos,string-length($treatmentTxt))" />
							</xsl:call-template> 
						</xsl:variable>
						<xsl:value-of select="concat($firstPart,'&#xA;' ,$secondPart)"></xsl:value-of> 

					</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="treatmentAppNonWidthSpaces2">
					<xsl:with-param name="treatmentTxt" select="$treatmentTxt" />
				</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		 </xsl:when>
		
		 <xsl:otherwise>
		 	<xsl:value-of select="$treatmentTxt"></xsl:value-of>
		 </xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
	
	
		<!-- hänge zwischen jedes Zeichen ein  zero-width space Zeichen, damit ein Umbruch von langen Strings möglich wird -->
		<!--<xsl:value-of select="concat(substring($treatmentTxt,1,1), $appendString)"></xsl:value-of>-->

		<xsl:value-of select="$appendString"></xsl:value-of> 

		
		
	</xsl:template>
	





	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO" page-height="25cm" page-width="70mm" margin-top="3mm" margin-bottom="3mm" margin-left="5mm" margin-right="3mm" padding-bottom="3cm">
					<fo:region-body margin-top="18mm" margin-bottom="5mm" margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="18mm" />
					<fo:region-after region-name="footer" extent="50mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>


			<fo:page-sequence master-reference="THERMO">
				<fo:static-content flow-name="header">
					<fo:block text-align="center" xsl:use-attribute-sets="report-title">
						Behandlung
					</fo:block>
				<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_nm_2" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_street" />, 
						<xsl:value-of select="report/businessunits/row/bu_postal_cd" />&#160;
						<xsl:value-of select="report/businessunits/row/bu_city" />,
						<xsl:value-of select="report/businessunits/row/bu_country_cd" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/businessunit_nm" />, Kostenstelle <xsl:value-of select="report/businessunits/row/bu_nm_1" />
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="23mm"></fo:table-column>
						<fo:table-column column-width="2mm"></fo:table-column>
						<fo:table-column column-width="39mm"></fo:table-column>
						
						<fo:table-body>
						
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Name
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<xsl:variable name="cust_nm">
								        <xsl:choose>
								            <xsl:when test="report/contact/row/first_nm != ''"><xsl:value-of select="report/contact/row/first_nm" />&#160;<xsl:value-of select="report/contact/row/contact_nm" /></xsl:when>
								            <xsl:otherwise><xsl:value-of select="report/contact/row/contact_nm" /></xsl:otherwise>
								        </xsl:choose>
								    </xsl:variable>
									<fo:block>
										<xsl:value-of select="$cust_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Kundennummer
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/contact/row/contact_no" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							
							<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold">
									<fo:block  margin-top="5mm">
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr" select="/report/contactDataReport/data/treatment/treatmentTs" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-bold" number-columns-spanned="3">
									<fo:block  margin-top="5mm">
									
											<xsl:value-of select="/report/contactDataReport/data/treatment/treatmentBuNm" />
									
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block-container>
	
						<xsl:for-each select="/report/contactDataReport/data/treatment/treatmentGroups/treatmentGroup"> 

							<xsl:variable name="margin">
							    <xsl:choose>
							        <xsl:when test="position() mod 2 = 1">0mm</xsl:when>
							        <xsl:otherwise>5mm</xsl:otherwise>
							    </xsl:choose>
							</xsl:variable>

							<fo:block  text-decoration="underline" margin-top="{$margin}" xsl:use-attribute-sets="cell2" font-weight="bold">
								<xsl:value-of select="treatmentGroupName" />:
							</fo:block>
							<xsl:for-each select="treatmentGroupFields/field">

								<fo:table table-layout="fixed" width="100%">
								<fo:table-column column-width="30mm"></fo:table-column>
								<fo:table-column column-width="auto"></fo:table-column>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
												<fo:block xsl:use-attribute-sets="cell2" >
													<xsl:value-of select="fieldName" />:
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
												<fo:block xsl:use-attribute-sets="cell2"  wrap-option="wrap" linefeed-treatment="preserve" >
													<!-- <xsl:value-of select="fieldValue" /> -->
													
													<xsl:variable name="preparedTreatmentTxt">
														<xsl:call-template name="treatmentAppNonWidthSpaces">
															<xsl:with-param name="treatmentTxt" select="fieldValue" />
														</xsl:call-template>
													</xsl:variable>
													<xsl:value-of select="$preparedTreatmentTxt"></xsl:value-of>
																							
											<!-- 		
													<xsl:variable name="tokens">
															<xsl:call-template name="tokenize">
															<xsl:with-param name="input" select="fieldValue" />
															<xsl:with-param name="length" select="20" />
															
														</xsl:call-template>
													</xsl:variable>

													

													<xsl:for-each select="exsl:node-set($tokens)/token">
														<fo:block xsl:use-attribute-sets="cell2">
															<xsl:value-of select="text" />
														</fo:block>
													</xsl:for-each> -->
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>

							</xsl:for-each>
							<xsl:choose>
								<xsl:when test="treatmentGroupComment != ''">

									<fo:table table-layout="fixed" width="100%">
									<fo:table-column column-width="23mm"></fo:table-column>
									<fo:table-column column-width="auto"></fo:table-column>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
													<fo:block xsl:use-attribute-sets="cell2" >
														Bemerkung:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
													

													<xsl:variable name="tokens">
															<xsl:call-template name="tokenize">
															<xsl:with-param name="input" select="treatmentGroupComment" />
														</xsl:call-template>
													</xsl:variable>

													

													<xsl:for-each select="exsl:node-set($tokens)/token">
														<fo:block xsl:use-attribute-sets="cell2">
															<xsl:value-of select="text" />
														</fo:block>
													</xsl:for-each>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:when>
								<xsl:otherwise>
									&#160;
								</xsl:otherwise>
							</xsl:choose>
							
							<fo:block xsl:use-attribute-sets="cell2" margin-top="5mm" linefeed-treatment="treat-as-space">
								<xsl:value-of select="treatmentGroupEmployee" />
							</fo:block>
						</xsl:for-each>
						<fo:block xsl:use-attribute-sets="cell2" margin-top="40mm" visibility="hidden" border-bottom="1px solid #fcfcfc">
							&#160;
						</fo:block>
					</fo:block-container>

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>