<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:csv="csv:csv" extension-element-prefixes="barcode date exsl csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

<xsl:output method="text" encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
	    <column>customer_group_nm<desc>Kundengruppe</desc></column>
      	<column>contact_nm<desc>Nachname</desc></column>
      	<column>first_nm<desc>Vorname</desc></column>
	   	<column>services<desc>DLs</desc></column>
		<column>products<desc>Produkte</desc></column>
      	<column>email<desc>Mail</desc></column>
    
	  	<column>street<desc>Straße</desc></column>
      	<column>postal_cd<desc>PLZ</desc></column>
      	<column>city<desc>Stadt</desc></column>
		<column>phone<desc>Telefonnummer</desc></column>
		<column>mobile<desc>Mobilnummer</desc></column>
      	<column>birthday<desc>Geburtstag</desc></column>
		<column>comment<desc>Kommentar</desc></column>
      	<column>total_selection<desc>Umsatz Zeitraum</desc></column>
      	<column>gross_total<desc>Umsatz Gesamt</desc></column>
      	<column>first_visit<desc>Erster Besuch</desc></column>
      	<column>last_visit<desc>Letzter Besuch</desc></column>
      	
	</csv:columns>

	<xsl:template match="/" >

		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>



			<xsl:for-each select="report/customerList/data/row">
			<xsl:variable name="property" select="." />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
					<xsl:when test="starts-with($column,'total')"><xsl:value-of select="format-number($value, '###.##0,00', 'money')" /></xsl:when>
					<xsl:when test="starts-with($column,'gross')"><xsl:value-of select="format-number($value, '###.##0,00', 'money')" /></xsl:when>
					<xsl:when test="$column ='phone'">#<xsl:value-of select="$value" /></xsl:when>
					<xsl:when test="$column ='mobile'">#<xsl:value-of select="$value" /></xsl:when>  
					<xsl:when test="$column ='services'"><xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text></xsl:when>  
					<xsl:when test="$column ='products'"><xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text></xsl:when>  
					<xsl:when test="starts-with($column,'first_visit') and $value != ''">
					 <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="$value"/></xsl:call-template>
					 </xsl:when>
					 <xsl:when test="starts-with($column,'last_visit') and $value != ''">
					 <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="$value"/></xsl:call-template>
					 </xsl:when>
					 <xsl:when test="starts-with($column,'birthday') and $value != ''">
					 <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="$value"/></xsl:call-template>
					 </xsl:when>   
					
					<xsl:otherwise>
						<xsl:value-of select="$value" />
					</xsl:otherwise>
				</xsl:choose>

				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		</xsl:for-each>
	</xsl:template>


</xsl:stylesheet>
