<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
	extension-element-prefixes="barcode date exsl fox" xmlns:csv="csv:csv">


	<xsl:import href="Header.xsl"/>

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="right-cell-style">
	
		<xsl:attribute name="border-right-color">#000000</xsl:attribute>
		<xsl:attribute name="border-right-width">1px</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<csv:columns>
        <column>r_employee_no<desc>Mitarbeiter-Nr.</desc></column>
		<column>r_employee_nm<desc>Mitarbeiter</desc></column>
		
		<column>r_planed_week_working_hours<desc>Std. Woche</desc></column>
		<column>r_cnt_dt<desc>AT</desc></column>
		
		<column>r_total_g1_services<desc>Umsatz DL D</desc></column>
		<column>r_total_g1_products<desc>Umsatz VK D</desc></column>
		<column>r_amount_group1<desc>Anzahl Besuche D</desc></column>
	
		
		<column>r_total_g2_services<desc>Umsatz DL H</desc></column>
		<column>r_total_g2_products<desc>Umsatz VK H</desc></column>
		<column>r_amount_group2<desc>Anzahl Besuche H</desc></column>
	
		
		<column>r_total_g3_services<desc>Umsatz DL K</desc></column>	
		<column>r_total_g3_products<desc>Umsatz VK K</desc></column>
		<column>r_amount_group3<desc>Anzahl Besuche K</desc></column>
	
		
	
		<column>r_total_services<desc>Umsatz DL G</desc></column>
		<column>r_total_products<desc>Umsatz VK G</desc></column>
		<column>r_amount_customer<desc>Anzahl Besuche G</desc></column>
		<column>r_total<desc>Umsatz G</desc></column>
		
		<column>r_total_services_per_day<desc>Umsatz DL Pro Tag</desc></column>
		<column>r_total_product_per_day<desc>Umsatz VK Pro Tag</desc></column>
		<column>r_amount_customer_per_day<desc>Anzahl Besuche Pro Tag</desc></column>
		
		<column>r_total_services_per_customer<desc>Umsatz DL Pro Besuch</desc></column>
		<column>r_total_product_per_customer<desc>Umsatz VK Pro Besuch</desc></column>
		<column>r_total_per_customer<desc>Umsatz Pro Besuch</desc></column>
		
	
		
	</csv:columns>

	<xsl:template match="/">

		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="10mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="10mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">


					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Kurzübersicht (beratende MA)"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
					</xsl:call-template>

				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
								<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Kurzübersicht (beratende MA) &#160; 
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
										-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
									
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" border-collapse="collapse"
						width="100%" margin-top="0cm">
						
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>

						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>
						<fo:table-column column-width="4%"></fo:table-column>

						<fo:table-header>
							<fo:table-row>

								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="th1bold-left right-cell-style">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Damen</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Herren</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Kinder</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="4" xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Zusammenfassung</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Durchschnitt Pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro Besuch</fo:block>
								</fo:table-cell>

							</fo:table-row>
							<fo:table-row>

							
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Std. Woche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style">
									<fo:block>AT</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz DL</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz VK</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style">
									<fo:block>Besuche Anzahl</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz DL</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold ">
									<fo:block>Umsatz VK</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style">
									<fo:block>Besuche Anzahl</fo:block>
								</fo:table-cell>
							
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz DL</fo:block>
								</fo:table-cell>
									<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz VK</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Besuche Anzahl</fo:block>
								</fo:table-cell>
							


								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz DL</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz VK</fo:block>

								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Besuche Anzahl</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Gesamt Umsatz</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>DL</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>VK</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Kunden</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>DL</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>VK</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt</fo:block>
								</fo:table-cell>


							</fo:table-row>
						</fo:table-header>

						<fo:table-body>
							<xsl:for-each select="report/employeeRevenue/row">
							<xsl:variable name="grey_bg">
															<xsl:choose>
																<xsl:when test="position() mod 2 = 1">
																	#FFFFFF
																</xsl:when>
																<xsl:otherwise>
																	#CCCCCC
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
							
								<fo:table-row background-color="{$grey_bg}">
<xsl:variable name="property" select="." />
<xsl:variable name="employeeNo" select="$property/r_employee_no" />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
				
			<xsl:when test="$column='r_employee_no'">
			</xsl:when>
					<xsl:when test="$column='r_employee_nm'">
				<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="$value" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					   <xsl:when test="$column ='r_planed_week_working_hours'">
					   <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="$value" />
										</fo:block>
									</fo:table-cell>
					   </xsl:when>
					<xsl:when test="$column ='r_cnt_dt'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="$value" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group1'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group2'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group3'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<xsl:when test="$column ='r_total'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<xsl:when test="$column ='r_amount_customer_per_day'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:otherwise>
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
						
					</xsl:otherwise>
				</xsl:choose>


				
			</xsl:for-each>



								</fo:table-row>
							</xsl:for-each>

									<xsl:for-each select="report/sumEmployeeRevenue/row">
									<fo:table-row border="2px solid #000000" background-color="#aaaaaa">
			<xsl:variable name="property" select="." />
				<xsl:variable name="rowCnt" select="r_cnt_rows" />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
					
					<xsl:when test="$column ='r_employee_no'">
					
								</xsl:when>
				    <xsl:when test="$column ='r_employee_nm'">
				    <fo:table-cell text-align="left" number-columns-spanned="2"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Summen
										</fo:block>
									</fo:table-cell>
				    
				     </xsl:when>
				    <xsl:when test="$column ='r_planed_week_working_hours'"></xsl:when>
					<xsl:when test="$column ='r_cnt_dt'">
							<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="$value" />
										</fo:block>
									</fo:table-cell>
					 </xsl:when>
					
						<xsl:when test="$column ='r_amount_group1'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group2'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group3'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<xsl:when test="$column ='r_total'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<!--  Mittelwert -->
						<xsl:when test="$column ='r_amount_customer_per_day'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					
					
					
					
					<!--  Mittelwert -->
					<xsl:when test="$column ='r_total_services_per_day' or $column ='r_total_product_per_day' or $column ='r_total_services_per_customer' or $column ='r_total_product_per_customer' or $column ='r_total_per_customer' ">
					   
					   	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					    
					</xsl:when>
										
					<xsl:otherwise>
						<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
						
					</xsl:otherwise>
				</xsl:choose>

			</xsl:for-each>
				</fo:table-row>
		</xsl:for-each>
	

	<!-- empty row  -->
		<fo:table-row padding-bottom="1cm">		
		<fo:table-cell text-align="left" number-columns-spanned="22"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										&#160;
										</fo:block>
									</fo:table-cell>
		</fo:table-row>		

  <xsl:choose>
	        	<xsl:when test="report/sumPrevYearEmployeeRevenue/row">
					<xsl:for-each select="report/sumPrevYearEmployeeRevenue/row">
					<fo:table-row border="2px solid #000000">
					
					<xsl:variable name="property" select="." />
					<xsl:variable name="rowCnt" select="r_cnt_rows" />
			
					<!-- Loop through the columns in order -->
					<xsl:for-each select="document('')/*/csv:columns/*">
						<!-- Extract the column name and value -->
						<xsl:variable name="column" select="./text()" />
						<xsl:variable name="value" select="$property/*[name() = $column]" />
						<xsl:choose>
						<xsl:when test="$column ='r_employee_no'">
					
								</xsl:when>
				    <xsl:when test="$column ='r_employee_nm'">
				    <fo:table-cell text-align="left" number-columns-spanned="2"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Summen Vorjahr
										</fo:block>
									</fo:table-cell>
				    
				     </xsl:when>
				    <xsl:when test="$column ='r_planed_week_working_hours'"></xsl:when>
					<xsl:when test="$column ='r_cnt_dt'">	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="$value" />
										</fo:block>
									</fo:table-cell></xsl:when>
					
					<xsl:when test="$column ='r_amount_group1'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group2'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group3'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<xsl:when test="$column ='r_total'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<!--  Mittelwert -->
						<xsl:when test="$column ='r_amount_customer_per_day'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					
	
					
					
							<!--  Mittelwert -->
							<xsl:when test="$column ='r_total_services_per_day' or $column ='r_total_product_per_day'  or $column ='r_total_services_per_customer' or $column ='r_total_product_per_customer' or $column ='r_total_per_customer' ">
							   
							   	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
									<xsl:value-of select="format-number($value , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
							    
							</xsl:when>
							
							<xsl:otherwise>
								<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
								
							</xsl:otherwise>
						</xsl:choose>
		

				    	</xsl:for-each>
					
					
					</fo:table-row>				

					</xsl:for-each>	
			
				</xsl:when>	
				<xsl:otherwise>
				<fo:table-row border="2px solid #000000">				
				
					<xsl:for-each select="document('')/*/csv:columns/*">
							<!-- Extract the column name and value -->
							<xsl:variable name="column" select="./text()" />
							
							<xsl:choose>
													<xsl:when test="$column ='r_employee_no'">
					
								</xsl:when>
				    <xsl:when test="$column ='r_employee_nm'">
				    <fo:table-cell text-align="left" number-columns-spanned="2"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Summen Vorjahr
										</fo:block>
									</fo:table-cell>
				    
				     </xsl:when>
				    <xsl:when test="$column ='r_planed_week_working_hours'"></xsl:when>
					<xsl:when test="$column ='r_cnt_dt'">	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											0
										</fo:block>
									</fo:table-cell> </xsl:when>
				
									
									<xsl:when test="$column ='r_amount_group1'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
										<xsl:value-of select="format-number(0, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group2'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number(0, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					<xsl:when test="$column ='r_amount_group3'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number(0, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
						<xsl:when test="$column ='r_total'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
											<xsl:value-of select="format-number(0, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
			
						<xsl:when test="$column ='r_amount_customer_per_day'">
					
					<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
										<xsl:value-of select="format-number(0, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
					</xsl:when>
					
				
								
								<xsl:otherwise>
								<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										<xsl:value-of select="format-number(0, '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
								</xsl:otherwise>
							</xsl:choose>
							</xsl:for-each>
			</fo:table-row>				
				</xsl:otherwise>			
			</xsl:choose>



			<!-- Differenz -->
			<xsl:for-each select="report/sumEmployeeRevenue/row">
			<fo:table-row border="2px solid #000000">				
			
			<xsl:variable name="property" select="." />
			<xsl:variable name="rowCnt" select="r_cnt_rows" />
			<xsl:variable name="prevValues" select="/report/sumPrevYearEmployeeRevenue/row" />
			<xsl:variable name="rowCntPrevYear" select="/report/sumPrevYearEmployeeRevenue/row/r_cnt_rows" />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
	
					<xsl:when test="$column ='r_employee_no'">
					
								</xsl:when>
				    <xsl:when test="$column ='r_employee_nm'">
				    <fo:table-cell text-align="left" number-columns-spanned="2"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Summen Differenz
										</fo:block>
									</fo:table-cell>
				    
				     </xsl:when>
				    <xsl:when test="$column ='r_planed_week_working_hours'"></xsl:when>
					<xsl:when test="$column ='r_cnt_dt'">	
						<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0 right-cell-style">
										<fo:block>
										<xsl:value-of select="$value  - $prevValues/*[name() = $column]" />
										</fo:block>
									</fo:table-cell> 
					</xsl:when> 
		
		

							<xsl:when test="$column ='r_total' or $column ='r_amount_group3' or $column ='r_amount_group2' or $column ='r_amount_group1'">
					
			<xsl:choose >
						   <xsl:when test="$prevValues/*[name() = $column] != 0">
						     	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0 right-cell-style">
										<fo:block>
										<xsl:value-of select="format-number($value  - $prevValues/*[name() = $column] , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
						      
						   </xsl:when>
						   <xsl:otherwise>
						   <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0 right-cell-style">
										<fo:block>
										 <xsl:value-of select="format-number($value , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
						     
						   </xsl:otherwise>
						</xsl:choose>
					</xsl:when>
				<!--  Mittelwert -->
						<xsl:when test="$column ='r_amount_customer_per_day'">
					<xsl:choose >
					   <xsl:when test="$prevValues/*[name() = $column] != 0">
					     	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0 right-cell-style">
										<fo:block>
										 <xsl:value-of select="format-number(($value ) - ($prevValues/*[name() = $column]) , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
					     
					   </xsl:when>
					   <xsl:otherwise>
					   	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0 right-cell-style">
										<fo:block>
										 <xsl:value-of select="format-number($value , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
					     
					   </xsl:otherwise>
					</xsl:choose>
					</xsl:when>
					
					
					<!--  Mittelwert -->
					<xsl:when test="$column ='r_total_services_per_day' or $column ='r_total_product_per_day'  or $column ='r_total_services_per_customer' or $column ='r_total_product_per_customer' or $column ='r_total_per_customer' ">
					    <xsl:choose >
					   <xsl:when test="$prevValues/*[name() = $column] != 0">
					     	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 <xsl:value-of select="format-number(($value) - ($prevValues/*[name() = $column]) , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
					     
					   </xsl:when>
					   <xsl:otherwise>
					   	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 <xsl:value-of select="format-number($value  , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
					     
					   </xsl:otherwise>
					</xsl:choose>
					</xsl:when>
					
					
					<xsl:otherwise>
						<xsl:choose >
						   <xsl:when test="$prevValues/*[name() = $column] != 0">
						     	<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										<xsl:value-of select="format-number($value  - $prevValues/*[name() = $column] , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
									
						      
						   </xsl:when>
						   <xsl:otherwise>
						   <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 <xsl:value-of select="format-number($value , '###.##0,00', 'money')" />
										</fo:block>
									</fo:table-cell>
						     
						   </xsl:otherwise>
						</xsl:choose>
					 
					</xsl:otherwise>
				</xsl:choose>

			</xsl:for-each>
			</fo:table-row>				
			
		</xsl:for-each>
		
	
		
						<!-- % Abweichung -->
			<xsl:for-each select="report/sumEmployeeRevenue/row">
			<fo:table-row border="2px solid #000000">				
			
			<xsl:variable name="property" select="." />
			<xsl:variable name="prevValues" select="/report/sumPrevYearEmployeeRevenue/row" />
			<xsl:variable name="rowCnt" select="r_cnt_rows" />
			<xsl:variable name="rowCntPrevYear" select="/report/sumPrevYearEmployeeRevenue/row/r_cnt_rows" />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
					
					
					<xsl:when test="$column ='r_employee_no'">
					
								</xsl:when>
				    <xsl:when test="$column ='r_employee_nm'">
				    <fo:table-cell text-align="left" number-columns-spanned="2"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											Summen Differenz %
										</fo:block>
									</fo:table-cell>
				    
				     </xsl:when>
				    <xsl:when test="$column ='r_planed_week_working_hours'"></xsl:when>
				<!-- 	<xsl:when test="$column ='r_cnt_dt'"> </xsl:when> -->
		
					
					<xsl:otherwise>
						<xsl:choose>
							 <xsl:when test="$prevValues/*[name() = $column] != 0 ">
								<xsl:choose>
								
									<xsl:when test="$column ='r_cnt_dt' or $column ='r_total' or $column ='r_amount_group3' or $column ='r_amount_group2' or $column ='r_amount_customer_per_day' or $column ='r_amount_group1'">
										<fo:table-cell text-align="center"
															xsl:use-attribute-sets="cell-style0  right-cell-style">
															<fo:block>
															 <xsl:value-of select="format-number((($value div $prevValues/*[name() = $column]) - 1 ) * 100, '###.##0,00', 'money')" /> %
															</fo:block>
														</fo:table-cell>
									</xsl:when>
											<xsl:when test="$column ='r_amount_customer_per_day'">
					 		  			<!--  Mittelwert -->
					 		  			
					  				  <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0 right-cell-style">
										<fo:block>
										  <xsl:value-of select="format-number((((round($value *100) div 100 ) div (round($prevValues/*[name() = $column] *100) div 100  )) - 1 ) * 100 , '###.##0,00', 'money')" /> %
										</fo:block>
									</fo:table-cell>
					  				</xsl:when>
								
									<xsl:when test="$column ='r_total_services_per_day' or $column ='r_total_product_per_day' or $column ='r_total_services_per_customer' or $column ='r_total_product_per_customer' or $column ='r_total_per_customer' ">
					 		  			<!--  Mittelwert -->
					 		  			
					  				  <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										 <xsl:value-of select="format-number((((round($value *100) div 100 ) div (round($prevValues/*[name() = $column] *100) div 100  )) - 1 ) * 100 , '###.##0,00', 'money')" /> %
										</fo:block>
									</fo:table-cell>
					  				</xsl:when>
					   				<xsl:otherwise>
					   				 <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											 <xsl:value-of select="format-number((((round($value *100) div 100 ) div (round($prevValues/*[name() = $column] *100) div 100  )) - 1 ) * 100 , '###.##0,00', 'money')" /> %
										</fo:block>
									</fo:table-cell>
					      				
					   				</xsl:otherwise>
								</xsl:choose>
							 </xsl:when>
							 <xsl:when test="($prevValues/*[name() = $column] or $prevValues/*[name() = $column] = 0 ) ">
							 	<xsl:choose>
							 		<xsl:when test="$column ='r_total' or $column ='r_amount_group3' or $column ='r_amount_group2' or $column ='r_amount_customer_per_day' or $column ='r_amount_group1'">
							 	 <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
										-
										</fo:block>
									</fo:table-cell>
							 	</xsl:when>
							 	<xsl:otherwise>
							 	 <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										-
										</fo:block>
									</fo:table-cell>
							 	</xsl:otherwise>
							 	
							 	</xsl:choose>
							 	
							 	
							 </xsl:when>
	                         <xsl:otherwise>
						        <xsl:choose>
							 	<xsl:when test="$column ='r_total' or $column ='r_amount_group3' or $column ='r_amount_group2' or $column ='r_amount_customer_per_day' or $column ='r_amount_group1'">
							 	 <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0  right-cell-style">
										<fo:block>
										-
										</fo:block>
									</fo:table-cell>
							 	</xsl:when>
							 	<xsl:otherwise>
							 	 <fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
										-
										</fo:block>
									</fo:table-cell>
							 	</xsl:otherwise>
							 	
							 	</xsl:choose>
						     </xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
					
					
				</xsl:choose>
			
			</xsl:for-each>
			
         </fo:table-row>				

		</xsl:for-each>
	
						</fo:table-body>

					</fo:table>



					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>


	</xsl:template>



</xsl:stylesheet>