<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">
 	<xsl:import href="Header.xsl"/>
	<xsl:import href="PeriodenVergleich_UmsatzEntwicklung_BiggerThanQuartal.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />


	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="7mm" margin-right="7mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<xsl:variable name="employeeNm">
						Ansicht:		
						<xsl:choose>
							<xsl:when test="/report/report-params/SALON_EMPLOYEE_VIEW_MODE = 'salon'">
								Salon
							</xsl:when>
							<xsl:when test="/report/report-params/EMPLOYEE_MODE = 'operatingEmployee'">
								ausführende MA - <xsl:value-of select="/report/employee/row/employee_nm" />
							</xsl:when>
							<xsl:when test="/report/report-params/EMPLOYEE_MODE = 'consultingEmployee'">
								beratende MA - <xsl:value-of select="/report/employee/row/employee_nm" />
							</xsl:when>
							<xsl:otherwise>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					    <xsl:call-template name="header">
							<xsl:with-param name="title" select='"Periodenvergleich Entwicklung"' />
							<xsl:with-param name="businessunit" select="report/businessunits/row" />
							<xsl:with-param name="periods1" select="report/report-params/DATE" />
							<xsl:with-param name="periods2" select="report/report-params/TODATE" />
							<xsl:with-param name="periods3" select="report/report-params/DATE_COMPARE" />
							<xsl:with-param name="periods4" select="report/report-params/TODATE_COMPARE" />
							<xsl:with-param name="filterRow" select="$employeeNm" />
						</xsl:call-template>
										
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="65%"></fo:table-column>
							<fo:table-column column-width="15%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Periodenvergleich Entwicklung 
											<xsl:choose>
												<xsl:when test="/report/report-params/SALON_EMPLOYEE_VIEW_MODE = 'salon'">

												</xsl:when>
												<xsl:when test="/report/report-params/EMPLOYEE_MODE = 'operatingEmployee'">
													(ausführende MA)
												</xsl:when>
												<xsl:when test="/report/report-params/EMPLOYEE_MODE = 'consultingEmployee'">
													(beratende MA)
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>

											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr" select="report/report-params/DATE" />
											</xsl:call-template>
											-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr" select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">




					<xsl:choose>
						<xsl:when test="report/report-params/DATE_FREQUENCY != 'Quarter'">
							<xsl:call-template name="table">
								<!-- <xsl:with-param name="title" select='"Periodenvergleich Entwicklung"' />
								<xsl:with-param name="businessunit" select="report/businessunits/row" />
								<xsl:with-param name="periods1" select="report/report-params/DATE" />
								<xsl:with-param name="periods2" select="report/report-params/TODATE" />
								<xsl:with-param name="periods3" select="report/report-params/DATE_COMPARE" />
								<xsl:with-param name="periods4" select="report/report-params/TODATE_COMPARE" />
								<xsl:with-param name="filterRow" select="$employeeNm" /> -->
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="timeRows">
								<xsl:value-of select="count(exsl:node-set(report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod))" />
							</xsl:variable>
							<xsl:variable name="percentRowSummaryWidth">
								<xsl:value-of select="$timeRows * 0.9" />
							</xsl:variable>

							<xsl:variable name="collumnWidth">
								<xsl:value-of select="(29.7 - 3.6 - 1.4 - $percentRowSummaryWidth) div ($timeRows * 3)" />
							</xsl:variable>
							<fo:table table-layout="fixed" width="100%"  page-break-after="always">

						<!-- Hauptspalte -->
						<fo:table-column column-width="36mm"></fo:table-column>

						<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
							<!-- Datenspalten -->
							<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
							<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
							<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
							<!-- Prozentspalte -->
							<fo:table-column column-width="9mm" border-right="0.5mm solid black"></fo:table-column>
						</xsl:for-each>

						<fo:table-body>
							
							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
									</fo:block>
								</fo:table-cell>
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="center" font-weight="bold">
											<xsl:value-of select="$prev/label" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="center" font-weight="bold">
											<xsl:value-of select="label" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="center" font-weight="bold">
											Differenz
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="center" font-weight="bold">
											%
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz DL Dame
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g1_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_g1_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number((r_total_g1_services - $prev/r_total_g1_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g1_services != 0">
													<xsl:value-of select="format-number(((r_total_g1_services div $prev/r_total_g1_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>


								</xsl:for-each>

							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz DL Herr
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g2_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_g2_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number((r_total_g2_services - $prev/r_total_g2_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g2_services != 0">
													<xsl:value-of select="format-number(((r_total_g2_services div $prev/r_total_g2_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>


								</xsl:for-each>

							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz DL Kind
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g3_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_g3_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number((r_total_g3_services - $prev/r_total_g3_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g3_services != 0">
													<xsl:value-of select="format-number(((r_total_g3_services div $prev/r_total_g3_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>


								</xsl:for-each>

							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Umsatz DL
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number($prev/r_total_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number(r_total_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											
											<xsl:value-of select="format-number((r_total_services - $prev/r_total_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_services != 0">
													<xsl:value-of select="format-number(((r_total_services div $prev/r_total_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>


								</xsl:for-each>

							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Umsatz VK
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number($prev/r_total_products, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number(r_total_products, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											
											<xsl:value-of select="format-number((r_total_products - $prev/r_total_products), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_products != 0">
													<xsl:value-of select="format-number(((r_total_products div $prev/r_total_products) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>


								</xsl:for-each>

							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz Dame Gesamt
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_g1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_total_g1 - $prev/r_total_g1), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_total_g1 != 0">
													<xsl:value-of select="format-number(((r_total_g1 div $prev/r_total_g1) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz Herr Gesamt
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_g2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_total_g2 - $prev/r_total_g2), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_total_g2 != 0">
													<xsl:value-of select="format-number(((r_total_g2 div $prev/r_total_g2) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz Kind Gesamt
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_g3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_total_g3 - $prev/r_total_g3), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_total_g3 != 0">
													<xsl:value-of select="format-number(((r_total_g3 div $prev/r_total_g3) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Umsatz Gesamt
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number($prev/r_total, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number(r_total, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											
											<xsl:value-of select="format-number((r_total - $prev/r_total), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="$prev/r_total != 0">
													<xsl:value-of select="format-number(((r_total div $prev/r_total) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										VK Anteil am Umsatz
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_total != 0">
													<xsl:value-of select="format-number(($prev/r_total_products div $prev/r_total) * 100 ,'###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="r_total != 0 and $prev/r_total != 0">
													<xsl:value-of select="format-number((r_total_products div r_total) * 100, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:choose>
												<xsl:when test="r_total != 0 and $prev/r_total != 0">
													<xsl:value-of select="format-number((((r_total_products div r_total) * 100) - (($prev/r_total_products div $prev/r_total) * 100)), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_total = 0 and $prev/r_total != 0">
													<xsl:value-of select="format-number((0 - (($prev/r_total_products div $prev/r_total) * 100)), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_total != 0 and $prev/r_total = 0">
													<xsl:value-of select="format-number(((r_total_products div r_total) * 100), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="r_total != 0 and $prev/r_total != 0">
													<xsl:value-of select="format-number(((((r_total_products div r_total) * 100) div  (($prev/r_total_products div $prev/r_total) * 100)) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>

												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz pro Tag
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_per_day, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_total_per_day, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_total_per_day - $prev/r_total_per_day), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_total_per_day != 0">
													<xsl:value-of select="format-number(((r_total_per_day div $prev/r_total_per_day) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Anzahl Damen
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_amountGoup1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_amountGoup1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_amountGoup1 - $prev/r_amountGoup1), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_amountGoup1 != 0">
													<xsl:value-of select="format-number(((r_amountGoup1 div $prev/r_amountGoup1) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Anzahl Herren
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_amountGoup2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_amountGoup2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_amountGoup2 - $prev/r_amountGoup2), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_amountGoup2 != 0">
													<xsl:value-of select="format-number(((r_amountGoup2 div $prev/r_amountGoup2) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Anzahl Kinder
									</fo:block>
								</fo:table-cell>
								
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_amountGoup3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number(r_amountGoup3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number((r_amountGoup3 - $prev/r_amountGoup3), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_amountGoup3 != 0">
													<xsl:value-of select="format-number(((r_amountGoup3 div $prev/r_amountGoup3) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Anzahl Besuche
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number($prev/r_amountCustomer, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:value-of select="format-number(r_amountCustomer, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											
											<xsl:value-of select="format-number((r_amountCustomer - $prev/r_amountCustomer), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="$prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number(((r_amountCustomer div $prev/r_amountCustomer) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Besuche pro Tag
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="$prev/cntDay!=0">
													<xsl:value-of select="format-number($prev/r_amountCustomer div $prev/cntDay, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="cntDay!=0">
													<xsl:value-of select="format-number(r_amountCustomer div cntDay, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="cntDay != 0 and $prev/cntDay != 0">
													<xsl:value-of select="format-number((r_amountCustomer div cntDay) - ($prev/r_amountCustomer div $prev/cntDay), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="cntDay != 0 and $prev/cntDay = 0">
													<xsl:value-of select="format-number((r_amountCustomer div cntDay), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="cntDay = 0 and $prev/cntDay != 0">
													<xsl:value-of select="format-number(0 - ($prev/r_amountCustomer div $prev/cntDay), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="cntDay != 0 and $prev/cntDay != 0">
													<xsl:value-of select="format-number((((r_amountCustomer div cntDay) div ($prev/r_amountCustomer div $prev/cntDay)) -1 ) * 100, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>



							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Dame
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g1,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_services_per_g1,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_g1,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g1" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_g1 - $prev/r_services_per_g1,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g1" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number(((base div compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_services_per_g1 != 0">
															<xsl:value-of select="format-number(((r_services_per_g1 div $prev/r_services_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Herr
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g2,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_services_per_g2,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g2,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_g2,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g2" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_g2 - $prev/r_services_per_g2,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g2" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g2" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_services_per_g2 != 0">
															<xsl:value-of select="format-number(((r_services_per_g2 div $prev/r_services_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Kind
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g3,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_services_per_g3,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g3,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_g3,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g3" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g3" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_g3 - $prev/r_services_per_g3,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g3" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g3" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_services_per_g3 != 0">
															<xsl:value-of select="format-number(((r_services_per_g3 div $prev/r_services_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>




							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Ø DL Besuch
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_cus,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_services_per_cus,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_cus,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_cus,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_cus" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_cus" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_services_per_cus - $prev/r_services_per_cus,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_cus" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_cus" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_services_per_cus != 0">
															<xsl:value-of select="format-number(((r_services_per_cus div $prev/r_services_per_cus) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Anzahl DL Gesamt
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_count_services,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_count_services,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_count_services,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_count_services,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_count_services" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_count_services" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_count_services - $prev/r_count_services,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_count_services" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_count_services" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_count_services != 0">
															<xsl:value-of select="format-number(((r_count_services div $prev/r_count_services) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz Dame
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g1,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_total_per_g1,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g1,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_total_per_g1,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g1" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g1" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_total_per_g1 - $prev/r_total_per_g1,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g1" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g1" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_total_per_g1 != 0">
															<xsl:value-of select="format-number(((r_total_per_g1 div $prev/r_total_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz Herr
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g2,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_total_per_g2,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g2,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_total_per_g2,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g2" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g2" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_total_per_g2 - $prev/r_total_per_g2,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g2" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g2" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_total_per_g2 != 0">
															<xsl:value-of select="format-number(((r_total_per_g2 div $prev/r_total_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz Kind
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									<xsl:variable name="timeLabel">
										<xsl:value-of select="label" />
									</xsl:variable>
									<xsl:variable name="timeLabelPrev">
										<xsl:value-of select="$prev/label" />
									</xsl:variable>
									
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g3,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number($prev/r_total_per_g3,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g3,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_total_per_g3,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>	
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g3" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g3" />
													</xsl:variable>
													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="format-number(r_total_per_g3 - $prev/r_total_per_g3,'###.##0,##', 'money')" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">

											<xsl:choose>
												<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
													<xsl:variable name="base">
														<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g3" />
													</xsl:variable>
													<xsl:variable name="compare">
														<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g3" />
													</xsl:variable>

													<xsl:choose>
														<xsl:when test="$compare != 0">
															<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>

													<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
												</xsl:when>	
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$prev/r_total_per_g3 != 0">
															<xsl:value-of select="format-number(((r_total_per_g3 div $prev/r_total_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
														</xsl:when>
														<xsl:otherwise>
															-
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Ø Umsatz pro Besuch
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="$prev/r_amountCustomer!=0">
													<xsl:value-of select="format-number($prev/r_total div $prev/r_amountCustomer, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="r_amountCustomer!=0">
													<xsl:value-of select="format-number(r_total div r_amountCustomer, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number((r_total div r_amountCustomer) - ($prev/r_total div $prev/r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
													<xsl:value-of select="format-number((r_total div r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number(0 - ($prev/r_total div $prev/r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right"  font-weight="bold">
											<xsl:choose>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number((((r_total div r_amountCustomer) div ($prev/r_total div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Umsatz pro Besuch
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_amountCustomer!=0">
													<xsl:value-of select="format-number($prev/r_total_services div $prev/r_amountCustomer, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="r_amountCustomer!=0">
													<xsl:value-of select="format-number(r_total_services div r_amountCustomer, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" >
											<xsl:choose>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number((r_total_services div r_amountCustomer) - ($prev/r_total_services div $prev/r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
													<xsl:value-of select="format-number((r_total_services div r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number(0 - ($prev/r_total_services div $prev/r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number((((r_total_services div r_amountCustomer) div ($prev/r_total_services div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø VK Umsatz pro Besuch
									</fo:block>
								</fo:table-cell>
								<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
								<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
									<!-- Vergleichzeitraum -->
									<xsl:variable name="id">
										<xsl:value-of select="ident" />
									</xsl:variable>
									<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="$prev/r_amountCustomer!=0">
													<xsl:value-of select="format-number($prev/r_total_products div $prev/r_amountCustomer, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="r_amountCustomer!=0">
													<xsl:value-of select="format-number(r_total_products div r_amountCustomer, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" >
											<xsl:choose>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number((r_total_products div r_amountCustomer) - ($prev/r_total_products div $prev/r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
													<xsl:value-of select="format-number((r_total_products div r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:when test="r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number(0 - ($prev/r_total_products div $prev/r_amountCustomer), '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
												<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
													<xsl:value-of select="format-number((((r_total_products div r_amountCustomer) div ($prev/r_total_products div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>




							

						</fo:table-body>
					</fo:table>






					<!-- Gesamtabelle -->

					<fo:table table-layout="fixed" width="100%">

						<!-- Hauptspalte -->
						<fo:table-column column-width="36mm"></fo:table-column>

						<fo:table-column column-width="4cm"></fo:table-column>
						<fo:table-column column-width="4cm"></fo:table-column>
						<fo:table-column column-width="4cm"></fo:table-column>
						<fo:table-column column-width="4cm"></fo:table-column>

						<fo:table-body>
							
							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="center" font-weight="bold">
										Gesamt <xsl:value-of select="/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod/year" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="center" font-weight="bold">
										Gesamt  <xsl:value-of select="/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod/year" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="center" font-weight="bold">
										Differenz
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="center" font-weight="bold">
										%
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz DL Dame
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g1_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current/r_total_g1_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current/r_total_g1_services - $prev/r_total_g1_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g1_services != 0">
													<xsl:value-of select="format-number((($current/r_total_g1_services div $prev/r_total_g1_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz DL Herr
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g2_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current/r_total_g2_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current/r_total_g2_services - $prev/r_total_g2_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g2_services != 0">
													<xsl:value-of select="format-number((($current/r_total_g2_services div $prev/r_total_g2_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz DL Kind
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g3_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current/r_total_g3_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current/r_total_g3_services - $prev/r_total_g3_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g3_services != 0">
													<xsl:value-of select="format-number((($current/r_total_g3_services div $prev/r_total_g3_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block  font-weight="bold">
										Umsatz DL
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($prev/r_total_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($current/r_total_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											
											<xsl:value-of select="format-number(($current/r_total_services - $prev/r_total_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_services != 0">
													<xsl:value-of select="format-number((($current/r_total_services div $prev/r_total_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Umsatz VK
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($prev/r_total_products, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($current/r_total_products, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											
											<xsl:value-of select="format-number(($current/r_total_products - $prev/r_total_products), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_products != 0">
													<xsl:value-of select="format-number((($current/r_total_products div $prev/r_total_products) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz Dame Gesamt
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current/r_total_g1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current/r_total_g1 - $prev/r_total_g1), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g1 != 0">
													<xsl:value-of select="format-number((($current/r_total_g1 div $prev/r_total_g1) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz Herr Gesamt
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current/r_total_g2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current/r_total_g2 - $prev/r_total_g2), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g2 != 0">
													<xsl:value-of select="format-number((($current/r_total_g2 div $prev/r_total_g2) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Umsatz Kind Gesamt
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev/r_total_g3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current/r_total_g3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current/r_total_g3 - $prev/r_total_g3), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total_g3 != 0">
													<xsl:value-of select="format-number((($current/r_total_g3 div $prev/r_total_g3) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block  font-weight="bold">
										Umsatz Gesamt
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($prev/r_total, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($current/r_total, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											
											<xsl:value-of select="format-number(($current/r_total - $prev/r_total), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev/r_total != 0">
													<xsl:value-of select="format-number((($current/r_total div $prev/r_total) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										VK Anteil am Umsatz
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_total != 0">
												<xsl:value-of select="format-number(($prev/r_total_products div $prev/r_total) * 100 ,'###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_total">
												<xsl:value-of select="format-number(($current/r_total_products div $current/r_total) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										
										<xsl:choose>
											<xsl:when test="$current/r_total != 0 and $prev/r_total != 0">
												<xsl:value-of select="format-number(((($current/r_total_products div $current/r_total) * 100) - (($prev/r_total_products div $prev/r_total) * 100)), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_total = 0 and $prev/r_total != 0">
												<xsl:value-of select="format-number((0 - (($prev/r_total_products div $prev/r_total) * 100)), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_total != 0 and $prev/r_total = 0">
												<xsl:value-of select="format-number((($current/r_total_products div $current/r_total) * 100), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_total != 0 and $prev/r_total != 0">
												<xsl:value-of select="format-number((((($current/r_total_products div $current/r_total) * 100) div  (($prev/r_total_products div $prev/r_total) * 100)) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>

											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz pro Tag
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev/r_total_per_day, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current/r_total_per_day, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current/r_total_per_day - $prev/r_total_per_day), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_total_per_day != 0">
												<xsl:value-of select="format-number((($current/r_total_per_day div $prev/r_total_per_day) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Anzahl Damen
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev/r_amountGoup1, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current/r_amountGoup1, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current/r_amountGoup1 - $prev/r_amountGoup1), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_amountGoup1 != 0">
												<xsl:value-of select="format-number((($current/r_amountGoup1 div $prev/r_amountGoup1) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Anzahl Herren
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev/r_amountGoup2, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current/r_amountGoup2, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current/r_amountGoup2 - $prev/r_amountGoup2), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_amountGoup2 != 0">
												<xsl:value-of select="format-number((($current/r_amountGoup2 div $prev/r_amountGoup2) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Anzahl Kinder
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev/r_amountGoup3, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current/r_amountGoup3, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current/r_amountGoup3 - $prev/r_amountGoup3), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_amountGoup3 != 0">
												<xsl:value-of select="format-number((($current/r_amountGoup3 div $prev/r_amountGoup3) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Anzahl Besuche
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:value-of select="format-number($prev/r_amountCustomer, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:value-of select="format-number($current/r_amountCustomer, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										
										<xsl:value-of select="format-number(($current/r_amountCustomer - $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number((($current/r_amountCustomer div $prev/r_amountCustomer) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Besuche pro Tag
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$prev/cntDay!=0">
												<xsl:value-of select="format-number($prev/r_amountCustomer div $prev/cntDay, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current/cntDay!=0">
												<xsl:value-of select="format-number($current/r_amountCustomer div $current/cntDay, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current/cntDay != 0 and $prev/cntDay != 0">
												<xsl:value-of select="format-number(($current/r_amountCustomer div $current/cntDay) - ($prev/r_amountCustomer div $prev/cntDay), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/cntDay != 0 and $prev/cntDay = 0">
												<xsl:value-of select="format-number(($current/r_amountCustomer div $current/cntDay), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/cntDay = 0 and $prev/cntDay != 0">
												<xsl:value-of select="format-number(0 - ($prev/r_amountCustomer div $prev/cntDay), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current/cntDay != 0 and $prev/cntDay != 0">
												<xsl:value-of select="format-number(((($current/r_amountCustomer div $current/cntDay) div ($prev/r_amountCustomer div $prev/cntDay)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>



							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Dame
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_g1 - $prev/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_services_per_g1 != 0">
														<xsl:value-of select="format-number((($current/r_services_per_g1 div $prev/r_services_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Herr
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_g2 - $prev/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_services_per_g2 != 0">
														<xsl:value-of select="format-number((($current/r_services_per_g2 div $prev/r_services_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø DL Kind
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_g3 - $prev/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_services_per_g3 != 0">
														<xsl:value-of select="format-number((($current/r_services_per_g3 div $prev/r_services_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>





							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block  font-weight="bold">
										Ø DL Besuch
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_services_per_cus - $prev/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_services_per_cus != 0">
														<xsl:value-of select="format-number((($current/r_services_per_cus div $prev/r_services_per_cus) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Anzahl DL Gesamt
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_count_services,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_count_services,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_count_services,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_count_services,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_count_services" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_count_services" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_count_services - $prev/r_count_services,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_count_services" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_count_services" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_count_services != 0">
														<xsl:value-of select="format-number((($current/r_count_services div $prev/r_count_services) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz Dame
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_total_per_g1 - $prev/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_total_per_g1 != 0">
														<xsl:value-of select="format-number((($current/r_total_per_g1 div $prev/r_total_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz Herr
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_total_per_g2 - $prev/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_total_per_g2 != 0">
														<xsl:value-of select="format-number((($current/r_total_per_g2 div $prev/r_total_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz Kind
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current/r_total_per_g3 - $prev/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev/r_total_per_g3 != 0">
														<xsl:value-of select="format-number((($current/r_total_per_g3 div $prev/r_total_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block font-weight="bold">
										Ø Umsatz pro Besuch
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$prev/r_amountCustomer!=0">
												<xsl:value-of select="format-number($prev/r_total div $prev/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current/r_amountCustomer!=0">
												<xsl:value-of select="format-number($current/r_total div $current/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current/r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(($current/r_total div $current/r_amountCustomer) - ($prev/r_total div $prev/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
												<xsl:value-of select="format-number(($current/r_total div $current/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(0 - ($prev/r_total div $prev/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current/r_total != 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(((($current/r_total div $current/r_amountCustomer) div ($prev/r_total div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block>
										Ø Umsatz DL pro Besuch
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_amountCustomer!=0">
												<xsl:value-of select="format-number($prev/r_total_services div $prev/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_amountCustomer!=0">
												<xsl:value-of select="format-number($current/r_total_services div $current/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(($current/r_total_services div $current/r_amountCustomer) - ($prev/r_total_services div $prev/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
												<xsl:value-of select="format-number(($current/r_total_services div $current/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(0 - ($prev/r_total_services div $prev/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_total_services != 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(((($current/r_total_services div $current/r_amountCustomer) div ($prev/r_total_services div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block >
										Ø Umsatz VK pro Besuch
									</fo:block>
								</fo:table-cell>
								<xsl:variable name="current" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev/r_amountCustomer!=0">
												<xsl:value-of select="format-number($prev/r_total_products div $prev/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_amountCustomer!=0">
												<xsl:value-of select="format-number($current/r_total_products div $current/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(($current/r_total_products div $current/r_amountCustomer) - ($prev/r_total_products div $prev/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
												<xsl:value-of select="format-number(($current/r_total_products div $current/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current/r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(0 - ($prev/r_total_products div $prev/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current/r_total_products != 0 and $prev/r_amountCustomer != 0">
												<xsl:value-of select="format-number(((($current/r_total_products div $current/r_amountCustomer) div ($prev/r_total_products div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							

						</fo:table-body>
					</fo:table>

					<fo:block id="LastPage"/>

						</xsl:otherwise>
					</xsl:choose>

					
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
