<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">


	<xsl:template name="table">
		
		<xsl:variable name="timeRows">
			<xsl:value-of select="count(exsl:node-set(report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod))" />
		</xsl:variable>
		<xsl:variable name="percentRowSummaryWidth">
			<xsl:value-of select="($timeRows + 2) * 0.9" />
		</xsl:variable>

		<xsl:variable name="collumnWidth">
			<xsl:value-of select="(29.7 - 3.6 - 1.4 - $percentRowSummaryWidth) div ((timeRows + 2) * 3)" />
		</xsl:variable>

		
		<fo:table table-layout="fixed" width="100%">

			<!-- Hauptspalte -->
			<fo:table-column column-width="36mm"></fo:table-column>

			<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
				<!-- Datenspalten -->
				<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
				<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
				<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
				<!-- Prozentspalte -->
				<fo:table-column column-width="9mm" border-right="0.5mm solid black"></fo:table-column>
			</xsl:for-each>

			<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
			<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
			<fo:table-column column-width="{$collumnWidth}cm"></fo:table-column>
			<fo:table-column column-width="9mm" border-right="0.5mm solid black"></fo:table-column>

			<fo:table-body>
				
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
						</fo:block>
					</fo:table-cell>
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="center" font-weight="bold">
								<xsl:value-of select="$prev/label" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="center" font-weight="bold">
								<xsl:value-of select="label" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="center" font-weight="bold">
								Differenz
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="center" font-weight="bold">
								%
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>

					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="center" font-weight="bold">
							Gesamt <xsl:value-of select="/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod/year" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="center" font-weight="bold">
							Gesamt  <xsl:value-of select="/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod/year" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="center" font-weight="bold">
							Differenz
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="center" font-weight="bold">
							%
						</fo:block>
					</fo:table-cell>

				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Umsatz DL Dame
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_g1_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_g1_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								
								<xsl:value-of select="format-number((r_total_g1_services - $prev/r_total_g1_services), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
								
									<xsl:when test="$prev/r_total_g1_services != 0">
										<xsl:value-of select="format-number(((r_total_g1_services div $prev/r_total_g1_services) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
								
							</fo:block>
						</fo:table-cell>
						


					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
					<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="right">
							<xsl:value-of select="format-number($prev2/r_total_g1_services, '###.##0,##', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="right">
							<xsl:value-of select="format-number($current2/r_total_g1_services, '###.##0,##', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="right">
							
							<xsl:value-of select="format-number(($current2/r_total_g1_services - $prev2/r_total_g1_services), '###.##0,##', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block text-align="right">
							<xsl:choose>
							
								<xsl:when test="$prev2/r_total_g1_services != 0">
									<xsl:value-of select="format-number((($current2/r_total_g1_services div $prev2/r_total_g1_services) - 1) * 100 , '###.##0,##', 'money')" />
								</xsl:when>
								<xsl:otherwise>
									-
								</xsl:otherwise>
							</xsl:choose>
							
						</fo:block>
					</fo:table-cell>

				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Umsatz DL Herr
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_g2_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_g2_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								
								<xsl:value-of select="format-number((r_total_g2_services - $prev/r_total_g2_services), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
								
									<xsl:when test="$prev/r_total_g2_services != 0">
										<xsl:value-of select="format-number(((r_total_g2_services div $prev/r_total_g2_services) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
								
							</fo:block>
						</fo:table-cell>


					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev2/r_total_g2_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current2/r_total_g2_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current2/r_total_g2_services - $prev2/r_total_g2_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_g2_services != 0">
													<xsl:value-of select="format-number((($current2/r_total_g2_services div $prev2/r_total_g2_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>

				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Umsatz DL Kind
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_g3_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_g3_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								
								<xsl:value-of select="format-number((r_total_g3_services - $prev/r_total_g3_services), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
								
									<xsl:when test="$prev/r_total_g3_services != 0">
										<xsl:value-of select="format-number(((r_total_g3_services div $prev/r_total_g3_services) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
								
							</fo:block>
						</fo:table-cell>


					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev2/r_total_g3_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current2/r_total_g3_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current2/r_total_g3_services - $prev2/r_total_g3_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_g3_services != 0">
													<xsl:value-of select="format-number((($current2/r_total_g3_services div $prev2/r_total_g3_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>

				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Umsatz DL
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number($prev/r_total_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number(r_total_services, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								
								<xsl:value-of select="format-number((r_total_services - $prev/r_total_services), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
								
									<xsl:when test="$prev/r_total_services != 0">
										<xsl:value-of select="format-number(((r_total_services div $prev/r_total_services) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
								
							</fo:block>
						</fo:table-cell>
						


					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($prev2/r_total_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($current2/r_total_services, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											
											<xsl:value-of select="format-number(($current2/r_total_services - $prev2/r_total_services), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_services != 0">
													<xsl:value-of select="format-number((($current2/r_total_services div $prev2/r_total_services) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>

				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Umsatz VK
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>

						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number($prev/r_total_products, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number(r_total_products, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								
								<xsl:value-of select="format-number((r_total_products - $prev/r_total_products), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
								
									<xsl:when test="$prev/r_total_products != 0">
										<xsl:value-of select="format-number(((r_total_products div $prev/r_total_products) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
								
							</fo:block>
						</fo:table-cell>


					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($prev2/r_total_products, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($current2/r_total_products, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											
											<xsl:value-of select="format-number(($current2/r_total_products - $prev2/r_total_products), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_products != 0">
													<xsl:value-of select="format-number((($current2/r_total_products div $prev2/r_total_products) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>

				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Umsatz Dame Gesamt
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_g1, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_g1, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_total_g1 - $prev/r_total_g1), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_total_g1 != 0">
										<xsl:value-of select="format-number(((r_total_g1 div $prev/r_total_g1) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev2/r_total_g1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current2/r_total_g1, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current2/r_total_g1 - $prev2/r_total_g1), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_g1 != 0">
													<xsl:value-of select="format-number((($current2/r_total_g1 div $prev2/r_total_g1) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Umsatz Herr Gesamt
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_g2, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_g2, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_total_g2 - $prev/r_total_g2), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_total_g2 != 0">
										<xsl:value-of select="format-number(((r_total_g2 div $prev/r_total_g2) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev2/r_total_g2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current2/r_total_g2, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current2/r_total_g2 - $prev2/r_total_g2), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_g2 != 0">
													<xsl:value-of select="format-number((($current2/r_total_g2 div $prev2/r_total_g2) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Umsatz Kind Gesamt
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_g3, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_g3, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_total_g3 - $prev/r_total_g3), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_total_g3 != 0">
										<xsl:value-of select="format-number(((r_total_g3 div $prev/r_total_g3) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($prev2/r_total_g3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:value-of select="format-number($current2/r_total_g3, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											
											<xsl:value-of select="format-number(($current2/r_total_g3 - $prev2/r_total_g3), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total_g3 != 0">
													<xsl:value-of select="format-number((($current2/r_total_g3 div $prev2/r_total_g3) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Umsatz Gesamt
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number($prev/r_total, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number(r_total, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								
								<xsl:value-of select="format-number((r_total - $prev/r_total), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="$prev/r_total != 0">
										<xsl:value-of select="format-number(((r_total div $prev/r_total) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

									
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($prev2/r_total, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:value-of select="format-number($current2/r_total, '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											
											<xsl:value-of select="format-number(($current2/r_total - $prev2/r_total), '###.##0,##', 'money')" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="cell-style0">
										<fo:block text-align="right" font-weight="bold">
											<xsl:choose>
											
												<xsl:when test="$prev2/r_total != 0">
													<xsl:value-of select="format-number((($current2/r_total div $prev2/r_total) - 1) * 100 , '###.##0,##', 'money')" />
												</xsl:when>
												<xsl:otherwise>
													-
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>
									</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							VK Anteil am Umsatz
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_total != 0">
										<xsl:value-of select="format-number(($prev/r_total_products div $prev/r_total) * 100 ,'###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="r_total != 0 and $prev/r_total != 0">
										<xsl:value-of select="format-number((r_total_products div r_total) * 100, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								
								<xsl:choose>
									<xsl:when test="r_total != 0 and $prev/r_total != 0">
										<xsl:value-of select="format-number((((r_total_products div r_total) * 100) - (($prev/r_total_products div $prev/r_total) * 100)), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_total = 0 and $prev/r_total != 0">
										<xsl:value-of select="format-number((0 - (($prev/r_total_products div $prev/r_total) * 100)), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_total != 0 and $prev/r_total = 0">
										<xsl:value-of select="format-number(((r_total_products div r_total) * 100), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="r_total != 0 and $prev/r_total != 0">
										<xsl:value-of select="format-number(((((r_total_products div r_total) * 100) div  (($prev/r_total_products div $prev/r_total) * 100)) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>

									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_total != 0">
												<xsl:value-of select="format-number(($prev2/r_total_products div $prev2/r_total) * 100 ,'###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_total">
												<xsl:value-of select="format-number(($current2/r_total_products div $current2/r_total) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										
										<xsl:choose>
											<xsl:when test="$current2/r_total != 0 and $prev2/r_total != 0">
												<xsl:value-of select="format-number(((($current2/r_total_products div $current2/r_total) * 100) - (($prev2/r_total_products div $prev2/r_total) * 100)), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_total = 0 and $prev2/r_total != 0">
												<xsl:value-of select="format-number((0 - (($prev2/r_total_products div $prev2/r_total) * 100)), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_total != 0 and $prev2/r_total = 0">
												<xsl:value-of select="format-number((($current2/r_total_products div $current2/r_total) * 100), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_total != 0 and $prev2/r_total != 0">
												<xsl:value-of select="format-number((((($current2/r_total_products div $current2/r_total) * 100) div  (($prev2/r_total_products div $prev2/r_total) * 100)) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>

											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø Umsatz pro Tag
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_total_per_day, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_total_per_day, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_total_per_day - $prev/r_total_per_day), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_total_per_day != 0">
										<xsl:value-of select="format-number(((r_total_per_day div $prev/r_total_per_day) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev2/r_total_per_day, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current2/r_total_per_day, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current2/r_total_per_day - $prev2/r_total_per_day), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_total_per_day != 0">
												<xsl:value-of select="format-number((($current2/r_total_per_day div $prev2/r_total_per_day) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Anzahl Damen
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_amountGoup1, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_amountGoup1, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_amountGoup1 - $prev/r_amountGoup1), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_amountGoup1 != 0">
										<xsl:value-of select="format-number(((r_amountGoup1 div $prev/r_amountGoup1) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev2/r_amountGoup1, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current2/r_amountGoup1, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current2/r_amountGoup1 - $prev2/r_amountGoup1), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountGoup1 != 0">
												<xsl:value-of select="format-number((($current2/r_amountGoup1 div $prev2/r_amountGoup1) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Anzahl Herren
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_amountGoup2, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_amountGoup2, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_amountGoup2 - $prev/r_amountGoup2), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_amountGoup2 != 0">
										<xsl:value-of select="format-number(((r_amountGoup2 div $prev/r_amountGoup2) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev2/r_amountGoup2, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current2/r_amountGoup2, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current2/r_amountGoup2 - $prev2/r_amountGoup2), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountGoup2 != 0">
												<xsl:value-of select="format-number((($current2/r_amountGoup2 div $prev2/r_amountGoup2) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Anzahl Kinder
						</fo:block>
					</fo:table-cell>
					
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number($prev/r_amountGoup3, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number(r_amountGoup3, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:value-of select="format-number((r_amountGoup3 - $prev/r_amountGoup3), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_amountGoup3 != 0">
										<xsl:value-of select="format-number(((r_amountGoup3 div $prev/r_amountGoup3) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($prev2/r_amountGoup3, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number($current2/r_amountGoup3, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:value-of select="format-number(($current2/r_amountGoup3 - $prev2/r_amountGoup3), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountGoup3 != 0">
												<xsl:value-of select="format-number((($current2/r_amountGoup3 div $prev2/r_amountGoup3) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Anzahl Besuche
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number($prev/r_amountCustomer, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:value-of select="format-number(r_amountCustomer, '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								
								<xsl:value-of select="format-number((r_amountCustomer - $prev/r_amountCustomer), '###.##0,##', 'money')" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="$prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number(((r_amountCustomer div $prev/r_amountCustomer) - 1) * 100 , '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								
								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:value-of select="format-number($prev2/r_amountCustomer, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:value-of select="format-number($current2/r_amountCustomer, '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										
										<xsl:value-of select="format-number(($current2/r_amountCustomer - $prev2/r_amountCustomer), '###.##0,##', 'money')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number((($current2/r_amountCustomer div $prev2/r_amountCustomer) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Besuche pro Tag
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="$prev/cntDay!=0">
										<xsl:value-of select="format-number($prev/r_amountCustomer div $prev/cntDay, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="cntDay!=0">
										<xsl:value-of select="format-number(r_amountCustomer div cntDay, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="cntDay != 0 and $prev/cntDay != 0">
										<xsl:value-of select="format-number((r_amountCustomer div cntDay) - ($prev/r_amountCustomer div $prev/cntDay), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="cntDay != 0 and $prev/cntDay = 0">
										<xsl:value-of select="format-number((r_amountCustomer div cntDay), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="cntDay = 0 and $prev/cntDay != 0">
										<xsl:value-of select="format-number(0 - ($prev/r_amountCustomer div $prev/cntDay), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="cntDay != 0 and $prev/cntDay != 0">
										<xsl:value-of select="format-number((((r_amountCustomer div cntDay) div ($prev/r_amountCustomer div $prev/cntDay)) -1 ) * 100, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$prev2/cntDay!=0">
												<xsl:value-of select="format-number($prev2/r_amountCustomer div $prev2/cntDay, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current2/cntDay!=0">
												<xsl:value-of select="format-number($current2/r_amountCustomer div $current2/cntDay, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current2/cntDay != 0 and $prev2/cntDay != 0">
												<xsl:value-of select="format-number(($current2/r_amountCustomer div $current2/cntDay) - ($prev2/r_amountCustomer div $prev2/cntDay), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/cntDay != 0 and $prev2/cntDay = 0">
												<xsl:value-of select="format-number(($current2/r_amountCustomer div $current2/cntDay), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/cntDay = 0 and $prev2/cntDay != 0">
												<xsl:value-of select="format-number(0 - ($prev2/r_amountCustomer div $prev2/cntDay), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current2/cntDay != 0 and $prev2/cntDay != 0">
												<xsl:value-of select="format-number(((($current2/r_amountCustomer div $current2/cntDay) div ($prev2/r_amountCustomer div $prev2/cntDay)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>



				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø DL Dame
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g1,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_services_per_g1,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_g1,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g1" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_g1 - $prev/r_services_per_g1,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g1" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number(((base div compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_services_per_g1 != 0">
												<xsl:value-of select="format-number(((r_services_per_g1 div $prev/r_services_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_g1 - $prev2/r_services_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g1" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_services_per_g1 != 0">
														<xsl:value-of select="format-number((($current2/r_services_per_g1 div $prev2/r_services_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø DL Herr
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g2,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_services_per_g2,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g2,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_g2,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g1" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g2" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_g2 - $prev/r_services_per_g2,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g2" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g2" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_services_per_g2 != 0">
												<xsl:value-of select="format-number(((r_services_per_g2 div $prev/r_services_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_g2 - $prev2/r_services_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g2" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_services_per_g2 != 0">
														<xsl:value-of select="format-number((($current2/r_services_per_g2 div $prev2/r_services_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø DL Kind
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g3,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_services_per_g3,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g3,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_g3,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g3" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g3" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_g3 - $prev/r_services_per_g3,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_g3" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_g3" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_services_per_g3 != 0">
												<xsl:value-of select="format-number(((r_services_per_g3 div $prev/r_services_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_g3 - $prev2/r_services_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_g3" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_services_per_g3 != 0">
														<xsl:value-of select="format-number((($current2/r_services_per_g3 div $prev2/r_services_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>




				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Ø DL Besuch
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_cus,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_services_per_cus,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_cus,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_cus,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_cus" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_cus" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_services_per_cus - $prev/r_services_per_cus,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_services_per_cus" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_services_per_cus" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_services_per_cus != 0">
												<xsl:value-of select="format-number(((r_services_per_cus div $prev/r_services_per_cus) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>


								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_services_per_cus - $prev2/r_services_per_cus,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_services_per_cus" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_services_per_cus != 0">
														<xsl:value-of select="format-number((($current2/r_services_per_cus div $prev2/r_services_per_cus) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Anzahl DL Gesamt
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_count_services,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_count_services,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_count_services,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_count_services,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_count_services" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_count_services" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_count_services - $prev/r_count_services,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" font-weight="bold">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_count_services" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_count_services" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_count_services != 0">
												<xsl:value-of select="format-number(((r_count_services div $prev/r_count_services) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_count_services,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_count_services,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_count_services,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_count_services,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_count_services" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_count_services" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_count_services - $prev2/r_count_services,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right" font-weight="bold">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_count_services" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_count_services" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_count_services != 0">
														<xsl:value-of select="format-number((($current2/r_count_services div $prev2/r_count_services) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø Umsatz Dame
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g1,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_total_per_g1,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g1,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_total_per_g1,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g1" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g1" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_total_per_g1 - $prev/r_total_per_g1,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g1" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g1" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_total_per_g1 != 0">
												<xsl:value-of select="format-number(((r_total_per_g1 div $prev/r_total_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_total_per_g1 - $prev2/r_total_per_g1,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g1" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_total_per_g1 != 0">
														<xsl:value-of select="format-number((($current2/r_total_per_g1 div $prev2/r_total_per_g1) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø Umsatz Herr
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g2,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_total_per_g2,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g2,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_total_per_g2,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g2" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g2" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_total_per_g2 - $prev/r_total_per_g2,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g2" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g2" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_total_per_g2 != 0">
												<xsl:value-of select="format-number(((r_total_per_g2 div $prev/r_total_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_total_per_g2 - $prev2/r_total_per_g2,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g2" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_total_per_g2 != 0">
														<xsl:value-of select="format-number((($current2/r_total_per_g2 div $prev2/r_total_per_g2) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø Umsatz Kind
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						<xsl:variable name="timeLabel">
							<xsl:value-of select="label" />
						</xsl:variable>
						<xsl:variable name="timeLabelPrev">
							<xsl:value-of select="$prev/label" />
						</xsl:variable>
						
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g3,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number($prev/r_total_per_g3,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:value-of select="format-number(/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g3,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_total_per_g3,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>	
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g3" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g3" />
										</xsl:variable>
										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:value-of select="format-number(r_total_per_g3 - $prev/r_total_per_g3,'###.##0,##', 'money')" />
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">

								<xsl:choose>
									<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
										<xsl:variable name="base">
											<xsl:value-of select="/report/transaction/data/bioBaseTimes/bioCntPeriod[label = $timeLabel]/r_total_per_g3" />
										</xsl:variable>
										<xsl:variable name="compare">
											<xsl:value-of select="/report/transaction/data/bioCompareTimes/bioCntPeriod[label = $timeLabelPrev]/r_total_per_g3" />
										</xsl:variable>

										<xsl:choose>
											<xsl:when test="$compare != 0">
												<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>

										<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
									</xsl:when>	
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$prev/r_total_per_g3 != 0">
												<xsl:value-of select="format-number(((r_total_per_g3 div $prev/r_total_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>

							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($prev2/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:value-of select="format-number(/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>	
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>
												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:value-of select="format-number($current2/r_total_per_g3 - $prev2/r_total_per_g3,'###.##0,##', 'money')" />
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">

										<xsl:choose>
											<xsl:when test="/report/useBUOptionBio/row/property_value = '1'">
												<xsl:variable name="base">
													<xsl:value-of select="/report/transaction/data/bioBaseSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>
												<xsl:variable name="compare">
													<xsl:value-of select="/report/transaction/data/bioCompareSums/bioCntPeriod/r_total_per_g3" />
												</xsl:variable>

												<xsl:choose>
													<xsl:when test="$compare != 0">
														<xsl:value-of select="format-number((($base div $compare) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>

												<xsl:value-of select="format-number($base - $compare,'###.##0,##', 'money')" />
											</xsl:when>	
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$prev2/r_total_per_g3 != 0">
														<xsl:value-of select="format-number((($current2/r_total_per_g3 div $prev2/r_total_per_g3) - 1) * 100 , '###.##0,##', 'money')" />
													</xsl:when>
													<xsl:otherwise>
														-
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block font-weight="bold">
							Ø Umsatz pro Besuch
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="$prev/r_amountCustomer!=0">
										<xsl:value-of select="format-number($prev/r_total div $prev/r_amountCustomer, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="r_amountCustomer!=0">
										<xsl:value-of select="format-number(r_total div r_amountCustomer, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number((r_total div r_amountCustomer) - ($prev/r_total div $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
										<xsl:value-of select="format-number((r_total div r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number(0 - ($prev/r_total div $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right"  font-weight="bold">
								<xsl:choose>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number((((r_total div r_amountCustomer) div ($prev/r_total div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountCustomer!=0">
												<xsl:value-of select="format-number($prev2/r_total div $prev2/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current2/r_amountCustomer!=0">
												<xsl:value-of select="format-number($current2/r_total div $current2/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current2/r_amountCustomer != 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(($current2/r_total div $current2/r_amountCustomer) - ($prev2/r_total div $prev2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_amountCustomer != 0 and $prev2/r_amountCustomer = 0">
												<xsl:value-of select="format-number(($current2/r_total div $current2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_amountCustomer = 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(0 - ($prev2/r_total div $prev2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right"  font-weight="bold">
										<xsl:choose>
											<xsl:when test="$current2/r_total != 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(((($current2/r_total div $current2/r_amountCustomer) div ($prev2/r_total div $prev2/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø DL Umsatz pro Besuch
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_amountCustomer!=0">
										<xsl:value-of select="format-number($prev/r_total_services div $prev/r_amountCustomer, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="r_amountCustomer!=0">
										<xsl:value-of select="format-number(r_total_services div r_amountCustomer, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" >
								<xsl:choose>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number((r_total_services div r_amountCustomer) - ($prev/r_total_services div $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
										<xsl:value-of select="format-number((r_total_services div r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number(0 - ($prev/r_total_services div $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number((((r_total_services div r_amountCustomer) div ($prev/r_total_services div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountCustomer!=0">
												<xsl:value-of select="format-number($prev2/r_total_services div $prev2/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_amountCustomer!=0">
												<xsl:value-of select="format-number($current2/r_total_services div $current2/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_amountCustomer != 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(($current2/r_total_services div $current2/r_amountCustomer) - ($prev2/r_total_services div $prev2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_amountCustomer != 0 and $prev2/r_amountCustomer = 0">
												<xsl:value-of select="format-number(($current2/r_total_services div $current2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_amountCustomer = 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(0 - ($prev2/r_total_services div $prev2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_total_services != 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(((($current2/r_total_services div $current2/r_amountCustomer) div ($prev2/r_total_services div $prev2/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>


				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell-style0">
						<fo:block>
							Ø VK Umsatz pro Besuch
						</fo:block>
					</fo:table-cell>
					<!-- Für jede Zeiteinteilung brauchen wir die Splaten für current,prev,nominal,percent -->
					<xsl:for-each select="report/transaction/data/baseTimes/periodComparisonSalesDevelopmentPeriod">
						<!-- Vergleichzeitraum -->
						<xsl:variable name="id">
							<xsl:value-of select="ident" />
						</xsl:variable>
						<xsl:variable name="prev" select="exsl:node-set(/report/transaction/data/compareTimes/periodComparisonSalesDevelopmentPeriod[ident = $id])"></xsl:variable>
						
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="$prev/r_amountCustomer!=0">
										<xsl:value-of select="format-number($prev/r_total_products div $prev/r_amountCustomer, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="r_amountCustomer!=0">
										<xsl:value-of select="format-number(r_total_products div r_amountCustomer, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right" >
								<xsl:choose>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number((r_total_products div r_amountCustomer) - ($prev/r_total_products div $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer = 0">
										<xsl:value-of select="format-number((r_total_products div r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:when test="r_amountCustomer = 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number(0 - ($prev/r_total_products div $prev/r_amountCustomer), '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										0
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="cell-style0">
							<fo:block text-align="right">
								<xsl:choose>
									<xsl:when test="r_amountCustomer != 0 and $prev/r_amountCustomer != 0">
										<xsl:value-of select="format-number((((r_total_products div r_amountCustomer) div ($prev/r_total_products div $prev/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
									</xsl:when>
									<xsl:otherwise>
										-
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
					<xsl:variable name="current2" select="exsl:node-set(/report/transaction/data/baseSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>
								<xsl:variable name="prev2" select="exsl:node-set(/report/transaction/data/compareSums/periodComparisonSalesDevelopmentPeriod)"></xsl:variable>

								
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$prev2/r_amountCustomer!=0">
												<xsl:value-of select="format-number($prev2/r_total_products div $prev2/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_amountCustomer!=0">
												<xsl:value-of select="format-number($current2/r_total_products div $current2/r_amountCustomer, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_amountCustomer != 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(($current2/r_total_products div $current2/r_amountCustomer) - ($prev2/r_total_products div $prev2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_amountCustomer != 0 and $prev2/r_amountCustomer = 0">
												<xsl:value-of select="format-number(($current2/r_total_products div $current2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:when test="$current2/r_amountCustomer = 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(0 - ($prev2/r_total_products div $prev2/r_amountCustomer), '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style0">
									<fo:block text-align="right">
										<xsl:choose>
											<xsl:when test="$current2/r_total_products != 0 and $prev2/r_amountCustomer != 0">
												<xsl:value-of select="format-number(((($current2/r_total_products div $current2/r_amountCustomer) div ($prev2/r_total_products div $prev2/r_amountCustomer)) -1 ) * 100, '###.##0,##', 'money')" />
											</xsl:when>
											<xsl:otherwise>
												-
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
				</fo:table-row>




				

			</fo:table-body>
		</fo:table>
		<fo:block id="LastPage"/>
	</xsl:template>

</xsl:stylesheet>
