<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.1mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.1mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="footer-text">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>






	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO"
					page-height="25cm" page-width="70mm" margin-top="3mm"
					margin-bottom="3mm" margin-left="8mm" margin-right="3mm">
					<fo:region-body margin-top="23mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="18mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>


			<fo:page-sequence master-reference="THERMO">
				<fo:static-content flow-name="header">
					<fo:block text-align="center" xsl:use-attribute-sets="report-title">
						Tagesauswertung Schublade
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_nm_2" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_street" />
						,
						<xsl:value-of select="report/businessunits/row/bu_postal_cd" />
						&#160;
						<xsl:value-of select="report/businessunits/row/bu_city" />
						,
						<xsl:value-of select="report/businessunits/row/bu_country_cd" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/businessunit_nm" />
						, Kostenstelle
						<xsl:value-of select="report/businessunits/row/bu_nm_1" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="'Ansicht nach Wertstellungsdatum'" />
					</fo:block>
				</fo:static-content>
				<!-- <fo:static-content flow-name="footer"> <fo:block xsl:use-attribute-sets="footer-text" 
					text-align="left" font-size="8pt"> <fo:table width="100%"> <fo:table-column 
					column-width="20%"></fo:table-column> <fo:table-column column-width="60%"></fo:table-column> 
					<fo:table-column column-width="20%"></fo:table-column> <fo:table-body> <fo:table-row> 
					<fo:table-cell text-align="left" xsl:use-attribute-sets="footer-text"> <fo:block> 
					<xsl:call-template name="formatdate"> <xsl:with-param name="datestr" select="report/report-params/NOW" 
					/> </xsl:call-template> </fo:block> </fo:table-cell> <fo:table-cell text-align="center" 
					xsl:use-attribute-sets="footer-text"> <fo:block> Tagesabschluss Schublade 
					</fo:block> </fo:table-cell> <fo:table-cell text-align="right" xsl:use-attribute-sets="footer-text"> 
					<fo:block> <fo:page-number /> / <fo:page-number-citation ref-id="LastPage" 
					/> </fo:block> </fo:table-cell> </fo:table-row> </fo:table-body> </fo:table> 
					</fo:block> </fo:static-content> -->

				<xsl:variable name="drawerNo">
					<xsl:value-of select="report/report-params/DRAWER_NO" />
				</xsl:variable>

				<fo:flow flow-name="xsl-region-body">
	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="23mm"></fo:table-column>
						<fo:table-column column-width="2mm"></fo:table-column>
						<fo:table-column column-width="39mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Schublade
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of
											select="report/drawers/row[drawer_no=$drawerNo]/drawer_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<!-- 	<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzungen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/count_sessions/row/t_cnt_sessions_end" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row> -->

							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/report-params/DATE" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Erstellungsdatum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/report-params/NOW" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Zahlungsverkehr</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Bar</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Anfangsbestand:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/beforeCashValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Bareinnahmen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/daySalesCashInValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="/report/pos_sessions_acct/row">


								<xsl:variable name="acctCd">
									<xsl:value-of select="contra_acct_cd" />
								</xsl:variable>

								<xsl:choose>
									<xsl:when test="/report/drawers/row[acct_cd=$acctCd]/drawer_no">
										<xsl:if test="t_acct_cd_cash_in>0">


											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell">
													<fo:block>
														+&#160;Umbuchung

														von
														<xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />


													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="cell">
													<fo:block>


														<xsl:value-of
															select="format-number(t_acct_cd_cash_in, '###.##0,00', 'money')" />
														&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>



													</fo:block>
												</fo:table-cell>
											</fo:table-row>

										</xsl:if>



									</xsl:when>

									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$acctCd!='-'">
												<xsl:if test="t_acct_cd_cash_in>0">


													<fo:table-row>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																+&#160;Einlage
																-
																<xsl:value-of
																	select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />

															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>


																<xsl:value-of
																	select="format-number(t_acct_cd_cash_in, '###.##0,00', 'money')" />
																&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>




															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:if>
											</xsl:when>

											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
															+&#160;Einlage

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>


															<xsl:value-of
																select="format-number(t_acct_cd_cash_in, '###.##0,00', 'money')" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>




														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>



							</xsl:for-each>





							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										-&#160;Barausgaben
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/dayPurchaseCashOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="/report/pos_sessions_acct/row">


								<xsl:variable name="acctCd">
									<xsl:value-of select="contra_acct_cd" />
								</xsl:variable>


								<xsl:choose>
									<xsl:when test="/report/drawers/row[acct_cd=$acctCd]/drawer_no">
										<xsl:if test="t_acct_cd_cash_out>0">


											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell">
													<fo:block>
														-&#160;Umbuchung

														nach
														<xsl:value-of
															select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />


													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="cell">
													<fo:block>


														<xsl:value-of
															select="format-number(t_acct_cd_cash_out, '###.##0,00', 'money')" />
														&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>



													</fo:block>
												</fo:table-cell>
											</fo:table-row>

										</xsl:if>



									</xsl:when>

									<xsl:otherwise>

										<xsl:choose>
											<xsl:when test="$acctCd!='-'">
												<xsl:if test="t_acct_cd_cash_out>0">


													<fo:table-row>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																-&#160;Entnahme
																-
																<xsl:value-of
																	select="/report/simple_accounts/row[simple_acct_cd=$acctCd]/simple_acct_nm" />

															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>


																<xsl:value-of
																	select="format-number(t_acct_cd_cash_out, '###.##0,00', 'money')" />
																&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>





															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:if>
											</xsl:when>

											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
															-&#160;Entnahme

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>

															<xsl:value-of
																select="format-number(t_acct_cd_cash_out, '###.##0,00', 'money')" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>





														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>


									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>

							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Endbestand:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/endCashValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Bargeldlos</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;EC-Einnahmen / EC-Schnitt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/ecValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Kreditkarten-Einnahmen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/ccValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Einnahmen zur Überweisung vorgemerkt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/transferSIValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										-&#160;Ausgaben zur Überweisung vorgemerkt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/transferPurchaseOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Ausgegebene Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/voucherOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Eingelöste Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/voucherInValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Online Zahlungen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/onlineValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Verlust
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/lossValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<!-- 	<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Ausgegebene Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/creditNoteOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Eingelöste Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/creditNoteInValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row> -->

						</fo:table-body>
					</fo:table>

					<fo:block page-break-inside="avoid">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-body>
								<fo:table-row height="50mm">
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
									<fo:table-cell border-top-style="solid"
										text-align="center" xsl:use-attribute-sets="cell">
										<fo:block>Ort, Datum, Unterschrift</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</fo:table-body>

						</fo:table>
					</fo:block>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>