<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					    <xsl:call-template name="header">
        <xsl:with-param name="title" select='"Transaktionübersicht"' />
        <xsl:with-param name="businessunit" select="report/businessunits/row" />
    </xsl:call-template>

				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%" />
							<fo:table-column column-width="60%" />
							<fo:table-column column-width="20%" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Transaktionübersicht
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="report/departmentCurrency/row/currency_symbol" />
					</xsl:variable>
					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm" />
						<fo:table-column column-width="3mm" />
						<fo:table-column column-width="65mm" />

						<fo:table-body>

							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Schublade
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/drawers/row/drawer_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/report-params/DATE" />
										</xsl:call-template>
										-
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr"
												select="report/report-params/TODATE" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%" />
						<fo:table-column column-width="30%" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Transaktionen</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
											<fo:table-column column-width="15%" />
											<fo:table-column column-width="10%" />
											<fo:table-column column-width="23%" />
											<fo:table-column column-width="15%" />
											<fo:table-column column-width="5%" />
											<fo:table-column column-width="10%" />
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Buchungsdatum</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlungsdatum</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Referenz Beleg</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Transaktion</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Typ</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlart</fo:block>
													</fo:table-cell>
												</fo:table-row>

							
													<xsl:for-each select="report/pos_payments/row">
														<fo:table-row>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:call-template name="formatdatetime">
																		<xsl:with-param name="datetimestr"
																			select="payment_booking_ts" />
																	</xsl:call-template>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:call-template name="formatdatetime">
																		<xsl:with-param name="datetimestr"
																			select="payment_ts" />
																	</xsl:call-template>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="employee_nm" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="payment_ref" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>

																	<xsl:value-of select="ref_txt" />
																	<xsl:value-of select="storno_ref_reason_txt" />


																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="report_nm" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of
																		select="format-number(payment_diff, '###.##0,00', 'money')" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="payment_type" />
																	<xsl:value-of select="storno_ref_txt" />
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
			
												



											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>


					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%" />
						<fo:table-column column-width="30%" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Legende</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm" />
											<fo:table-column column-width="50mm" />


											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlart</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zahlartname</fo:block>
													</fo:table-cell>

												</fo:table-row>
											</fo:table-header>
											<fo:table-body>

												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															1
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Bar
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															2
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Gutschein
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															4
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															EC
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															5
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Kreditkarte
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															6
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Nachlass
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															7
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Gutschrift
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															8
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Überweisung
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															9
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Auslagen
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															10
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															Punktenachlass
														</fo:block>
													</fo:table-cell>

												</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															11
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell">
														<fo:block>
															generierter Gutschein
														</fo:block>
													</fo:table-cell>




												</fo:table-row>


											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>



					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>