<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">

    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1Rotated">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="borderRotated">
		<xsl:attribute name="border-top-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableInnerSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
		<!-- <xsl:attribute name="font-weight">bold</xsl:attribute> -->
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableOuterSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderInnerSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderOuterSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="container_header">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.85cm</xsl:attribute>
	</xsl:attribute-set>
	
		<xsl:attribute-set name="containerHeader">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.00m</xsl:attribute>
		 <xsl:attribute name="width">3.0cm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	<xsl:attribute-set name="containerHeaderLabel">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.0cm</xsl:attribute>
		 <xsl:attribute name="margin-left">2mm</xsl:attribute>
		 <xsl:attribute name="keep-together">always</xsl:attribute>
		  <xsl:attribute name="padding-top">3mm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
    <xsl:call-template name="header">
        <xsl:with-param name="title" select='"Umsatzentwicklung"' />
        <xsl:with-param name="businessunit" select="report/businessunits/row" />
        <xsl:with-param name="period1" select="report/report-params/DATE" />
        <xsl:with-param name="period2" select="report/report-params/TODATE" />
    </xsl:call-template>
					
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="65%"></fo:table-column>
							<fo:table-column column-width="15%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Umsatzentwicklung
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
				<xsl:choose>
					<xsl:when test="report/servicesRevenue/reportMode = 'salon'">
						<xsl:for-each select="report/servicesRevenue/tableList/table">
							<xsl:variable name="tableNum" select="tableNum" />
							<xsl:choose>
							
								<xsl:when test="tableNum = 0">
									<fo:table table-layout="fixed" border-collapse="collapse"
										width="100%" margin-top="0cm">
										<xsl:choose>
											<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<xsl:for-each select="reportCategory/row">
													<fo:table-column column-width="7.65%"></fo:table-column>
												</xsl:for-each>				
												
												<fo:table-header >
													<fo:table-row>
													
													  <fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold-left">
																<fo:block>Frequenz</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Arbeitstage</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Umsatz gesamt</fo:block>
														</fo:table-cell> 
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Kunden gesamt</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Neukunden gesamt</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Gesamt-umsatz pro Tag</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Gesamt-umsatz pro Kunde</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Gesamt-kunde pro Tag</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>DL Pro Kunde</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>DL Pro Tag</fo:block>
														</fo:table-cell>
														<xsl:for-each select="reportCategory/row">
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="th1bold">
																<fo:block>%<xsl:value-of select="." /></fo:block>
															</fo:table-cell>
														</xsl:for-each>			
														
														
														
													
													</fo:table-row>
													</fo:table-header>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<fo:table-column column-width="7.65%"></fo:table-column>
												<xsl:for-each select="reportCategory/row">
													<fo:table-column column-width="7.65%"></fo:table-column>
												</xsl:for-each>				
												
												<fo:table-header >
													<fo:table-row>
													
													  <fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold-left">
																<fo:block>Frequenz</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Umsatz gesamt</fo:block>
														</fo:table-cell> 
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Kunden gesamt</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Neukunden gesamt</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Umsatz pro Tag</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Umsatz pro Kunde</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Kunde pro Tag</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Anzahl DL gesamt</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center"
															xsl:use-attribute-sets="th1bold">
															<fo:block>Anzahl DL pro Kunde</fo:block>
														</fo:table-cell>
														<xsl:for-each select="reportCategory/row">
															<fo:table-cell text-align="center"
																xsl:use-attribute-sets="th1bold">
																<fo:block>%<xsl:value-of select="." /></fo:block>
															</fo:table-cell>
														</xsl:for-each>			
														
														
														
													
													</fo:table-row>
													</fo:table-header>
											</xsl:otherwise>
										</xsl:choose>
										
											<fo:table-body>
											<xsl:for-each select="/report/servicesRevenue/serviceRevenueList/row">
												<xsl:variable name="label" select="label" />
												<xsl:variable name="rTotal" select="r_total" />
												<fo:table-row >
														<xsl:choose>
														<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-style0">
														<fo:block>
															<xsl:value-of select="label" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_cnt_dt, '###.##0', 'amount')" />
												
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
												
														</fo:block>
													</fo:table-cell>
													
													
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
														</fo:block>
													</fo:table-cell>
													
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															
															<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
														
														</fo:block>
													</fo:table-cell>
										
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
														</fo:block>
													</fo:table-cell>
									
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
														</fo:block>
													</fo:table-cell>
													
												
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
														</fo:block>
													</fo:table-cell>
													
												
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_services_per_day, '###.##0,##', 'amount')" />	
														</fo:block>
													</fo:table-cell>
													</xsl:when>
													<xsl:otherwise>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-style0">
														<fo:block>
															<xsl:value-of select="label" />
														</fo:block>
													</fo:table-cell>
							
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
												
														</fo:block>
													</fo:table-cell>
													
													
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
														</fo:block>
													</fo:table-cell>
													
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															
															<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
														
														</fo:block>
													</fo:table-cell>
										
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
														</fo:block>
													</fo:table-cell>
									
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
														</fo:block>
													</fo:table-cell>
													
												
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_total_services, '###.##0,##', 'amount')" />	
														</fo:block>
													</fo:table-cell>
													
												
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-style">
														<fo:block>
															<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
														</fo:block>
													</fo:table-cell>
													</xsl:otherwise>
													</xsl:choose>
													
													<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
														<xsl:variable name="category" select="." />
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="th1bold">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="$rTotal = 0">
																		0
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="format-number((/report/servicesRevenue/serviceRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>			
													
													
																
				
												</fo:table-row>
				
												
												
												
											</xsl:for-each>
											
											<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/serviceRevenueList/row/r_total)" />
											<fo:table-row>
											
											  <fo:table-cell text-align="left"
													xsl:use-attribute-sets="th3bold">
														<fo:block>Gesamt</fo:block>
												</fo:table-cell>
												<xsl:choose>
														<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_cnt_dt),  '###.##0', 'amount')" /> 
													</fo:block>
												</fo:table-cell> 
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_services_per_day),  '###.##0,##', 'amount')" /> 
													</fo:block>
												</fo:table-cell> 
												</xsl:when>
												<xsl:otherwise>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_total_services),  '###.##0,##', 'amount')" /> 
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="th3bold">
													<fo:block>
													<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
													</fo:block>
												</fo:table-cell> 
												</xsl:otherwise>
												</xsl:choose>
												<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
													<xsl:variable name="category" select="." />
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="th3bold">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="$sumRTotal = 0">
																		0
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>			
												
												
											
											</fo:table-row>
											
										</fo:table-body>
									</fo:table>
								</xsl:when>
								<xsl:otherwise>
									<fo:table table-layout="fixed" border-collapse="collapse"
										width="100%" margin-top="1cm">
										<fo:table-column column-width="7.65%"></fo:table-column>
										
										<xsl:for-each select="reportCategory/row">
											<fo:table-column column-width="7.65%"></fo:table-column>
										</xsl:for-each>				
										
										<fo:table-header >
											<fo:table-row>
											
											  <fo:table-cell text-align="center"
													xsl:use-attribute-sets="th1bold-left">
														<fo:block>Frequenz</fo:block>
												</fo:table-cell>
												<xsl:for-each select="reportCategory/row">
													<fo:table-cell text-align="center"
														xsl:use-attribute-sets="th1bold">
														<fo:block>%<xsl:value-of select="." /></fo:block>
													</fo:table-cell>
												</xsl:for-each>			
												
												
												
											
											</fo:table-row>
											</fo:table-header>
											<fo:table-body>
											<xsl:for-each select="/report/servicesRevenue/serviceRevenueList/row">
												<xsl:variable name="label" select="label" />
												<xsl:variable name="rTotal" select="r_total" />
												<fo:table-row >
										
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-style0">
														<fo:block>
															<xsl:value-of select="label" />
														</fo:block>
													</fo:table-cell>
													
													<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
														<xsl:variable name="category" select="." />
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="th1bold">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="$rTotal = 0">
																		0
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="format-number((/report/servicesRevenue/serviceRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>			
													
													
																
				
												</fo:table-row>
				
												
												
												
											</xsl:for-each>
											<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/serviceRevenueList/row/r_total)" />
											<fo:table-row>
											
											  <fo:table-cell text-align="left"
													xsl:use-attribute-sets="th3bold">
														<fo:block>Gesamt</fo:block>
												</fo:table-cell>
												<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
													<xsl:variable name="category" select="." />
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="th3bold">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="$sumRTotal = 0">
																		0
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="format-number(sum(/report/servicesRevenue/serviceRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>			
												
												
											
											</fo:table-row>
											
										</fo:table-body>
									</fo:table>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="report/servicesRevenue/employeeMode = 'allEmployees'">
								<xsl:for-each select="report/servicesRevenue/employeeRevenueList/row">
									<fo:block font-size="10pt">Mitarbeitername: <xsl:value-of select="employeeNm" /></fo:block>
									<xsl:variable name="employeeNm" select="employeeNm" />
									<xsl:if test="operatingEmployee = 'true'">
										<fo:block font-size="8pt">als ausführende Mitarbeiter</fo:block>
										<xsl:for-each select="/report/servicesRevenue/tableList/table">
											<xsl:variable name="tableNum" select="tableNum" />
											<xsl:choose>
											
												<xsl:when test="tableNum = 0">
													<fo:table table-layout="fixed" border-collapse="collapse"
														width="100%" margin-bottom="0.5cm">
														<xsl:choose>
														<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<xsl:for-each select="reportCategory/row">
																<fo:table-column column-width="7.65%"></fo:table-column>
															</xsl:for-each>				
															
															<fo:table-header >
																<fo:table-row>
																
																  <fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold-left">
																			<fo:block>Frequenz</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Arbeitstage</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz gesamt</fo:block>
																	</fo:table-cell> 
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Kunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Neukunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Gesamt-umsatz pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Gesamt-umsatz pro Kunde</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Gesamt-kunde pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>DL Pro Kunde</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>DL Pro Tag</fo:block>
																	</fo:table-cell>
																	<xsl:for-each select="reportCategory/row">
																		<fo:table-cell text-align="center"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>%<xsl:value-of select="." /></fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																	
																
																</fo:table-row>
																</fo:table-header>
														</xsl:when>
														<xsl:otherwise>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<xsl:for-each select="reportCategory/row">
																<fo:table-column column-width="7.65%"></fo:table-column>
															</xsl:for-each>				
															
															<fo:table-header >
																<fo:table-row>
																
																  <fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold-left">
																			<fo:block>Frequenz</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz gesamt</fo:block>
																	</fo:table-cell> 
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Kunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Neukunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz pro Kunde</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Kunde pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Anzahl DL gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Anzahl DL pro Kunde</fo:block>
																	</fo:table-cell>
																	<xsl:for-each select="reportCategory/row">
																		<fo:table-cell text-align="center"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>%<xsl:value-of select="." /></fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																	
																
																</fo:table-row>
																</fo:table-header>
														</xsl:otherwise>
													</xsl:choose>
														
															<fo:table-body>
															<xsl:for-each select="/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row">
																<xsl:variable name="label" select="label" />
																<xsl:variable name="rTotal" select="r_total" />
																<fo:table-row >
																	<xsl:choose>
																	<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
																		<fo:table-cell text-align="left"
																			xsl:use-attribute-sets="cell-style0">
																			<fo:block>
																				<xsl:value-of select="label" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_cnt_dt, '###.##0', 'amount')" />
																	
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
																	
																			</fo:block>
																		</fo:table-cell>
																		
																		
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
																			</fo:block>
																		</fo:table-cell>
																		
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				
																				<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
																			
																			</fo:block>
																		</fo:table-cell>
															
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
														
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
																			</fo:block>
																		</fo:table-cell>
																		
																	
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																		
																	
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_services_per_day, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:table-cell text-align="left"
																			xsl:use-attribute-sets="cell-style0">
																			<fo:block>
																				<xsl:value-of select="label" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
																	
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
																			</fo:block>
																		</fo:table-cell>
																		
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				
																				<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
																			
																			</fo:block>
																		</fo:table-cell>
															
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
														
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total_services, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																	
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																		
																	
																		
																	</xsl:otherwise>
																	</xsl:choose> 
																	
																	<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																		<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$rTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number((/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																				
								
																</fo:table-row>
								
																
																
																
															</xsl:for-each>
															
															<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total)" />
															<fo:table-row>
															
															  <fo:table-cell text-align="left"
																	xsl:use-attribute-sets="th3bold">
																		<fo:block>Gesamt</fo:block>
																</fo:table-cell>
																<xsl:choose>
																	<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_cnt_dt),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell> 
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_services_per_day),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell> 
																</xsl:when>
																<xsl:otherwise>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total_services),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell> 
																</xsl:otherwise>
																</xsl:choose>
																<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																	<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th3bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$sumRTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																
																
															
															</fo:table-row>
															
														</fo:table-body>
													</fo:table>
												</xsl:when>
												<xsl:otherwise>
													<fo:table table-layout="fixed" border-collapse="collapse"
														width="100%" margin-bottom="0.5cm">
														<fo:table-column column-width="7.65%"></fo:table-column>
														
														<xsl:for-each select="reportCategory/row">
															<fo:table-column column-width="7.65%"></fo:table-column>
														</xsl:for-each>				
														
														<fo:table-header >
															<fo:table-row>
															
															  <fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold-left">
																		<fo:block>Frequenz</fo:block>
																</fo:table-cell>
																<xsl:for-each select="reportCategory/row">
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>%<xsl:value-of select="." /></fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
																
																
																
															
															</fo:table-row>
															</fo:table-header>
															<fo:table-body>
															<xsl:for-each select="/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row">
																<xsl:variable name="label" select="label" />
																<xsl:variable name="rTotal" select="r_total" />
																<fo:table-row >
														
																	<fo:table-cell text-align="left"
																		xsl:use-attribute-sets="cell-style0">
																		<fo:block>
																			<xsl:value-of select="label" />
																		</fo:block>
																	</fo:table-cell>
																	
																	<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																		<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$rTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number((/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																				
								
																</fo:table-row>
								
																
																
																
															</xsl:for-each>
															<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_total)" />
															<fo:table-row>
															
															  <fo:table-cell text-align="left"
																	xsl:use-attribute-sets="th3bold">
																		<fo:block>Gesamt</fo:block>
																</fo:table-cell>
																<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																	<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th3bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$sumRTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/operatingRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																
																
															
															</fo:table-row>
															
														</fo:table-body>
													</fo:table>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</xsl:if>
									<xsl:if test="consultingEmployee = 'true'">
										<fo:block font-size="8pt">als beratende Mitarbeiter</fo:block>
										<xsl:for-each select="/report/servicesRevenue/tableList/table">
											<xsl:variable name="tableNum" select="tableNum" />
											<xsl:choose>
											
												<xsl:when test="tableNum = 0">
													<fo:table table-layout="fixed" border-collapse="collapse"
														width="100%" margin-bottom="0.5cm">
														<xsl:choose>
														<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<xsl:for-each select="reportCategory/row">
																<fo:table-column column-width="7.65%"></fo:table-column>
															</xsl:for-each>				
															
															<fo:table-header >
																<fo:table-row>
																
																  <fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold-left">
																			<fo:block>Frequenz</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Arbeitstage</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz gesamt</fo:block>
																	</fo:table-cell> 
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Kunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Neukunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Gesamt-umsatz pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Gesamt-umsatz pro Kunde</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Gesamt-kunde pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>DL Pro Kunde</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>DL Pro Tag</fo:block>
																	</fo:table-cell>
																	<xsl:for-each select="reportCategory/row">
																		<fo:table-cell text-align="center"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>%<xsl:value-of select="." /></fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																	
																
																</fo:table-row>
																</fo:table-header>
														</xsl:when>
														<xsl:otherwise>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<fo:table-column column-width="7.65%"></fo:table-column>
															<xsl:for-each select="reportCategory/row">
																<fo:table-column column-width="7.65%"></fo:table-column>
															</xsl:for-each>				
															
															<fo:table-header >
																<fo:table-row>
																
																  <fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold-left">
																			<fo:block>Frequenz</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz gesamt</fo:block>
																	</fo:table-cell> 
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Kunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Neukunden gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Umsatz pro Kunde</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Kunde pro Tag</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Anzahl DL gesamt</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>Anzahl DL pro Kunde</fo:block>
																	</fo:table-cell>
																	<xsl:for-each select="reportCategory/row">
																		<fo:table-cell text-align="center"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>%<xsl:value-of select="." /></fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																	
																
																</fo:table-row>
																</fo:table-header>
														</xsl:otherwise>
													</xsl:choose>
														
															<fo:table-body>
															<xsl:for-each select="/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row">
																<xsl:variable name="label" select="label" />
																<xsl:variable name="rTotal" select="r_total" />
																<fo:table-row >
																	<xsl:choose>
																	<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
																		<fo:table-cell text-align="left"
																			xsl:use-attribute-sets="cell-style0">
																			<fo:block>
																				<xsl:value-of select="label" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_cnt_dt, '###.##0', 'amount')" />
																	
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
																	
																			</fo:block>
																		</fo:table-cell>
																		
																		
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
																			</fo:block>
																		</fo:table-cell>
																		
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				
																				<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
																			
																			</fo:block>
																		</fo:table-cell>
															
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
														
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
																			</fo:block>
																		</fo:table-cell>
																		
																	
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																		
																	
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_services_per_day, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:table-cell text-align="left"
																			xsl:use-attribute-sets="cell-style0">
																			<fo:block>
																				<xsl:value-of select="label" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
																	
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
																			</fo:block>
																		</fo:table-cell>
																		
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				
																				<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
																			
																			</fo:block>
																		</fo:table-cell>
															
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
																			</fo:block>
																		</fo:table-cell>
														
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_total_services, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																	
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="cell-style">
																			<fo:block>
																				<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
																			</fo:block>
																		</fo:table-cell>
																		
																	
																		
																	</xsl:otherwise>
																	</xsl:choose> 
																	
																	<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																		<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$rTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number((/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																				
								
																</fo:table-row>
								
																
																
																
															</xsl:for-each>
															
															<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total)" />
															<fo:table-row>
															
															  <fo:table-cell text-align="left"
																	xsl:use-attribute-sets="th3bold">
																		<fo:block>Gesamt</fo:block>
																</fo:table-cell>
																<xsl:choose>
																	<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_cnt_dt),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell> 
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_services_per_day),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell> 
																</xsl:when>
																<xsl:otherwise>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total_services),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="right"
																	xsl:use-attribute-sets="th3bold">
																	<fo:block>
																	<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
																	</fo:block>
																</fo:table-cell> 
																</xsl:otherwise>
																</xsl:choose>
																<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																	<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th3bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$sumRTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																
																
															
															</fo:table-row>
															
														</fo:table-body>
													</fo:table>
												</xsl:when>
												<xsl:otherwise>
													<fo:table table-layout="fixed" border-collapse="collapse"
														width="100%" margin-bottom="0.5cm">
														<fo:table-column column-width="7.65%"></fo:table-column>
														
														<xsl:for-each select="reportCategory/row">
															<fo:table-column column-width="7.65%"></fo:table-column>
														</xsl:for-each>				
														
														<fo:table-header >
															<fo:table-row>
															
															  <fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold-left">
																		<fo:block>Frequenz</fo:block>
																</fo:table-cell>
																<xsl:for-each select="reportCategory/row">
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>%<xsl:value-of select="." /></fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
																
																
																
															
															</fo:table-row>
															</fo:table-header>
															<fo:table-body>
															<xsl:for-each select="/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row">
																<xsl:variable name="label" select="label" />
																<xsl:variable name="rTotal" select="r_total" />
																<fo:table-row >
														
																	<fo:table-cell text-align="left"
																		xsl:use-attribute-sets="cell-style0">
																		<fo:block>
																			<xsl:value-of select="label" />
																		</fo:block>
																	</fo:table-cell>
																	
																	<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																		<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th1bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$rTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number((/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																	
																	
																				
								
																</fo:table-row>
								
																
																
																
															</xsl:for-each>
															<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_total)" />
															<fo:table-row>
															
															  <fo:table-cell text-align="left"
																	xsl:use-attribute-sets="th3bold">
																		<fo:block>Gesamt</fo:block>
																</fo:table-cell>
																<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																	<xsl:variable name="category" select="." />
																		<fo:table-cell text-align="right"
																			xsl:use-attribute-sets="th3bold">
																			<fo:block>
																				<xsl:choose>
																					<xsl:when test="$sumRTotal = 0">
																						0
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/consultingRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																	</xsl:for-each>			
																
																
															
															</fo:table-row>
															
														</fo:table-body>
													</fo:table>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="report/servicesRevenue/employeeRevenueList/row">
									<fo:block font-size="10pt">Mitarbeitername: <xsl:value-of select="employeeNm" /></fo:block>
									<xsl:variable name="employeeNm" select="employeeNm" />
									<xsl:for-each select="/report/servicesRevenue/tableList/table">
										<xsl:variable name="tableNum" select="tableNum" />
										<xsl:choose>
										
											<xsl:when test="tableNum = 0">
												<fo:table table-layout="fixed" border-collapse="collapse"
													width="100%" margin-bottom="0.5cm">
													<xsl:choose>
													<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<xsl:for-each select="reportCategory/row">
															<fo:table-column column-width="7.65%"></fo:table-column>
														</xsl:for-each>				
														
														<fo:table-header >
															<fo:table-row>
															
															  <fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold-left">
																		<fo:block>Frequenz</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Arbeitstage</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Umsatz gesamt</fo:block>
																</fo:table-cell> 
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Kunden gesamt</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Neukunden gesamt</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Gesamt-umsatz pro Tag</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Gesamt-umsatz pro Kunde</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Gesamt-kunde pro Tag</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>DL Pro Kunde</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>DL Pro Tag</fo:block>
																</fo:table-cell>
																<xsl:for-each select="reportCategory/row">
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>%<xsl:value-of select="." /></fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
																
																
																
															
															</fo:table-row>
															</fo:table-header>
													</xsl:when>
													<xsl:otherwise>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<fo:table-column column-width="7.65%"></fo:table-column>
														<xsl:for-each select="reportCategory/row">
															<fo:table-column column-width="7.65%"></fo:table-column>
														</xsl:for-each>				
														
														<fo:table-header >
															<fo:table-row>
															
															  <fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold-left">
																		<fo:block>Frequenz</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Umsatz gesamt</fo:block>
																</fo:table-cell> 
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Kunden gesamt</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Neukunden gesamt</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Umsatz pro Tag</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Umsatz pro Kunde</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Kunde pro Tag</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Anzahl DL gesamt</fo:block>
																</fo:table-cell>
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>Anzahl DL pro Kunde</fo:block>
																</fo:table-cell>
																<xsl:for-each select="reportCategory/row">
																	<fo:table-cell text-align="center"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>%<xsl:value-of select="." /></fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
																
																
																
															
															</fo:table-row>
															</fo:table-header>
													</xsl:otherwise>
												</xsl:choose>
													
														<fo:table-body>
														<xsl:for-each select="/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row">
															<xsl:variable name="label" select="label" />
															<xsl:variable name="rTotal" select="r_total" />
															<fo:table-row >
																<xsl:choose>
																<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
																	<fo:table-cell text-align="left"
																		xsl:use-attribute-sets="cell-style0">
																		<fo:block>
																			<xsl:value-of select="label" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_cnt_dt, '###.##0', 'amount')" />
																
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
																
																		</fo:block>
																	</fo:table-cell>
																	
																	
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
																		</fo:block>
																	</fo:table-cell>
																	
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			
																			<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
																		
																		</fo:block>
																	</fo:table-cell>
														
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
																		</fo:block>
																	</fo:table-cell>
													
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
																		</fo:block>
																	</fo:table-cell>
																	
																
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
																		</fo:block>
																	</fo:table-cell>
																	
																
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_services_per_day, '###.##0,##', 'amount')" />	
																		</fo:block>
																	</fo:table-cell>
																</xsl:when>
																<xsl:otherwise>
																	<fo:table-cell text-align="left"
																		xsl:use-attribute-sets="cell-style0">
																		<fo:block>
																			<xsl:value-of select="label" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_amountcustomer, '###.##0', 'amount')" />
																
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_newcustomer, '###.##0', 'amount')" />
																		</fo:block>
																	</fo:table-cell>
																	
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			
																			<xsl:value-of select="format-number(r_total_per_day, '###.##0,00', 'money')" />
																		
																		</fo:block>
																	</fo:table-cell>
														
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_total_per_cus, '###.##0,00', 'money')" />
																		</fo:block>
																	</fo:table-cell>
													
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_amountcus_per_day, '###.##0,##', 'amount')" />							
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_total_services, '###.##0,##', 'amount')" />	
																		</fo:block>
																	</fo:table-cell>
																
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="format-number(r_services_per_cus, '###.##0,##', 'amount')" />	
																		</fo:block>
																	</fo:table-cell>
																	
																
																	
																</xsl:otherwise>
																</xsl:choose> 
																
																<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																	<xsl:variable name="category" select="." />
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when test="$rTotal = 0">
																					0
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="format-number((/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
																
																
																			
							
															</fo:table-row>
							
															
															
															
														</xsl:for-each>
														
														<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total)" />
														<fo:table-row>
														
														  <fo:table-cell text-align="left"
																xsl:use-attribute-sets="th3bold">
																	<fo:block>Gesamt</fo:block>
															</fo:table-cell>
															<xsl:choose>
																<xsl:when test="/report/servicesRevenue/itemReportMode = 'reportCat'">
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_cnt_dt),  '###.##0', 'amount')" /> 
																</fo:block>
															</fo:table-cell> 
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_services_per_day),  '###.##0,##', 'amount')" /> 
																</fo:block>
															</fo:table-cell> 
															</xsl:when>
															<xsl:otherwise>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total),  '###.##0,00', 'money')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_amountcustomer),  '###.##0', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_newcustomer),  '###.##0', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total_per_day),  '###.##0,00', 'money')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total_per_cus),  '###.##0,00', 'money')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_amountcus_per_day),  '###.##0,##', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total_services),  '###.##0,##', 'amount')" /> 
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="th3bold">
																<fo:block>
																<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_services_per_cus),  '###.##0,##', 'amount')" /> 
																</fo:block>
															</fo:table-cell> 
															</xsl:otherwise>
															</xsl:choose>
															<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																<xsl:variable name="category" select="." />
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="th3bold">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when test="$sumRTotal = 0">
																					0
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
															
															
														
														</fo:table-row>
														
													</fo:table-body>
												</fo:table>
											</xsl:when>
											<xsl:otherwise>
												<fo:table table-layout="fixed" border-collapse="collapse"
													width="100%" margin-bottom="0.5cm">
													<fo:table-column column-width="7.65%"></fo:table-column>
													
													<xsl:for-each select="reportCategory/row">
														<fo:table-column column-width="7.65%"></fo:table-column>
													</xsl:for-each>				
													
													<fo:table-header >
														<fo:table-row>
														
														  <fo:table-cell text-align="center"
																xsl:use-attribute-sets="th1bold-left">
																	<fo:block>Frequenz</fo:block>
															</fo:table-cell>
															<xsl:for-each select="reportCategory/row">
																<fo:table-cell text-align="center"
																	xsl:use-attribute-sets="th1bold">
																	<fo:block>%<xsl:value-of select="." /></fo:block>
																</fo:table-cell>
															</xsl:for-each>			
															
															
															
														
														</fo:table-row>
														</fo:table-header>
														<fo:table-body>
														<xsl:for-each select="/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row">
															<xsl:variable name="label" select="label" />
															<xsl:variable name="rTotal" select="r_total" />
															<fo:table-row >
													
																<fo:table-cell text-align="left"
																	xsl:use-attribute-sets="cell-style0">
																	<fo:block>
																		<xsl:value-of select="label" />
																	</fo:block>
																</fo:table-cell>
																
																<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																	<xsl:variable name="category" select="." />
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="th1bold">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when test="$rTotal = 0">
																					0
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="format-number((/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row[label = $label]/r_categories/r_category[category = $category]/value) div $rTotal * 100, '###.##0', 'amount')" />
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
																
																
																			
							
															</fo:table-row>
							
															
															
															
														</xsl:for-each>
														<xsl:variable name="sumRTotal" select="sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_total)" />
														<fo:table-row>
														
														  <fo:table-cell text-align="left"
																xsl:use-attribute-sets="th3bold">
																	<fo:block>Gesamt</fo:block>
															</fo:table-cell>
															<xsl:for-each select="/report/servicesRevenue/tableList/table[tableNum = $tableNum]/reportCategory/row">
																<xsl:variable name="category" select="." />
																	<fo:table-cell text-align="right"
																		xsl:use-attribute-sets="th3bold">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when test="$sumRTotal = 0">
																					0
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="format-number(sum(/report/servicesRevenue/employeeRevenueList/row[employeeNm = $employeeNm]/serviceRevenueList/row/r_categories/r_category[category = $category]/value) div $sumRTotal * 100, '###.##0', 'amount')" />
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</xsl:for-each>			
															
															
														
														</fo:table-row>
														
													</fo:table-body>
												</fo:table>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				
					
					
					
					<fo:block id="LastPage"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
