<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt"
	xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." />

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="Voucher" page-height="25mm" page-width="54mm" margin-top="3mm" margin-bottom="0mm" margin-left="4mm" margin-right="0mm">
					<fo:region-body margin-top="0mm" margin-bottom="0mm" margin-left="mm" margin-right="mm" />
					<fo:region-before region-name="header" extent="7mm" />
					<fo:region-after region-name="footer" extent="7mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="Voucher">
				<fo:static-content flow-name="header">
					<fo:block text-align="center">
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block text-align="center">
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block-container width="54mm">
						<fo:block text-align="center" font-size="8pt">
							<fo:instream-foreign-object>
								<xsl:variable name="barcode-cfg">
									<barcode>
										<code128>
											<human-readable>none</human-readable>
											<height>20mm</height>
											<module-width>0.25mm</module-width>
											<quiet-zone enabled="true" />
										</code128>
									</barcode>
								</xsl:variable>
								<xsl:copy-of select="barcode:generate($barcode-cfg, /SalesVoucher/salesVoucherCd)" />
							</fo:instream-foreign-object>
						</fo:block>
						<fo:block font-size="6pt" text-align="center"><xsl:value-of select="/SalesVoucher/salesVoucherCd"/>/
							<xsl:choose>
								<xsl:when test='/SalesVoucher/buCountryCd="CH"'>
									<xsl:value-of select='format-number(/SalesVoucher/voucherValue, "###.##0,00", "money")' />&#160;CHF
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select='format-number(/SalesVoucher/voucherValue, "###.##0,00", "money")' />&#160;€
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>